/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class OrderLimitOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings2) {
        tupleExpr.visit(new OrderOptimizer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OrderOptimizer
    extends QueryModelVisitorBase<RuntimeException> {
        private boolean variablesProjected = true;
        private Projection projection;

        protected OrderOptimizer() {
        }

        @Override
        public void meet(Projection node) {
            this.projection = node;
            node.getArg().visit(this);
            this.projection = null;
        }

        @Override
        public void meet(Order node) {
            QueryModelNode parent;
            for (OrderElem e2 : node.getElements()) {
                e2.visit(this);
            }
            if (this.variablesProjected && this.projection == (parent = node.getParentNode())) {
                node.replaceWith(node.getArg().clone());
                node.setArg(this.projection.clone());
                Order replacement = node.clone();
                this.projection.replaceWith(replacement);
                QueryModelNode distinct = replacement.getParentNode();
                if (distinct instanceof Distinct) {
                    distinct.replaceWith(new Reduced(replacement.clone()));
                }
            }
        }

        @Override
        public void meet(Var node) {
            if (this.projection != null) {
                boolean projected = false;
                for (ProjectionElem e2 : this.projection.getProjectionElemList().getElements()) {
                    String source = e2.getSourceName();
                    String target = e2.getTargetName();
                    if (!node.getName().equals(source) || !node.getName().equals(target)) continue;
                    projected = true;
                    break;
                }
                if (!projected) {
                    this.variablesProjected = false;
                }
            }
        }
    }
}

