/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.datetime;

import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;

public class Timezone
implements Function {
    public String getURI() {
        return ((Object)FN.TIMEZONE_FROM_DATETIME).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("TIMEZONE requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            URI datatype = literal.getDatatype();
            if (datatype != null && XMLDatatypeUtil.isCalendarDatatype(datatype)) {
                try {
                    XMLGregorianCalendar calValue = literal.calendarValue();
                    int timezoneOffset = calValue.getTimezone();
                    if (Integer.MIN_VALUE != timezoneOffset) {
                        int minutes = Math.abs(timezoneOffset);
                        int hours = minutes / 60;
                        minutes -= hours * 60;
                        StringBuilder tzDuration = new StringBuilder();
                        if (timezoneOffset < 0) {
                            tzDuration.append("-");
                        }
                        tzDuration.append("PT");
                        if (hours > 0) {
                            tzDuration.append(hours + "H");
                        }
                        if (minutes > 0) {
                            tzDuration.append(minutes + "M");
                        }
                        if (timezoneOffset == 0) {
                            tzDuration.append("0S");
                        }
                        return valueFactory.createLiteral(tzDuration.toString(), XMLSchema.DAYTIMEDURATION);
                    }
                    throw new ValueExprEvaluationException("can not determine timezone from value: " + argValue);
                }
                catch (IllegalArgumentException e2) {
                    throw new ValueExprEvaluationException("illegal calendar value: " + argValue);
                }
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

