/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function;

import java.math.BigInteger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class IntegerCast
implements Function {
    public String getURI() {
        return ((Object)XMLSchema.INTEGER).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("xsd:integer cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            URI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String integerValue = XMLDatatypeUtil.collapseWhiteSpace(literal.getLabel());
                if (XMLDatatypeUtil.isValidInteger(integerValue)) {
                    return valueFactory.createLiteral(integerValue, XMLSchema.INTEGER);
                }
            } else if (datatype != null) {
                if (((Object)datatype).equals(XMLSchema.INTEGER)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isNumericDatatype(datatype)) {
                    try {
                        BigInteger integerValue = literal.integerValue();
                        return valueFactory.createLiteral(integerValue.toString(), XMLSchema.INTEGER);
                    }
                    catch (NumberFormatException e2) {
                        throw new ValueExprEvaluationException(e2.getMessage(), e2);
                    }
                }
                if (((Object)datatype).equals(XMLSchema.BOOLEAN)) {
                    try {
                        return valueFactory.createLiteral(literal.booleanValue() ? "1" : "0", XMLSchema.INTEGER);
                    }
                    catch (IllegalArgumentException e3) {
                        throw new ValueExprEvaluationException(e3.getMessage(), e3);
                    }
                }
            }
        }
        throw new ValueExprEvaluationException("Invalid argument for xsd:integer cast: " + args[0]);
    }
}

