/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function;

import java.math.BigDecimal;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class DecimalCast
implements Function {
    public String getURI() {
        return ((Object)XMLSchema.DECIMAL).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("xsd:decimal cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            URI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String decimalValue = XMLDatatypeUtil.collapseWhiteSpace(literal.getLabel());
                if (XMLDatatypeUtil.isValidDecimal(decimalValue)) {
                    return valueFactory.createLiteral(decimalValue, XMLSchema.DECIMAL);
                }
            } else if (datatype != null) {
                if (((Object)datatype).equals(XMLSchema.DECIMAL)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isNumericDatatype(datatype)) {
                    try {
                        BigDecimal decimalValue = literal.decimalValue();
                        return valueFactory.createLiteral(decimalValue.toPlainString(), XMLSchema.DECIMAL);
                    }
                    catch (NumberFormatException e2) {
                        throw new ValueExprEvaluationException(e2.getMessage(), e2);
                    }
                }
                if (((Object)datatype).equals(XMLSchema.BOOLEAN)) {
                    try {
                        return valueFactory.createLiteral(literal.booleanValue() ? "1.0" : "0.0", XMLSchema.DECIMAL);
                    }
                    catch (IllegalArgumentException e3) {
                        throw new ValueExprEvaluationException(e3.getMessage(), e3);
                    }
                }
            }
        }
        throw new ValueExprEvaluationException("Invalid argument for xsd:decimal cast: " + args[0]);
    }
}

