/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository.namespaces;

import info.aduna.webapp.views.EmptySuccessView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.server.ClientHTTPException;
import org.openrdf.http.server.ProtocolUtil;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.RepositoryInterceptor;
import org.openrdf.http.server.repository.TupleQueryResultView;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.query.impl.ListBindingSet;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class NamespacesController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public NamespacesController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reqMethod = request.getMethod();
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET namespace list");
            return this.getExportNamespacesResult(request, response);
        }
        if ("DELETE".equals(reqMethod)) {
            this.logger.info("DELETE namespaces");
            return this.getClearNamespacesResult(request, response);
        }
        throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView getExportNamespacesResult(HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException, ServerHTTPException {
        List<String> columnNames = Arrays.asList("prefix", "namespace");
        ArrayList<ListBindingSet> namespaces = new ArrayList<ListBindingSet>();
        RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
        try {
            RepositoryResult<Namespace> iter = repositoryCon.getNamespaces();
            try {
                while (iter.hasNext()) {
                    Namespace ns = (Namespace)iter.next();
                    LiteralImpl prefix = new LiteralImpl(ns.getPrefix());
                    LiteralImpl namespace2 = new LiteralImpl(ns.getName());
                    ListBindingSet bindingSet = new ListBindingSet(columnNames, prefix, namespace2);
                    namespaces.add(bindingSet);
                }
            }
            finally {
                iter.close();
            }
        }
        catch (RepositoryException e2) {
            throw new ServerHTTPException("Repository error: " + e2.getMessage(), (Throwable)e2);
        }
        TupleQueryResultWriterFactory factory = ProtocolUtil.getAcceptableService(request, response, TupleQueryResultWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("queryResult", new TupleQueryResultImpl(columnNames, namespaces));
        model.put("filenameHint", "namespaces");
        model.put("factory", factory);
        return new ModelAndView((View)TupleQueryResultView.getInstance(), model);
    }

    private ModelAndView getClearNamespacesResult(HttpServletRequest request, HttpServletResponse response) throws ServerHTTPException {
        RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
        try {
            repositoryCon.clearNamespaces();
        }
        catch (RepositoryException e2) {
            throw new ServerHTTPException("Repository error: " + e2.getMessage(), (Throwable)e2);
        }
        return new ModelAndView((View)EmptySuccessView.getInstance());
    }
}

