/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.pipeline.inf;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;
import org.openjena.riot.pipeline.inf.InferenceSetupRDFS;
import org.openjena.riot.pipeline.inf.Processor;

abstract class InferenceProcessorRDFS
implements Processor {
    static final Node rdfType = RDF.type.asNode();
    private final InferenceSetupRDFS state;

    public InferenceProcessorRDFS(InferenceSetupRDFS state) {
        this.state = state;
    }

    @Override
    public void process(Node s, Node p, Node o) {
        this.subClass(s, p, o);
        this.subProperty(s, p, o);
        this.domain(s, p, o);
        this.range(s, p, o);
    }

    public abstract void derive(Node var1, Node var2, Node var3);

    private final void subClass(Node s, Node p, Node o) {
        List<Node> x;
        if (p.equals(rdfType) && (x = this.state.transClasses.get(o)) != null) {
            for (Node c : x) {
                this.derive(s, p, c);
            }
        }
    }

    private void subProperty(Node s, Node p, Node o) {
        List<Node> x = this.state.transProperties.get(p);
        if (x != null) {
            for (Node p2 : x) {
                this.derive(s, p2, o);
            }
        }
    }

    private final void domain(Node s, Node p, Node o) {
        List<Node> x = this.state.domainList.get(p);
        if (x != null) {
            for (Node c : x) {
                this.derive(s, rdfType, c);
                this.subClass(s, rdfType, c);
            }
        }
    }

    private final void range(Node s, Node p, Node o) {
        if (o.isLiteral()) {
            return;
        }
        List<Node> x = this.state.rangeList.get(p);
        if (x != null) {
            for (Node c : x) {
                this.derive(o, rdfType, c);
                this.subClass(o, rdfType, c);
            }
        }
    }
}

