/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import jp.ac.osaka_u.sanken.util.EditableListItem;

public class EditableList
extends JPanel {
    private static final long serialVersionUID = 8390493649442688888L;
    private EditableListList list;
    private JTextField textField;

    public EditableList() {
        this(new DefaultListModel());
    }

    public EditableList(ListModel model) {
        this.list = new EditableListList(model);
        this.list.setFixedCellHeight(26);
        this.initialize();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.list.addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.list.removeListSelectionListener(l);
    }

    public ListModel getModel() {
        return this.list.getModel();
    }

    public JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    EditableList.this.addCurrentItem();
                }
            });
        }
        return this.textField;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.list, "Center");
        this.add((Component)this.getTextField(), "South");
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, this.list.getModel().getSize() * this.list.getFixedCellHeight() + this.getTextField().getPreferredSize().height);
    }

    private void addCurrentItem() {
        String word = this.getTextField().getText();
        if (word.trim().isEmpty()) {
            return;
        }
        boolean exists = false;
        int i = 0;
        while (i < this.list.getModel().getSize()) {
            Object obj = this.list.getModel().getElementAt(i);
            if (obj.toString().equals(word)) {
                exists = true;
                break;
            }
            ++i;
        }
        if (!exists) {
            ((DefaultListModel)this.list.getModel()).addElement(new EditableListItem(word, true));
            this.getTextField().setText("");
        }
    }

    class EditableCellRenderer
    extends JPanel
    implements ListCellRenderer,
    MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 5134902478737266926L;
        private final JRadioButton button = new JRadioButton(new ImageIcon(this.getClass().getResource("x.png")));

        public EditableCellRenderer() {
            this.button.setSelectedIcon(new ImageIcon(this.getClass().getResource("blank.png")));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof EditableListItem) {
                this.button.setSelected(!((EditableListItem)value).deleteable);
            } else {
                this.button.setSelected(false);
            }
            this.button.setBackground(list.getBackground());
            this.button.setForeground(list.getForeground());
            this.button.setText(value.toString());
            JRadioButton ret = this.button;
            return ret;
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (e2.getButton() == 1) {
                JList l = (JList)e2.getComponent();
                DefaultListModel m = (DefaultListModel)l.getModel();
                Point p = e2.getPoint();
                int index = l.locationToIndex(p);
                if (index >= 0) {
                    Object value = m.get(index);
                    if (value instanceof EditableListItem && !((EditableListItem)value).deleteable) {
                        return;
                    }
                    ((DefaultListModel)l.getModel()).remove(index);
                    Rectangle rect = l.getCellBounds(index, index);
                    if (rect != null) {
                        l.repaint(rect);
                    }
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
        }
    }

    class EditableListList
    extends JList {
        private static final long serialVersionUID = -8207275088256642406L;
        private EditableCellRenderer renderer;

        public EditableListList() {
            this.putClientProperty("List.isFileList", Boolean.TRUE);
        }

        public EditableListList(ListModel model) {
            super(model);
            this.putClientProperty("List.isFileList", Boolean.TRUE);
        }

        @Override
        public void updateUI() {
            this.setForeground(null);
            this.setBackground(null);
            this.setSelectionForeground(null);
            this.setSelectionBackground(null);
            if (this.renderer != null) {
                this.removeMouseListener(this.renderer);
                this.removeMouseMotionListener(this.renderer);
            }
            super.updateUI();
            this.renderer = new EditableCellRenderer();
            this.setCellRenderer(this.renderer);
            this.addMouseListener(this.renderer);
            this.addMouseMotionListener(this.renderer);
        }

        private boolean pointOutsidePrefSize(Point p) {
            int index = this.locationToIndex(p);
            DefaultListModel m = (DefaultListModel)this.getModel();
            if (index < 0) {
                return false;
            }
            Object n = m.get(index);
            Component c = this.getCellRenderer().getListCellRendererComponent(this, n, index, false, false);
            c.doLayout();
            Dimension d = c.getPreferredSize();
            Rectangle rect = this.getCellBounds(index, index);
            rect.width = d.width;
            return index < 0 || !rect.contains(p);
        }

        @Override
        protected void processMouseEvent(MouseEvent e2) {
            if (!this.pointOutsidePrefSize(e2.getPoint())) {
                super.processMouseEvent(e2);
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e2) {
            if (!this.pointOutsidePrefSize(e2.getPoint())) {
                super.processMouseMotionEvent(e2);
            } else {
                e2 = new MouseEvent((Component)e2.getSource(), 505, e2.getWhen(), e2.getModifiers(), e2.getX(), e2.getY(), e2.getXOnScreen(), e2.getYOnScreen(), e2.getClickCount(), e2.isPopupTrigger(), 0);
                super.processMouseEvent(e2);
            }
        }
    }
}

