/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.util;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jp.ac.osaka_u.sanken.util.CheckableListItem;

class CheckBoxCellRenderer
extends JCheckBox
implements ListCellRenderer,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 5134902478737266926L;
    private int rollOverRowIndex = -1;

    CheckBoxCellRenderer() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setOpaque(true);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value instanceof CheckableListItem) {
            this.setSelected(((CheckableListItem)value).selected);
            this.getModel().setRollover(index == this.rollOverRowIndex);
        }
        this.setText(value.toString());
        return this;
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        JList l = (JList)e2.getSource();
        if (this.rollOverRowIndex >= 0) {
            l.repaint(l.getCellBounds(this.rollOverRowIndex, this.rollOverRowIndex));
            this.rollOverRowIndex = -1;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (e2.getButton() == 1) {
            JList l = (JList)e2.getComponent();
            DefaultListModel m = (DefaultListModel)l.getModel();
            Point p = e2.getPoint();
            int index = l.locationToIndex(p);
            if (index >= 0) {
                CheckableListItem n = (CheckableListItem)m.get(index);
                m.set(index, new CheckableListItem(n.text, !n.selected));
                l.repaint(l.getCellBounds(index, index));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        JList l = (JList)e2.getSource();
        int index = l.locationToIndex(e2.getPoint());
        if (index != this.rollOverRowIndex) {
            this.rollOverRowIndex = index;
            l.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }
}

