/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.plugin.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.plugin.compare.CompareResultListener;
import jp.ac.osaka_u.sanken.sparql.plugin.compare.CompareSubject;

public class CompareSubjectPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField epPropsTextField = null;
    private JButton endpointsButton = null;
    private JTextField resourceCsvField = null;
    private JButton wordsButton = null;
    private JScrollPane logScrollPane = null;
    private JTextArea logTextArea = null;
    private JLabel epPropLabel = null;
    private JLabel resourceCsvLabel = null;
    private JButton executeButton = null;
    private JPanel optPanel = null;
    private JLabel outputLabel = null;
    private JTextField outputTextField = null;
    private JButton outputRefButton = null;
    private Component parent;
    CompareSubject compare = null;

    public CompareSubjectPanel(Component parent) {
        this.initialize();
        this.parent = parent;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
        gridBagConstraints111.gridx = 2;
        gridBagConstraints111.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints111.gridy = 3;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.gridy = 3;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints10.gridx = 1;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 3;
        this.outputLabel = new JLabel("Output File");
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridwidth = 3;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.gridy = 4;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints5.gridy = 2;
        this.resourceCsvLabel = new JLabel();
        this.resourceCsvLabel.setText("resource csv File");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints4.gridy = 0;
        this.epPropLabel = new JLabel();
        this.epPropLabel.setText("Endpoint-property List File");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.gridx = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridy = 2;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints11.gridx = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints1.gridx = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(14, 10, 5, 0);
        gridBagConstraints.gridx = 1;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getEpPropsTextField(), gridBagConstraints);
        this.add((Component)this.getEndpointsButton(), gridBagConstraints1);
        this.add((Component)this.getResourceCsvField(), gridBagConstraints11);
        this.add((Component)this.getWordsButton(), gridBagConstraints2);
        this.add((Component)this.getLogScrollPane(), gridBagConstraints3);
        this.add((Component)this.epPropLabel, gridBagConstraints4);
        this.add((Component)this.resourceCsvLabel, gridBagConstraints5);
        this.add((Component)this.getOptPanel(), gridBagConstraints8);
        this.add((Component)this.outputLabel, gridBagConstraints9);
        this.add((Component)this.getOutputTextField(), gridBagConstraints10);
        this.add((Component)this.getOutputRefButton(), gridBagConstraints111);
    }

    private JTextField getEpPropsTextField() {
        if (this.epPropsTextField == null) {
            this.epPropsTextField = new JTextField();
            this.epPropsTextField.setEditable(false);
        }
        return this.epPropsTextField;
    }

    private JButton getEndpointsButton() {
        if (this.endpointsButton == null) {
            this.endpointsButton = new JButton("Ref");
            this.endpointsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CompareSubjectPanel.this.selectFile(CompareSubjectPanel.this.getEpPropsTextField(), 0);
                    CompareSubjectPanel.this.validateExecute();
                }
            });
        }
        return this.endpointsButton;
    }

    private JTextField getResourceCsvField() {
        if (this.resourceCsvField == null) {
            this.resourceCsvField = new JTextField();
            this.resourceCsvField.setEditable(false);
        }
        return this.resourceCsvField;
    }

    private JButton getWordsButton() {
        if (this.wordsButton == null) {
            this.wordsButton = new JButton("Ref");
            this.wordsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CompareSubjectPanel.this.selectFile(CompareSubjectPanel.this.getResourceCsvField(), 0);
                    CompareSubjectPanel.this.validateExecute();
                }
            });
        }
        return this.wordsButton;
    }

    private JScrollPane getLogScrollPane() {
        if (this.logScrollPane == null) {
            this.logScrollPane = new JScrollPane();
            this.logScrollPane.setViewportView(this.getLogTextArea());
        }
        return this.logScrollPane;
    }

    private JTextArea getLogTextArea() {
        if (this.logTextArea == null) {
            this.logTextArea = new JTextArea();
            this.logTextArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                }

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                }

                @Override
                public void insertUpdate(DocumentEvent e2) {
                    final Document doc = CompareSubjectPanel.this.logTextArea.getDocument();
                    final Element root = doc.getDefaultRootElement();
                    if (root.getElementCount() <= 100) {
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.removeLines(doc, root);
                        }
                    });
                    CompareSubjectPanel.this.logTextArea.setCaretPosition(doc.getLength());
                }

                private void removeLines(Document doc, Element root) {
                    Element fl = root.getElement(0);
                    try {
                        doc.remove(0, fl.getEndOffset());
                    }
                    catch (BadLocationException ble) {
                        System.out.println(ble);
                    }
                }
            });
        }
        return this.logTextArea;
    }

    void addLogText(String log) {
        String[] logs;
        String[] stringArray = logs = log.split("\n");
        int n = logs.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            this.getLogTextArea().append(l);
            ++n2;
        }
        if (log.endsWith("\n")) {
            this.getLogTextArea().append("\n");
        }
        this.getLogTextArea().setCaretPosition(this.getLogTextArea().getDocument().getLength());
    }

    private JButton getExecuteButton() {
        if (this.executeButton == null) {
            this.executeButton = new JButton("Execute");
            this.executeButton.setEnabled(false);
            this.executeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (CompareSubjectPanel.this.getExecuteButton().getText().equals("Execute")) {
                        CompareSubjectPanel.this.setProcessing(true);
                        CompareSubjectPanel.this.doCompare();
                    } else {
                        CompareSubjectPanel.this.executeButton.setEnabled(false);
                        CompareSubjectPanel.this.doStop();
                    }
                }
            });
        }
        return this.executeButton;
    }

    private JPanel getOptPanel() {
        if (this.optPanel == null) {
            this.optPanel = new JPanel();
            this.optPanel.setLayout(new BorderLayout());
            this.optPanel.add((Component)this.getExecuteButton(), "East");
        }
        return this.optPanel;
    }

    private void selectFile(JTextField tf, int dialogType) {
        JFileChooser fileChooser = new JFileChooser("./");
        fileChooser.setDialogType(dialogType);
        int result = fileChooser.showOpenDialog(this);
        File file = fileChooser.getSelectedFile();
        if (result == 1 || file == null) {
            return;
        }
        try {
            tf.setText(file.getCanonicalPath());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void validateExecute() {
        boolean enable = true;
        if (this.getEpPropsTextField().getText().isEmpty() || this.getResourceCsvField().getText().isEmpty() || this.getOutputTextField().getText().isEmpty()) {
            enable = false;
        }
        this.getExecuteButton().setEnabled(enable);
    }

    private void doCompare() {
        this.compare = new CompareSubject(new File(this.getResourceCsvField().getText()), new File(this.getEpPropsTextField().getText()), new SparqlQueryListener(){

            @Override
            public void sparqlExecuted(String query2) {
                CompareSubjectPanel.this.addLogText(query2);
            }
        });
        this.compare.outputResult(new File(this.getOutputTextField().getText()), new CompareResultListener(){

            @Override
            public void uncaughtException(Thread thread, Throwable e2) {
                JOptionPane.showMessageDialog(CompareSubjectPanel.this.parent, "Execute error:" + e2.getMessage(), "Error", 0);
                CompareSubjectPanel.this.setProcessing(false);
            }

            @Override
            public void resultReceived(boolean result) {
                CompareSubjectPanel.this.setProcessing(false);
            }
        });
    }

    private void doStop() {
        if (this.compare != null) {
            this.compare.stop();
        }
    }

    private void setProcessing(boolean isProcess) {
        this.getEndpointsButton().setEnabled(!isProcess);
        this.getWordsButton().setEnabled(!isProcess);
        this.getOutputRefButton().setEnabled(!isProcess);
        if (isProcess) {
            this.getExecuteButton().setText("Stop");
        } else {
            this.getExecuteButton().setText("Execute");
        }
        this.getExecuteButton().setEnabled(true);
    }

    private JTextField getOutputTextField() {
        if (this.outputTextField == null) {
            this.outputTextField = new JTextField();
            this.outputTextField.setEditable(false);
        }
        return this.outputTextField;
    }

    private JButton getOutputRefButton() {
        if (this.outputRefButton == null) {
            this.outputRefButton = new JButton("Ref");
            this.outputRefButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    CompareSubjectPanel.this.selectFile(CompareSubjectPanel.this.getOutputTextField(), 1);
                    CompareSubjectPanel.this.validateExecute();
                }
            });
        }
        return this.outputRefButton;
    }
}

