/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.plugin.compare;

import com.hp.hpl.jena.rdf.model.RDFNode;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.EndpointSettingsManager;
import jp.ac.osaka_u.sanken.sparql.PlainSparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.plugin.compare.CompareResultListener;
import jp.ac.osaka_u.sanken.sparql.plugin.compare.FileUtil;

public class CompareSubject {
    private File csvFile;
    private File propertyFile;
    private HashMap<String, PlainSparqlAccessor> accessorMap;
    private static final String SEPARATOR = ",";
    private Thread thread;
    private boolean finalizeThread = false;
    private SparqlQueryListener listener;

    public CompareSubject(File csvFile, File endpointFile) {
        this(csvFile, endpointFile, null);
    }

    public CompareSubject(File csvFile, File endpointFile, SparqlQueryListener listener) {
        this.csvFile = csvFile;
        this.propertyFile = endpointFile;
        this.listener = listener;
        this.accessorMap = new HashMap();
    }

    public void outputResult(File out, CompareResultListener listener) {
        this.thread = new QueryThread(new Object[]{out}, listener){

            @Override
            public void run() {
                try {
                    File file = (File)((Object[])this.getOption())[0];
                    this.getCompareResultListener().resultReceived(CompareSubject.this.outputResult(file));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        this.thread.setUncaughtExceptionHandler(listener);
        this.thread.start();
    }

    private boolean outputResult(File out) throws IOException {
        if (out.getParentFile() != null && !out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        out.createNewFile();
        if (!out.canWrite()) {
            return false;
        }
        return this.outputResult(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), "SJIS")));
    }

    public void stop() {
        this.println(String.valueOf(this.getCurrentTime()) + "Stop Request");
        this.finalizeThread = true;
    }

    private boolean outputResult(PrintWriter out) {
        HashMap<String, List<String>> propertyHash = this.readPropertyFile();
        this.getResources(propertyHash, out);
        out.flush();
        out.close();
        this.println(String.valueOf(this.getCurrentTime()) + "query end.");
        return true;
    }

    private HashMap<String, List<String>> readPropertyFile() {
        HashMap<String, List<String>> propertyHash = new HashMap<String, List<String>>();
        List<String> contents = FileUtil.readFileText(this.propertyFile, "UTF-8");
        for (String line : contents) {
            List<String> property = FileUtil.splitLine(line, SEPARATOR);
            if (property == null || property.size() <= 1) continue;
            ArrayList<String> properties = new ArrayList<String>();
            propertyHash.put(property.get(0), properties);
            int i = 1;
            while (i < property.size()) {
                properties.add(property.get(i));
                ++i;
            }
        }
        return propertyHash;
    }

    private void println() {
        this.println("");
    }

    private void println(String str2) {
        this.print(String.valueOf(str2) + "\n");
    }

    private void print(String str2) {
        if (this.listener != null) {
            this.listener.sparqlExecuted(str2);
        }
    }

    private void getResources(HashMap<String, List<String>> propertyHash, PrintWriter out) {
        List<String> endpoints = null;
        List<String> files = FileUtil.readFileText(this.csvFile, "SJIS");
        this.println();
        this.println(String.valueOf(this.getCurrentTime()) + "query start.");
        if (files != null && files.size() > 0) {
            endpoints = this.getEndpoints(files.get(0));
            this.setEndpoint(endpoints);
        }
        StringBuilder line = new StringBuilder();
        line.append("");
        line.append(SEPARATOR);
        for (String endpoint : endpoints) {
            line.append(endpoint);
            line.append(SEPARATOR);
            line.append("");
            line.append(SEPARATOR);
            line.append("");
            line.append(SEPARATOR);
        }
        out.append(line.toString());
        out.append("\n");
        int i = 1;
        while (i < files.size()) {
            if (this.finalizeThread) break;
            this.getResource(endpoints, FileUtil.splitLine(files.get(i), SEPARATOR), propertyHash, out);
            ++i;
        }
    }

    private void getResource(List<String> endpoints, List<String> contents, HashMap<String, List<String>> propertyHash, PrintWriter out) {
        int index = 1;
        int max2 = 0;
        String label = contents.get(0);
        ArrayList ret = new ArrayList();
        this.print(String.valueOf(this.getCurrentTime()) + "searching [" + label + "]");
        for (String endpoint : endpoints) {
            this.print("*");
            HashMap<String, String> properToResultHash = new HashMap<String, String>();
            ret.add(properToResultHash);
            List<String> list = propertyHash.get(endpoint);
            if (list != null) {
                HashMap<String, List<String>> results = this.getResource(endpoint, contents.get(index), list);
                if (max2 < results.size()) {
                    max2 = results.size();
                }
                for (String property : results.keySet()) {
                    String result = this.getResult(results.get(property));
                    properToResultHash.put(property, result);
                }
            }
            ++index;
        }
        this.println();
        int i = 0;
        while (i < max2) {
            StringBuilder line = new StringBuilder();
            line.append(label);
            line.append(SEPARATOR);
            int lp = 1;
            for (HashMap hashMap : ret) {
                String[] hoge = hashMap.keySet().toArray(new String[0]);
                if (hoge.length > i && !contents.get(lp).trim().isEmpty()) {
                    String resultProperty = hoge[i];
                    String resultObject = (String)hashMap.get(resultProperty);
                    line.append(contents.get(lp));
                    line.append(SEPARATOR);
                    line.append(resultProperty);
                    line.append(SEPARATOR);
                    line.append(resultObject);
                    line.append(SEPARATOR);
                } else {
                    line.append(SEPARATOR);
                    line.append(SEPARATOR);
                    line.append(SEPARATOR);
                }
                ++lp;
            }
            out.append(line.toString());
            out.append("\n");
            ++i;
        }
    }

    private String getResult(List<String> result) {
        if (result.size() == 0) {
            return "";
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < result.size() - 1) {
            sb.append(result.get(i));
            sb.append("<>");
            ++i;
        }
        sb.append(result.get(result.size() - 1));
        return sb.toString();
    }

    private HashMap<String, List<String>> getResource(String endpoint, String content, List<String> properties) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        PlainSparqlAccessor sa = this.accessorMap.get(endpoint);
        for (String property : properties) {
            ArrayList<String> res = new ArrayList<String>();
            ret.put(property, res);
            if (content.trim().isEmpty()) continue;
            String query2 = this.makeQuery(content, property);
            try {
                List<Map<String, RDFNode>> results = sa.executeQuery(query2);
                if (results == null) continue;
                for (Map<String, RDFNode> result : results) {
                    RDFNode s = result.get("o");
                    res.add(s.toString());
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return ret;
    }

    private String makeQuery(String s, String p) {
        return "select distinct ?o where {\n<" + s.trim() + "> <" + p.trim() + "> ?o \n" + "}";
    }

    public void addEndpoint(String endpoint) {
        EndpointSettings settings = EndpointSettingsManager.instance.getSetting(endpoint);
        PlainSparqlAccessor sa = new PlainSparqlAccessor(settings);
        this.accessorMap.put(endpoint, sa);
    }

    private void setEndpoint(List<String> endpoints) {
        for (String ep : endpoints) {
            this.addEndpoint(ep);
        }
    }

    private List<String> getEndpoints(String line) {
        List<String> headers = FileUtil.splitLine(line, SEPARATOR);
        if (headers.size() > 0) {
            headers.remove(0);
        }
        return headers;
    }

    private String getCurrentTime() {
        Timestamp time = new Timestamp(new Date().getTime());
        return String.valueOf(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(time)) + ":";
    }

    public static void main(String[] args) {
        String epFile = "C:\\Users\\kato\\Desktop\\out\\endp_prop.txt";
        String inFile = "C:\\works\\daily\\20130926\\input\\\u52d5\u8a5e\u7d22\u5f15.csv";
        String outFile = "C:\\works\\daily\\20130926\\input\\\u52d5\u8a5e\u7d22\u5f15_out.csv";
        try {
            EndpointSettings[] settings = EndpointSettings.inputXML(new FileInputStream("settings.xml"));
            if (settings != null) {
                EndpointSettingsManager.instance.setSettings(settings);
            }
            if (epFile == null || inFile == null || outFile == null) {
                System.out.println("usage:java -jar SparqlTestTool.jar Compare -e endpointFile -i inputFile -o outputFile -t type(s:subject/l:label object/o:all object)");
            } else {
                CompareSubject ct = new CompareSubject(new File(inFile), new File(epFile));
                ct.outputResult(new File(outFile));
            }
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        catch (FileNotFoundException e3) {
            e3.printStackTrace();
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
    }

    private class QueryThread
    extends Thread {
        private Object option;
        private CompareResultListener listener;

        public QueryThread(Object option, CompareResultListener listener) {
            this.option = option;
            this.listener = listener;
        }

        protected Object getOption() {
            return this.option;
        }

        protected CompareResultListener getCompareResultListener() {
            return this.listener;
        }
    }
}

