/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.gui;

import com.hp.hpl.jena.rdf.model.RDFNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import jp.ac.osaka_u.sanken.sparql.EndpointSettingsManager;
import jp.ac.osaka_u.sanken.sparql.SparqlAccessorFactory;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;
import jp.ac.osaka_u.sanken.sparql.ThreadedSparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.gui.SparqlAccessorForm;

public class SparqlSearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel executePanel = null;
    private JTextArea queryTextArea = null;
    private JPanel footerPanel = null;
    private JScrollPane resultListScrollPane = null;
    private JTable resultList = null;
    private JButton runQueryButton = null;
    private JSplitPane mainSplitPane = null;
    private SparqlAccessorForm parent;
    private DefaultTableModel tableModel;
    private ThreadedSparqlAccessor sa;
    private boolean processing = false;
    private JScrollPane queryScrollPane = null;

    public SparqlSearchPanel(SparqlAccessorForm parent) {
        this.initialize();
        this.parent = parent;
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getExecutePanel(), "North");
        this.add((Component)this.getMainSplitPane(), "Center");
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane(0, this.getQueryScrollPane(), this.getFooterPanel());
            this.mainSplitPane.setDividerLocation(200);
        }
        return this.mainSplitPane;
    }

    private JPanel getExecutePanel() {
        if (this.executePanel == null) {
            this.executePanel = new JPanel();
            this.executePanel.setLayout(new BorderLayout());
            this.executePanel.add((Component)this.getRunQueryButton(), "East");
        }
        return this.executePanel;
    }

    private JTextArea getQueryTextField() {
        if (this.queryTextArea == null) {
            this.queryTextArea = new JTextArea();
        }
        return this.queryTextArea;
    }

    public String getFindWord() {
        return this.getQueryTextField().getText();
    }

    private SparqlResultListener createSparqlResultListener2() {
        return new SparqlResultListener(){

            @Override
            public void resultReceived(SparqlResultSet result) {
                SparqlSearchPanel.this.setProcessing(false);
                SparqlSearchPanel.this.setResults(result);
            }

            @Override
            public void uncaughtException(Thread t, Throwable e2) {
                JOptionPane.showMessageDialog(SparqlSearchPanel.this.parent, "Execute error:" + e2.getMessage(), "Error", 0);
                SparqlSearchPanel.this.setProcessing(false);
            }
        };
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(new BorderLayout());
            this.footerPanel.add((Component)this.getResultListScrollPane(), "Center");
        }
        return this.footerPanel;
    }

    private JScrollPane getResultListScrollPane() {
        if (this.resultListScrollPane == null) {
            this.resultListScrollPane = new JScrollPane(this.getResultList());
        }
        return this.resultListScrollPane;
    }

    private JTable getResultList() {
        if (this.resultList == null) {
            this.resultList = new JTable();
        }
        return this.resultList;
    }

    public void setResults(SparqlResultSet result) {
        List<Map<String, RDFNode>> list = result.getDefaultResult();
        if (list.size() == 0) {
            this.tableModel = new DefaultTableModel();
            this.getResultList().setModel(this.tableModel);
            return;
        }
        Map<String, RDFNode> columns = list.get(0);
        ArrayList<String> clm = new ArrayList<String>();
        for (String string : columns.keySet()) {
            clm.add(string);
        }
        this.tableModel = new DefaultTableModel(clm.toArray(new String[0]), 0);
        for (Map map : list) {
            ArrayList<RDFNode> row = new ArrayList<RDFNode>();
            for (String key : clm) {
                RDFNode node = (RDFNode)map.get(key);
                row.add(node);
            }
            this.tableModel.addRow(row.toArray(new Object[0]));
        }
        this.getResultList().setModel(this.tableModel);
        this.parent.setResults(result);
    }

    private void setProcessing(boolean processing) {
        this.processing = processing;
        this.getRunQueryButton().setEnabled(!processing);
        this.getResultList().setEnabled(!processing);
        this.parent.setProcessing(processing);
    }

    private boolean isProcessing() {
        return this.processing;
    }

    private JButton getRunQueryButton() {
        if (this.runQueryButton == null) {
            this.runQueryButton = new JButton("Run Query");
            this.runQueryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (SparqlSearchPanel.this.isProcessing()) {
                        return;
                    }
                    SparqlSearchPanel.this.setProcessing(true);
                    SparqlSearchPanel.this.sa = SparqlAccessorFactory.createSparqlAccessor(EndpointSettingsManager.instance.getSetting(SparqlSearchPanel.this.parent.getCurrentEndPoint()), new SparqlQueryListener(){

                        @Override
                        public void sparqlExecuted(String query2) {
                            SparqlSearchPanel.this.parent.addLogText("----------------");
                            SparqlSearchPanel.this.parent.addLogText(query2);
                        }
                    });
                    SparqlSearchPanel.this.sa.executeQuery(SparqlSearchPanel.this.getFindWord(), SparqlSearchPanel.this.createSparqlResultListener2());
                }
            });
        }
        return this.runQueryButton;
    }

    private JScrollPane getQueryScrollPane() {
        if (this.queryScrollPane == null) {
            this.queryScrollPane = new JScrollPane(this.getQueryTextField());
        }
        return this.queryScrollPane;
    }
}

