/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.gui;

import com.hp.hpl.jena.rdf.model.RDFNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.EndpointSettingsManager;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;
import jp.ac.osaka_u.sanken.sparql.SparqlUtil;
import jp.ac.osaka_u.sanken.sparql.gui.CrossKeywordSearchPanel;
import jp.ac.osaka_u.sanken.sparql.gui.KeywordSearchPanel;
import jp.ac.osaka_u.sanken.sparql.gui.OptionDialog;
import jp.ac.osaka_u.sanken.sparql.gui.RepositoryKeywordSearchEditPanel;
import jp.ac.osaka_u.sanken.sparql.gui.SparqlSearchPanel;
import jp.ac.osaka_u.sanken.sparql.gui.VersionDialog;
import jp.ac.osaka_u.sanken.sparql.plugin.compare.ComparePanel;
import jp.ac.osaka_u.sanken.sparql.plugin.compare.CompareSubjectPanel;

public class SparqlAccessorForm
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel headerPanel = null;
    private JPanel endpointPanel = null;
    private JComboBox endpointComboBox = null;
    private JTabbedPane searchTypeTabbedPane = null;
    private JPanel crossKeywordSearchPanel = null;
    private JPanel keywordSearchPanel = null;
    private JPanel sparqlSearchPanel = null;
    private JPanel repositoryEditPanel = null;
    private JButton addEndpointButton = null;
    private JPanel footerPanel = null;
    private JButton saveButton = null;
    private JPanel radioPanel = null;
    private JRadioButton tsvRadioButton = null;
    private JRadioButton csvRadioButton = null;
    private JRadioButton xlsxRadioButton = null;
    private List<Map<String, RDFNode>> results;
    private JMenuBar mainMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu optionMenu = null;
    private JMenuItem exitFileMenuItem = null;
    private JMenuItem optionMenuItem = null;
    private JMenuItem saveSettingFileMenuItem = null;
    private JMenuItem compareMenuItem = null;
    private JMenuItem compareSubjectMenuItem = null;
    private String settingFile = "settings.xml";
    private JSplitPane mainPanel = null;
    private JPanel sparqlLogPanel = null;
    private JScrollPane sparqlLogScrollPane = null;
    private JTextArea sparqlLogTextArea = null;
    private JMenu helpMenu = null;
    private JMenuItem menuVersionItem = null;

    public SparqlAccessorForm() {
        this.loadSetting();
        this.initialize();
    }

    private void initialize() {
        this.setJMenuBar(this.getMainMenuBar());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                int option;
                if (EndpointSettingsManager.instance.isChanged() && (option = JOptionPane.showConfirmDialog(SparqlAccessorForm.this.getContentPane(), "\u30a8\u30f3\u30c9\u30dd\u30a4\u30f3\u30c8\u8a2d\u5b9a\u304c\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f", "", 0, 1)) == 0) {
                    SparqlAccessorForm.this.saveSetting(false);
                }
            }
        });
        Container compo = this.getContentPane();
        compo.setLayout(new BorderLayout());
        compo.add((Component)this.getHeaderPanel(), "North");
        compo.add((Component)this.getFooterPanel(), "South");
        compo.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setLayout(new BorderLayout());
            this.headerPanel.add((Component)this.getEndpointPanel(), "North");
        }
        return this.headerPanel;
    }

    private JPanel getEndpointPanel() {
        if (this.endpointPanel == null) {
            this.endpointPanel = new JPanel();
            this.endpointPanel.setLayout(new BorderLayout());
            this.endpointPanel.add((Component)this.getEndpointComboBox(), "Center");
            this.endpointPanel.add((Component)this.getAddEndpointButton(), "East");
        }
        return this.endpointPanel;
    }

    private JComboBox getEndpointComboBox() {
        if (this.endpointComboBox == null) {
            String[] endpoints;
            String[] stringArray = endpoints = new String[]{"http://hozoviewer.ei.sanken.osaka-u.ac.jp/endpoint/dbpedia", "http://lod.ac/species/sparql", "http://lod.ac/sparql"};
            int n = endpoints.length;
            int n2 = 0;
            while (n2 < n) {
                String ep = stringArray[n2];
                EndpointSettingsManager.instance.getSetting(ep);
                ++n2;
            }
            this.endpointComboBox = new JComboBox<String>(endpoints);
            this.endpointComboBox.setEditable(true);
            this.endpointComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SparqlAccessorForm.this.setEditable();
                }
            });
        }
        return this.endpointComboBox;
    }

    public String getCurrentEndPoint() {
        return (String)this.getEndpointComboBox().getSelectedItem();
    }

    private JTabbedPane getSearchTypeTabbedPane() {
        if (this.searchTypeTabbedPane == null) {
            this.searchTypeTabbedPane = new JTabbedPane();
            this.searchTypeTabbedPane.addTab("Keyword Search", null, this.getKeywordSearchPanel(), null);
            this.searchTypeTabbedPane.addTab("Cross Search", null, this.getCrossKeywordSearchPanel(), null);
            this.searchTypeTabbedPane.addTab("SPARQL", null, this.getSparqlSearchPanel(), null);
            this.searchTypeTabbedPane.addTab("Edit", null, this.getRepositoryEditPanel(), null);
        }
        return this.searchTypeTabbedPane;
    }

    private void setEditable() {
        EndpointSettings setting = EndpointSettingsManager.instance.getSetting(this.getCurrentEndPoint());
        this.getSearchTypeTabbedPane().setEnabledAt(this.getSearchTypeTabbedPane().indexOfComponent(this.getRepositoryEditPanel()), setting.isEditable());
    }

    private JPanel getKeywordSearchPanel() {
        if (this.keywordSearchPanel == null) {
            this.keywordSearchPanel = new KeywordSearchPanel(this);
        }
        return this.keywordSearchPanel;
    }

    private JPanel getCrossKeywordSearchPanel() {
        if (this.crossKeywordSearchPanel == null) {
            this.crossKeywordSearchPanel = new CrossKeywordSearchPanel(this);
        }
        return this.crossKeywordSearchPanel;
    }

    private JPanel getSparqlSearchPanel() {
        if (this.sparqlSearchPanel == null) {
            this.sparqlSearchPanel = new SparqlSearchPanel(this);
        }
        return this.sparqlSearchPanel;
    }

    private JPanel getRepositoryEditPanel() {
        if (this.repositoryEditPanel == null) {
            this.repositoryEditPanel = new RepositoryKeywordSearchEditPanel(this);
        }
        return this.repositoryEditPanel;
    }

    private JButton getAddEndpointButton() {
        if (this.addEndpointButton == null) {
            this.addEndpointButton = new JButton("New");
            this.addEndpointButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    boolean contains = false;
                    int i = 0;
                    while (i < SparqlAccessorForm.this.getEndpointComboBox().getItemCount()) {
                        Object item = SparqlAccessorForm.this.getEndpointComboBox().getItemAt(i);
                        if (item.equals(SparqlAccessorForm.this.getCurrentEndPoint())) {
                            contains = true;
                            break;
                        }
                        ++i;
                    }
                    if (!contains) {
                        EndpointSettingsManager.instance.getSetting(SparqlAccessorForm.this.getCurrentEndPoint());
                        SparqlAccessorForm.this.getEndpointComboBox().addItem(SparqlAccessorForm.this.getCurrentEndPoint());
                    }
                }
            });
        }
        return this.addEndpointButton;
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(new BorderLayout());
            this.footerPanel.add((Component)this.getSaveButton(), "East");
            this.footerPanel.add((Component)this.getRadioPanel(), "Center");
        }
        return this.footerPanel;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton("Save Result");
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SparqlAccessorForm.this.save();
                }
            });
            this.saveButton.setEnabled(false);
        }
        return this.saveButton;
    }

    private int saveSetting(boolean needConfirm) {
        int option;
        if (needConfirm && (option = JOptionPane.showConfirmDialog(this.getContentPane(), "\u30a8\u30f3\u30c9\u30dd\u30a4\u30f3\u30c8\u8a2d\u5b9a\u3092\u4fdd\u5b58\u3057\u307e\u3059", "", 0, 1)) != 0) {
            return 128;
        }
        File file = new File(this.settingFile);
        try {
            EndpointSettings.outputXML(new FileOutputStream(file), EndpointSettingsManager.instance.getSettings());
            EndpointSettingsManager.instance.resetChanged();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return 64;
        }
        return 0;
    }

    private int loadSetting() {
        File file = new File(this.settingFile);
        try {
            EndpointSettings[] settings = EndpointSettings.inputXML(new FileInputStream(file));
            if (settings != null) {
                EndpointSettingsManager.instance.setSettings(settings);
                EndpointSettingsManager.instance.resetChanged();
                EndpointSettings[] endpointSettingsArray = settings;
                int n = settings.length;
                int n2 = 0;
                while (n2 < n) {
                    EndpointSettings setting = endpointSettingsArray[n2];
                    DefaultComboBoxModel model = (DefaultComboBoxModel)this.getEndpointComboBox().getModel();
                    boolean exists = false;
                    int i = 0;
                    while (i < model.getSize()) {
                        String ep = (String)model.getElementAt(i);
                        if (setting.getEndpoint().equals(ep)) {
                            exists = true;
                            break;
                        }
                        ++i;
                    }
                    if (!exists) {
                        model.addElement(setting.getEndpoint());
                    }
                    ++n2;
                }
                return 0;
            }
        }
        catch (FileNotFoundException e2) {
            this.saveSetting(false);
            e2.printStackTrace();
            return 64;
        }
        finally {
            this.setEditable();
        }
        return 64;
    }

    private void save() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(1);
        int result = fileChooser.showOpenDialog(this);
        File file = fileChooser.getSelectedFile();
        if (result == 1 || file == null) {
            return;
        }
        try {
            SparqlUtil.saveResult(this.results, this.getSaveType(), file);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private int getSaveType() {
        if (this.getTsvRadioButton().isSelected()) {
            return 0;
        }
        if (this.getCsvRadioButton().isSelected()) {
            return 1;
        }
        if (this.getXlsxRadioButton().isSelected()) {
            return 2;
        }
        return 0;
    }

    void setProcessing(boolean isProcessing) {
        this.getEndpointComboBox().setEnabled(!isProcessing);
        this.getAddEndpointButton().setEnabled(!isProcessing);
        this.getSearchTypeTabbedPane().setEnabled(!isProcessing);
        this.getSaveButton().setEnabled(false);
    }

    void setResults(SparqlResultSet set) {
        List<Map<String, RDFNode>> results = set.getDefaultResult();
        boolean saveable = false;
        if (results != null && results.size() > 0) {
            saveable = true;
        }
        this.getSaveButton().setEnabled(saveable);
        this.results = results;
    }

    private JPanel getRadioPanel() {
        if (this.radioPanel == null) {
            this.radioPanel = new JPanel();
            this.radioPanel.setLayout(new FlowLayout());
            this.radioPanel.add((Component)this.getTsvRadioButton(), null);
            this.radioPanel.add((Component)this.getCsvRadioButton(), null);
            this.radioPanel.add((Component)this.getXlsxRadioButton(), null);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.getTsvRadioButton());
            bg.add(this.getCsvRadioButton());
            bg.add(this.getXlsxRadioButton());
            this.getTsvRadioButton().setSelected(true);
        }
        return this.radioPanel;
    }

    private JRadioButton getTsvRadioButton() {
        if (this.tsvRadioButton == null) {
            this.tsvRadioButton = new JRadioButton("TSV");
        }
        return this.tsvRadioButton;
    }

    private JRadioButton getCsvRadioButton() {
        if (this.csvRadioButton == null) {
            this.csvRadioButton = new JRadioButton("CSV");
        }
        return this.csvRadioButton;
    }

    private JRadioButton getXlsxRadioButton() {
        if (this.xlsxRadioButton == null) {
            this.xlsxRadioButton = new JRadioButton("XLSX");
            this.xlsxRadioButton.setEnabled(false);
        }
        return this.xlsxRadioButton;
    }

    private JMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = new JMenuBar();
            this.mainMenuBar.add(this.getFileMenu());
            this.mainMenuBar.add(this.getOptionMenu());
            this.mainMenuBar.add(this.getHelpMenu());
        }
        return this.mainMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu("File");
            this.fileMenu.add(this.getSaveSettingFileMenuItem());
            this.fileMenu.add(this.getExitFileMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getOptionMenu() {
        if (this.optionMenu == null) {
            this.optionMenu = new JMenu("Option");
            this.optionMenu.add(this.getOptionMenuItem());
            this.optionMenu.add(this.getCompareMenuItem());
            this.optionMenu.add(this.getCompareSubjectMenuItem());
        }
        return this.optionMenu;
    }

    private JMenuItem getExitFileMenuItem() {
        if (this.exitFileMenuItem == null) {
            this.exitFileMenuItem = new JMenuItem("Exit");
            this.exitFileMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int option = JOptionPane.showConfirmDialog(SparqlAccessorForm.this.getContentPane(), "\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f", "", 0, 1);
                    if (option == 0) {
                        System.exit(0);
                    }
                }
            });
        }
        return this.exitFileMenuItem;
    }

    private JMenuItem getCompareMenuItem() {
        if (this.compareMenuItem == null) {
            this.compareMenuItem = new JMenuItem("Compare");
            this.compareMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JFrame frame = new JFrame();
                    frame.setContentPane(new ComparePanel(frame));
                    frame.setSize(750, 500);
                    frame.setVisible(true);
                }
            });
        }
        return this.compareMenuItem;
    }

    private JMenuItem getCompareSubjectMenuItem() {
        if (this.compareSubjectMenuItem == null) {
            this.compareSubjectMenuItem = new JMenuItem("Compare Subjects");
            this.compareSubjectMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JFrame frame = new JFrame();
                    frame.setContentPane(new CompareSubjectPanel(frame));
                    frame.setSize(750, 500);
                    frame.setVisible(true);
                }
            });
        }
        return this.compareSubjectMenuItem;
    }

    private JMenuItem getOptionMenuItem() {
        if (this.optionMenuItem == null) {
            this.optionMenuItem = new JMenuItem("Option Setting");
            this.optionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SparqlAccessorForm.this.openSettingDialog();
                }
            });
        }
        return this.optionMenuItem;
    }

    private void openSettingDialog() {
        EndpointSettings setting = EndpointSettingsManager.instance.getSetting(this.getCurrentEndPoint());
        OptionDialog od = new OptionDialog((Frame)this, setting);
        od.setModal(true);
        od.setVisible(true);
        if (od.isOk()) {
            setting.setUseCustomParam(od.isUseCustom());
            setting.setQueryKey(od.getQueryKey());
            setting.setOption(od.getOption());
            setting.setNamespaces(od.getNamespaces());
            setting.setEncoding(od.getEndoding());
            setting.setResultType(od.getResultType());
            setting.setEditable(od.isEditable());
            setting.setRepositoryURL(od.getRepositoryURL());
            setting.setRepository(od.getRepository());
            setting.setUser(od.getUser());
            setting.setPass(od.getPassword());
            this.setEditable();
        }
    }

    private JMenuItem getSaveSettingFileMenuItem() {
        if (this.saveSettingFileMenuItem == null) {
            this.saveSettingFileMenuItem = new JMenuItem("Save Settings");
            this.saveSettingFileMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int ret = SparqlAccessorForm.this.saveSetting(true);
                    if (ret != 128) {
                        // empty if block
                    }
                }
            });
        }
        return this.saveSettingFileMenuItem;
    }

    private JSplitPane getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JSplitPane(0, this.getSearchTypeTabbedPane(), this.getSparqlLogPanel());
            this.mainPanel.setDividerLocation(400);
        }
        return this.mainPanel;
    }

    private JPanel getSparqlLogPanel() {
        if (this.sparqlLogPanel == null) {
            this.sparqlLogPanel = new JPanel();
            this.sparqlLogPanel.setLayout(new BorderLayout());
            this.sparqlLogPanel.add((Component)this.getSparqlLogScrollPane(), "Center");
        }
        return this.sparqlLogPanel;
    }

    private JScrollPane getSparqlLogScrollPane() {
        if (this.sparqlLogScrollPane == null) {
            this.sparqlLogScrollPane = new JScrollPane(this.getSparqlLogTextArea(), 22, 32);
            this.sparqlLogScrollPane.setPreferredSize(new Dimension(200, 300));
        }
        return this.sparqlLogScrollPane;
    }

    private JTextArea getSparqlLogTextArea() {
        if (this.sparqlLogTextArea == null) {
            this.sparqlLogTextArea = new JTextArea();
            this.sparqlLogTextArea.setEditable(false);
            this.sparqlLogTextArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                }

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                }

                @Override
                public void insertUpdate(DocumentEvent e2) {
                    final Document doc = SparqlAccessorForm.this.sparqlLogTextArea.getDocument();
                    final Element root = doc.getDefaultRootElement();
                    if (root.getElementCount() <= 100) {
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.removeLines(doc, root);
                        }
                    });
                    SparqlAccessorForm.this.sparqlLogTextArea.setCaretPosition(doc.getLength());
                }

                private void removeLines(Document doc, Element root) {
                    Element fl = root.getElement(0);
                    try {
                        doc.remove(0, fl.getEndOffset());
                    }
                    catch (BadLocationException ble) {
                        System.out.println(ble);
                    }
                }
            });
        }
        return this.sparqlLogTextArea;
    }

    void addLogText(String log) {
        String[] logs;
        String[] stringArray = logs = log.split("\n");
        int n = logs.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            this.sparqlLogTextArea.append(this.sparqlLogTextArea.getDocument().getLength() > 0 ? "\n" + l : l);
            ++n2;
        }
        this.sparqlLogTextArea.setCaretPosition(this.sparqlLogTextArea.getDocument().getLength());
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu("Help");
            this.helpMenu.add(this.getMenuVersionItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getMenuVersionItem() {
        if (this.menuVersionItem == null) {
            this.menuVersionItem = new JMenuItem("Version");
            this.menuVersionItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    SparqlAccessorForm.this.awakeVersionDialog();
                }
            });
        }
        return this.menuVersionItem;
    }

    private void awakeVersionDialog() {
        VersionDialog vd = new VersionDialog(this);
        vd.setVisible(true);
    }

    public static void main(String[] args) {
        SparqlAccessorForm frame = new SparqlAccessorForm();
        frame.setSize(900, 800);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

