/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.util.CheckableList;
import jp.ac.osaka_u.sanken.util.CheckableListItem;

public class EndpointSelector
extends JDialog {
    private static final long serialVersionUID = -5270916655051535400L;
    private EndpointSettings[] settings;
    private Map<String, EndpointSettings> settingNames;
    private JPanel jContentPane;
    private CheckableList endpointList;
    private JScrollPane endpointListScrollPane;
    private JPanel buttonPane;
    private JButton okButton;
    private boolean valid = false;

    public EndpointSelector(Frame owner, EndpointSettings[] settings) {
        super(owner);
        this.settings = settings;
        this.settingNames = new LinkedHashMap<String, EndpointSettings>();
        this.setTitle("Select the target endpoints");
        EndpointSettings[] endpointSettingsArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            EndpointSettings setting = endpointSettingsArray[n2];
            this.settingNames.put(setting.getEndpoint(), setting);
            ++n2;
        }
        this.initialize();
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public EndpointSettings[] getSettings() {
        DefaultListModel model = (DefaultListModel)this.getEndpointList().getModel();
        int i = 0;
        while (i < model.getSize()) {
            CheckableListItem item = (CheckableListItem)model.getElementAt(i);
            EndpointSettings ep = this.settingNames.get(item.text);
            if (ep != null) {
                ep.setTarget(item.selected);
            }
            ++i;
        }
        return this.settings;
    }

    private void initialize() {
        this.setSize(400, 400);
        this.setContentPane(this.getJContentPane());
        this.setResizable(false);
        this.setModal(true);
        InputMap imap = this.getRootPane().getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(10, 0), "go");
        this.getRootPane().getActionMap().put("go", new AbstractAction(){
            private static final long serialVersionUID = -4361937227644962283L;

            @Override
            public void actionPerformed(ActionEvent e2) {
                EndpointSelector.this.valid = true;
                EndpointSelector.this.close();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getEndpointListScrollPane(), "Center");
            this.jContentPane.add((Component)this.getButtonPane(), "South");
        }
        return this.jContentPane;
    }

    private CheckableList getEndpointList() {
        if (this.endpointList == null) {
            DefaultListModel<CheckableListItem> model = new DefaultListModel<CheckableListItem>();
            EndpointSettings[] endpointSettingsArray = this.settings;
            int n = this.settings.length;
            int n2 = 0;
            while (n2 < n) {
                EndpointSettings setting = endpointSettingsArray[n2];
                model.addElement(new CheckableListItem(setting.getEndpoint(), setting.isTarget()));
                ++n2;
            }
            this.endpointList = new CheckableList((ListModel)model);
        }
        return this.endpointList;
    }

    private JScrollPane getEndpointListScrollPane() {
        if (this.endpointListScrollPane == null) {
            this.endpointListScrollPane = new JScrollPane(this.getEndpointList());
        }
        return this.endpointListScrollPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new BorderLayout());
            this.buttonPane.add((Component)this.getOKButton(), "East");
        }
        return this.buttonPane;
    }

    private JButton getOKButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    EndpointSelector.this.valid = true;
                    EndpointSelector.this.close();
                }
            });
        }
        return this.okButton;
    }

    private void close() {
        this.setVisible(false);
    }
}

