/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.gui;

import com.hp.hpl.jena.rdf.model.RDFNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.EndpointSettingsManager;
import jp.ac.osaka_u.sanken.sparql.SparqlAccessorFactory;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;
import jp.ac.osaka_u.sanken.sparql.ThreadedSparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.gui.EndpointSelector;
import jp.ac.osaka_u.sanken.sparql.gui.SparqlAccessorForm;
import jp.ac.osaka_u.sanken.util.EditableList;
import jp.ac.osaka_u.sanken.util.EditableListItem;
import jp.ac.osaka_u.sanken.util.StringUtil;

public class CrossKeywordSearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel keywordPanel = null;
    private JLabel keywordLabel = null;
    private JTextField keywordTextField = null;
    private JTable subjectList = null;
    private JScrollPane subjectScrollPane = null;
    private JPanel centerPanel = null;
    private JPanel footerPanel = null;
    private JScrollPane resultListScrollPane = null;
    private JTable resultList = null;
    private JButton runQueryButton = null;
    private JSplitPane mainSplitPane = null;
    private JPanel optionPanel = null;
    private JPanel findTypePanel = null;
    private JRadioButton fullMatchRadioButton = null;
    private JRadioButton partMatchRadioButton = null;
    private JSeparator findSeparator = null;
    private boolean processing = false;
    private JPanel headerPanel = null;
    private JPanel limitPanel = null;
    private JCheckBox limitEnableCheckBox = null;
    private JLabel limitLabel = null;
    private JComboBox limitComboBox = null;
    private JRadioButton findSubjectRadioButton = null;
    private JRadioButton findObjectRadioButton = null;
    private JRadioButton findAllRadioButton = null;
    private JRadioButton findLabelObjectRadioButton = null;
    private Date fromDate;
    private JPanel movePanel = null;
    private JButton prevButton = null;
    private JButton nextButton = null;
    private JPanel limitMainPanel = null;
    private JButton limitPrevButton = null;
    private JButton limitNextButton = null;
    private SparqlAccessorForm parent;
    private DefaultTableModel listModel;
    private DefaultTableModel tableModel;
    private ThreadedSparqlAccessor sa;
    private int historyIndex = 0;
    private List<String> history;
    private LinkedHashMap<String, List<String>> subjectHistoryList;
    private Integer limit = null;
    private int page = 0;
    private String word;
    private boolean fullMatch = false;
    private int type;
    private boolean hasLimitNext = false;
    private static final String DEFAULT_PROPERTY_TYPE = "http://www.w3.org/2000/01/rdf-schema#label";
    private PropertyDialog propDialog;
    private List<EditableListItem> targetObjectTypes;
    private List<String> propertyList;
    private boolean isProcessingProperty = false;
    JPopupMenu popup;

    public CrossKeywordSearchPanel(SparqlAccessorForm parent) {
        this.initialize();
        this.parent = parent;
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHeaderPanel(), "North");
        this.add((Component)this.getMainSplitPane(), "Center");
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane(0, this.getCenterPanel(), this.getFooterPanel());
            this.mainSplitPane.setDividerLocation(200);
        }
        return this.mainSplitPane;
    }

    private JPanel getKeywordPanel() {
        if (this.keywordPanel == null) {
            this.keywordPanel = new JPanel();
            this.keywordPanel.setLayout(new BorderLayout());
            this.keywordLabel = new JLabel();
            this.keywordLabel.setText("Enter Keyword");
            this.keywordPanel.add((Component)this.keywordLabel, "West");
            this.keywordPanel.add((Component)this.getKeywordTextField(), "Center");
            this.keywordPanel.add((Component)this.getRunQueryButton(), "East");
        }
        return this.keywordPanel;
    }

    private JPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.optionPanel = new JPanel();
            this.optionPanel.setLayout(new BorderLayout());
            this.optionPanel.add((Component)this.getFindTypePanel(), "Center");
            this.optionPanel.add((Component)this.getLimitPanel(), "East");
        }
        return this.optionPanel;
    }

    private JPanel getFindTypePanel() {
        if (this.findTypePanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            flowLayout.setVgap(0);
            this.findTypePanel = new JPanel();
            this.findTypePanel.setLayout(flowLayout);
            this.findTypePanel.add((Component)this.getFullMatchRadioButton(), null);
            this.findTypePanel.add((Component)this.getPartMatchRadioButton(), null);
            this.findTypePanel.add((Component)this.getFindSeparator(), null);
            this.findTypePanel.add((Component)this.getFindAllRadioButton(), null);
            this.findTypePanel.add((Component)this.getFindSubjectRadioButton(), null);
            this.findTypePanel.add((Component)this.getFindObjectRadioButton(), null);
            this.findTypePanel.add((Component)this.getFindLabelObjectRadioButton(), null);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.getFullMatchRadioButton());
            bg.add(this.getPartMatchRadioButton());
            this.getFullMatchRadioButton().setSelected(true);
            ButtonGroup bg2 = new ButtonGroup();
            bg2.add(this.getFindAllRadioButton());
            bg2.add(this.getFindSubjectRadioButton());
            bg2.add(this.getFindObjectRadioButton());
            bg2.add(this.getFindLabelObjectRadioButton());
            this.getFindSubjectRadioButton().setSelected(true);
        }
        return this.findTypePanel;
    }

    private boolean isFullMatch() {
        return this.getFullMatchRadioButton().isSelected();
    }

    private int getFindType() {
        if (this.getFindSubjectRadioButton().isSelected()) {
            return 1;
        }
        if (this.getFindObjectRadioButton().isSelected()) {
            return 2;
        }
        if (this.getFindLabelObjectRadioButton().isSelected()) {
            return 3;
        }
        return 0;
    }

    private JRadioButton getFullMatchRadioButton() {
        if (this.fullMatchRadioButton == null) {
            this.fullMatchRadioButton = new JRadioButton("Full Match");
        }
        return this.fullMatchRadioButton;
    }

    private JRadioButton getPartMatchRadioButton() {
        if (this.partMatchRadioButton == null) {
            this.partMatchRadioButton = new JRadioButton("Part Match");
        }
        return this.partMatchRadioButton;
    }

    private JSeparator getFindSeparator() {
        if (this.findSeparator == null) {
            this.findSeparator = new JSeparator(1);
            this.findSeparator.setPreferredSize(new Dimension(5, 20));
        }
        return this.findSeparator;
    }

    private JTextField getKeywordTextField() {
        if (this.keywordTextField == null) {
            this.keywordTextField = new JTextField();
            this.keywordTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent arg0) {
                    if (arg0.getKeyChar() == '\n') {
                        CrossKeywordSearchPanel.this.doSearch();
                    }
                }
            });
        }
        return this.keywordTextField;
    }

    private String getFindWord() {
        return this.getKeywordTextField().getText();
    }

    private JTable getSubjectList() {
        if (this.subjectList == null) {
            this.subjectList = new JTable(){
                private static final long serialVersionUID = -3850550815070973157L;

                @Override
                public String getToolTipText(MouseEvent e2) {
                    Object cell = this.getModel().getValueAt(this.rowAtPoint(e2.getPoint()), this.columnAtPoint(e2.getPoint()));
                    return cell == null ? "" : StringUtil.makeHtmlString(StringUtil.splitString(cell.toString()));
                }
            };
            this.subjectList.setDefaultEditor(Object.class, null);
            this.subjectList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    int index = CrossKeywordSearchPanel.this.subjectList.getSelectedRow();
                    Object val = CrossKeywordSearchPanel.this.subjectList.getValueAt(index, 1);
                    String subject = val.toString();
                    if (e2.getClickCount() >= 2 && CrossKeywordSearchPanel.this.findSubjectTriple(subject)) {
                        CrossKeywordSearchPanel.this.addHistory(subject);
                    }
                    if (SwingUtilities.isRightMouseButton(e2)) {
                        CrossKeywordSearchPanel.this.awakePopupIfHtml(val, e2.getLocationOnScreen());
                    }
                }
            });
        }
        return this.subjectList;
    }

    private SparqlResultListener createSparqlResultListener2() {
        return new SparqlResultListener(){

            @Override
            public void resultReceived(SparqlResultSet result) {
                CrossKeywordSearchPanel.this.setProcessing(false);
                CrossKeywordSearchPanel.this.setResults(result);
            }

            @Override
            public void uncaughtException(Thread t, Throwable e2) {
                JOptionPane.showMessageDialog(CrossKeywordSearchPanel.this.parent, "Execute error:" + e2.getMessage(), "Error", 0);
                CrossKeywordSearchPanel.this.setProcessing(false);
            }
        };
    }

    private void setSubjectList(String endpoint, String obj) {
        this.listModel.addRow(new String[]{endpoint, obj});
    }

    private DefaultTableModel clearSubjectList() {
        this.listModel = new DefaultTableModel(new String[]{"endpoint", "result"}, 0);
        this.getSubjectList().setModel(this.listModel);
        return this.listModel;
    }

    private void clearHistory() {
        this.subjectHistoryList = new LinkedHashMap();
    }

    private void setSubjectList(String endpoint, List<String> list) {
        this.subjectHistoryList.put(endpoint, list);
        for (String item : list) {
            this.listModel.addRow(new String[]{endpoint, item});
        }
        this.getSubjectList().setModel(this.listModel);
    }

    private JScrollPane getSubjectScrollPane() {
        if (this.subjectScrollPane == null) {
            this.subjectScrollPane = new JScrollPane(this.getSubjectList());
        }
        return this.subjectScrollPane;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            this.centerPanel.add((Component)this.getSubjectScrollPane(), "Center");
        }
        return this.centerPanel;
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(new BorderLayout());
            this.footerPanel.add((Component)this.getResultListScrollPane(), "Center");
        }
        return this.footerPanel;
    }

    private JScrollPane getResultListScrollPane() {
        if (this.resultListScrollPane == null) {
            this.resultListScrollPane = new JScrollPane(this.getResultList());
        }
        return this.resultListScrollPane;
    }

    private JTable getResultList() {
        if (this.resultList == null) {
            this.resultList = new JTable(){
                private static final long serialVersionUID = 3332757068706348175L;

                @Override
                public String getToolTipText(MouseEvent e2) {
                    Object cell = this.getModel().getValueAt(this.rowAtPoint(e2.getPoint()), this.columnAtPoint(e2.getPoint()));
                    return cell == null ? "" : StringUtil.makeHtmlString(StringUtil.splitString(cell.toString()));
                }
            };
            this.resultList.setDefaultEditor(Object.class, null);
            this.resultList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    int index = CrossKeywordSearchPanel.this.resultList.getSelectedRow();
                    Object val = CrossKeywordSearchPanel.this.resultList.getValueAt(index, 1);
                    String o = val.toString();
                    if (e2.getClickCount() >= 2 && CrossKeywordSearchPanel.this.findSubjectTriple(o)) {
                        CrossKeywordSearchPanel.this.clearSubjectList();
                        CrossKeywordSearchPanel.this.setSubjectList("", o);
                        CrossKeywordSearchPanel.this.addHistory(o);
                    }
                    if (SwingUtilities.isRightMouseButton(e2)) {
                        CrossKeywordSearchPanel.this.awakePopupIfHtml(val, e2.getLocationOnScreen());
                    }
                }
            });
        }
        return this.resultList;
    }

    private void setResults(SparqlResultSet result) {
        if (result == null || result.getDefaultResult() == null || result.getDefaultResult().size() == 0) {
            this.tableModel = new DefaultTableModel();
            this.getResultList().setModel(this.tableModel);
            return;
        }
        List<Map<String, RDFNode>> list = result.getDefaultResult();
        Map<String, RDFNode> columns = list.get(0);
        ArrayList<String> clm = new ArrayList<String>();
        for (String string : columns.keySet()) {
            clm.add(string);
        }
        this.tableModel = new DefaultTableModel(clm.toArray(new String[0]), 0);
        for (Map map : list) {
            ArrayList<RDFNode> row = new ArrayList<RDFNode>();
            for (String key : clm) {
                RDFNode node = (RDFNode)map.get(key);
                row.add(node);
            }
            this.tableModel.addRow(row.toArray(new Object[0]));
        }
        this.getResultList().setModel(this.tableModel);
        this.parent.setResults(result);
    }

    private void setProcessing(boolean processing) {
        this.processing = processing;
        this.getSubjectList().setEnabled(!processing);
        this.getRunQueryButton().setEnabled(!processing);
        this.getResultList().setEnabled(!processing);
        this.getKeywordTextField().setEnabled(!processing);
        this.getFullMatchRadioButton().setEnabled(!processing);
        this.getPartMatchRadioButton().setEnabled(!processing);
        this.getFindSubjectRadioButton().setEnabled(!processing);
        this.getFindObjectRadioButton().setEnabled(!processing);
        this.getFindLabelObjectRadioButton().setEnabled(!processing);
        this.updateButtonStates();
        this.updateLimitButtonStates();
        this.parent.setProcessing(processing);
    }

    private boolean isProcessing() {
        return this.processing;
    }

    private JButton getRunQueryButton() {
        if (this.runQueryButton == null) {
            this.runQueryButton = new JButton("Find");
            this.runQueryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    CrossKeywordSearchPanel.this.doSearch();
                }
            });
        }
        return this.runQueryButton;
    }

    private void doSearch() {
        if (this.isProcessing()) {
            return;
        }
        this.initHistory();
        this.initLimit();
        this.sa = this.createSparqlAccessor(true);
        if (this.sa == null) {
            return;
        }
        this.setResults(null);
        this.setProcessing(true);
        this.word = this.getFindWord();
        this.fullMatch = this.isFullMatch();
        this.limit = this.getLimit();
        this.type = this.getFindType();
        this.sa.findSubject(this.word, this.fullMatch, this.limit, this.limit != null ? Integer.valueOf(this.limit * this.page) : null, this.type, this.getTargetPropertyList(), this.createSparqlResultListener());
    }

    private ThreadedSparqlAccessor createSparqlAccessor(boolean needEndpointDialog) {
        List<EndpointSettings> settings = this.getEndpointSettings(needEndpointDialog);
        if (settings == null || settings.size() == 0) {
            return null;
        }
        ThreadedSparqlAccessor tsa = SparqlAccessorFactory.createSparqlAccessor(settings, new SparqlQueryListener(){

            @Override
            public void sparqlExecuted(String query2) {
                CrossKeywordSearchPanel.this.fromDate = new Date();
                CrossKeywordSearchPanel.this.parent.addLogText("----------------");
                CrossKeywordSearchPanel.this.parent.addLogText(query2);
            }
        });
        return tsa;
    }

    private List<EndpointSettings> getEndpointSettings(boolean withUi) {
        EndpointSettings[] result;
        ArrayList<EndpointSettings> settings = new ArrayList<EndpointSettings>();
        EndpointSelector es = new EndpointSelector(null, EndpointSettingsManager.instance.getSettings());
        if (withUi) {
            es.setVisible(true);
            if (!es.isValid()) {
                return null;
            }
        }
        EndpointSettings[] endpointSettingsArray = result = es.getSettings();
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            EndpointSettings setting = endpointSettingsArray[n2];
            if (setting.isTarget()) {
                settings.add(setting);
            }
            ++n2;
        }
        return settings;
    }

    private SparqlResultListener createSparqlResultListener() {
        return new SparqlResultListener(){

            @Override
            public void resultReceived(SparqlResultSet result) {
                CrossKeywordSearchPanel.this.hasLimitNext = result.isHasNext();
                Date now2 = new Date();
                long time = now2.getTime() - CrossKeywordSearchPanel.this.fromDate.getTime();
                CrossKeywordSearchPanel.this.parent.addLogText("---------------- result:" + time + " ms");
                CrossKeywordSearchPanel.this.clearHistory();
                CrossKeywordSearchPanel.this.clearSubjectList();
                for (String endpoint : result.getResult().keySet()) {
                    ArrayList<String> resultList = new ArrayList<String>();
                    List<Map<String, RDFNode>> results = result.getResult().get(endpoint);
                    for (Map<String, RDFNode> item : results) {
                        RDFNode node = item.get("s");
                        resultList.add(node.toString());
                    }
                    CrossKeywordSearchPanel.this.setSubjectList(endpoint, resultList);
                }
                CrossKeywordSearchPanel.this.setProcessing(false);
            }

            @Override
            public void uncaughtException(Thread t, Throwable e2) {
                JOptionPane.showMessageDialog(CrossKeywordSearchPanel.this.parent, "Execute error:" + e2.getMessage(), "Error", 0);
                CrossKeywordSearchPanel.this.setProcessing(false);
            }
        };
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setLayout(new BorderLayout());
            this.headerPanel.add((Component)this.getKeywordPanel(), "Center");
            this.headerPanel.add((Component)this.getOptionPanel(), "South");
            this.headerPanel.add((Component)this.getMovePanel(), "West");
        }
        return this.headerPanel;
    }

    private JPanel getLimitPanel() {
        if (this.limitPanel == null) {
            this.limitLabel = new JLabel();
            this.limitLabel.setText(" LIMIT  ");
            this.limitLabel.setEnabled(false);
            this.limitPanel = new JPanel();
            this.limitPanel.setLayout(new BorderLayout());
            this.limitPanel.add((Component)this.getLimitEnableCheckBox(), "West");
            this.limitPanel.add((Component)this.limitLabel, "Center");
            this.limitPanel.add((Component)this.getLimitMainPanel(), "East");
        }
        return this.limitPanel;
    }

    private Integer getLimit() {
        try {
            if (this.getLimitComboBox().isEnabled()) {
                return Integer.parseInt((String)this.getLimitComboBox().getSelectedItem());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private JCheckBox getLimitEnableCheckBox() {
        if (this.limitEnableCheckBox == null) {
            this.limitEnableCheckBox = new JCheckBox();
            this.limitEnableCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    boolean enabled = CrossKeywordSearchPanel.this.getLimitEnableCheckBox().isSelected();
                    CrossKeywordSearchPanel.this.getLimitComboBox().setEnabled(enabled);
                    CrossKeywordSearchPanel.this.limitLabel.setEnabled(enabled);
                    CrossKeywordSearchPanel.this.updateLimitButtonStates();
                }
            });
        }
        return this.limitEnableCheckBox;
    }

    private JComboBox getLimitComboBox() {
        if (this.limitComboBox == null) {
            String[] limits = new String[]{"100", "250", "500", "1000"};
            this.limitComboBox = new JComboBox<String>(limits);
            this.limitComboBox.setEnabled(false);
        }
        return this.limitComboBox;
    }

    private JRadioButton getFindSubjectRadioButton() {
        if (this.findSubjectRadioButton == null) {
            this.findSubjectRadioButton = new JRadioButton("Find Subject");
        }
        return this.findSubjectRadioButton;
    }

    private JRadioButton getFindObjectRadioButton() {
        if (this.findObjectRadioButton == null) {
            this.findObjectRadioButton = new JRadioButton("Find All Object");
        }
        return this.findObjectRadioButton;
    }

    private JRadioButton getFindAllRadioButton() {
        if (this.findAllRadioButton == null) {
            this.findAllRadioButton = new JRadioButton("Find All");
            this.findAllRadioButton.setEnabled(false);
        }
        return this.findAllRadioButton;
    }

    private JRadioButton getFindLabelObjectRadioButton() {
        if (this.findLabelObjectRadioButton == null) {
            this.findLabelObjectRadioButton = new JRadioButton("Find Specific Object");
            this.findLabelObjectRadioButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    CrossKeywordSearchPanel.this.awakePropertyListPopup(e2.getLocationOnScreen());
                }
            });
        }
        return this.findLabelObjectRadioButton;
    }

    private JPanel getMovePanel() {
        if (this.movePanel == null) {
            this.movePanel = new JPanel();
            this.movePanel.setLayout(new BoxLayout(this.movePanel, 0));
            this.movePanel.add((Component)this.getPrevButton(), null);
            this.movePanel.add((Component)this.getNextButton(), null);
        }
        return this.movePanel;
    }

    private JButton getPrevButton() {
        if (this.prevButton == null) {
            this.prevButton = new JButton("\u2190");
            this.prevButton.setMargin(new Insets(0, 10, 0, 10));
            this.prevButton.setEnabled(false);
            this.prevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String s = CrossKeywordSearchPanel.this.getPrev();
                    if (s != null) {
                        CrossKeywordSearchPanel.this.clearSubjectList();
                        if (CrossKeywordSearchPanel.this.historyIndex == 0) {
                            for (String key : CrossKeywordSearchPanel.this.subjectHistoryList.keySet()) {
                                CrossKeywordSearchPanel.this.setSubjectList(key, (List)CrossKeywordSearchPanel.this.subjectHistoryList.get(key));
                            }
                        } else {
                            CrossKeywordSearchPanel.this.setSubjectList("", s);
                        }
                        CrossKeywordSearchPanel.this.findSubjectTriple(s);
                    }
                }
            });
        }
        return this.prevButton;
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton("\u2192");
            this.nextButton.setMargin(new Insets(0, 10, 0, 10));
            this.nextButton.setEnabled(false);
            this.nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String s = CrossKeywordSearchPanel.this.getNext();
                    if (s != null) {
                        CrossKeywordSearchPanel.this.clearSubjectList();
                        CrossKeywordSearchPanel.this.setSubjectList("", s);
                        CrossKeywordSearchPanel.this.findSubjectTriple(s);
                    }
                }
            });
        }
        return this.nextButton;
    }

    private boolean findSubjectTriple(String s) {
        if (this.isProcessing()) {
            return false;
        }
        this.setProcessing(true);
        if (!this.sa.findTripleFromSubject(s, this.createSparqlResultListener2())) {
            this.setProcessing(false);
            return false;
        }
        this.setResults(null);
        return true;
    }

    private boolean awakePopupIfHtml(Object o, Point p) {
        if (o == null || o.toString().trim().isEmpty()) {
            return false;
        }
        String s = o.toString();
        if (o instanceof RDFNode && ((RDFNode)o).isLiteral()) {
            s = ((RDFNode)o).asLiteral().getString();
        }
        JPopupMenu popup = new JPopupMenu(s);
        if (s.startsWith("http://") || s.startsWith("https://")) {
            JMenuItem menu = new JMenuItem("Show on Web Browser");
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JMenuItem menu = (JMenuItem)e2.getSource();
                    JPopupMenu parent = (JPopupMenu)menu.getParent();
                    try {
                        CrossKeywordSearchPanel.this.awakeHtml(parent.getLabel());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            popup.add(menu);
        } else {
            JMenuItem menu1 = new JMenuItem("Search By Google");
            menu1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JMenuItem menu = (JMenuItem)e2.getSource();
                    JPopupMenu parent = (JPopupMenu)menu.getParent();
                    try {
                        CrossKeywordSearchPanel.this.awakeHtml("https://www.google.co.jp/search?q=" + URLEncoder.encode(parent.getLabel(), "UTF-8"));
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            popup.add(menu1);
            JMenuItem menu2 = new JMenuItem("Search By GoogleMaps");
            menu2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JMenuItem menu = (JMenuItem)e2.getSource();
                    JPopupMenu parent = (JPopupMenu)menu.getParent();
                    try {
                        CrossKeywordSearchPanel.this.awakeHtml("https://maps.google.com/maps?q=" + URLEncoder.encode(parent.getLabel(), "UTF-8"));
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            popup.add(menu2);
        }
        popup.setLocation(p);
        SwingUtilities.convertPointFromScreen(p, this.parent);
        popup.show(this.parent, p.x, p.y);
        return false;
    }

    private void awakeHtml(String url) throws IOException, URISyntaxException {
        Desktop desktop = Desktop.getDesktop();
        URI uri = new URI(url);
        desktop.browse(uri);
    }

    private boolean awakePropertyListPopup(Point p) {
        DefaultListModel model = new DefaultListModel();
        for (EditableListItem tp : this.getTargetPropertyListItem()) {
            model.addElement(tp);
        }
        EditableList properties = new EditableList(model);
        this.propDialog = new PropertyDialog(this.parent, properties);
        properties.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                List propList = CrossKeywordSearchPanel.this.getPropertyList();
                String word = ((JTextField)e2.getSource()).getText();
                if (word.length() > 2) {
                    List<String> candidates = StringUtil.getPartHitString(propList, word);
                    if (candidates.size() < 20) {
                        CrossKeywordSearchPanel.this.awakeCandidateList(candidates, CrossKeywordSearchPanel.this.propDialog.getList().getTextField().getLocationOnScreen());
                    }
                } else if (CrossKeywordSearchPanel.this.popup != null) {
                    CrossKeywordSearchPanel.this.popup.setVisible(false);
                    CrossKeywordSearchPanel.this.popup = null;
                }
            }
        });
        properties.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
                CrossKeywordSearchPanel.this.propDialog.pack();
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
                CrossKeywordSearchPanel.this.propDialog.pack();
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
            }
        });
        properties.getTextField().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (CrossKeywordSearchPanel.this.propDialog.getList().getTextField().getText().isEmpty()) {
                    CrossKeywordSearchPanel.this.propDialog.setOK(true);
                    CrossKeywordSearchPanel.this.propDialog.setVisible(false);
                }
            }
        });
        this.propDialog.setLocation(p);
        this.propDialog.pack();
        this.propDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.propDialog.setVisible(true);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (!this.propDialog.isOK()) {
            return false;
        }
        model = (DefaultListModel)properties.getModel();
        this.getTargetPropertyListItem().clear();
        int i = 0;
        while (i < model.getSize()) {
            Object item = model.getElementAt(i);
            if (item instanceof EditableListItem) {
                this.getTargetPropertyListItem().add((EditableListItem)item);
            }
            ++i;
        }
        return true;
    }

    private List<String> getPropertyList() {
        if (this.propertyList == null && !this.isProcessingProperty) {
            try {
                ThreadedSparqlAccessor tsa = this.createSparqlAccessor(false);
                if (tsa != null) {
                    this.isProcessingProperty = true;
                    tsa.findPropertyList(new SparqlResultListener(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e2) {
                            JOptionPane.showMessageDialog(CrossKeywordSearchPanel.this.parent, "Execute error:" + e2.getMessage(), "Error", 0);
                            CrossKeywordSearchPanel.this.setProcessing(false);
                        }

                        @Override
                        public void resultReceived(SparqlResultSet resultSet) {
                            CrossKeywordSearchPanel.this.propertyList = new ArrayList();
                            Map<String, List<Map<String, RDFNode>>> resultByEndpoint = resultSet.getResult();
                            for (List<Map<String, RDFNode>> results : resultByEndpoint.values()) {
                                for (Map<String, RDFNode> result : results) {
                                    for (String nodeStr : result.keySet()) {
                                        if (nodeStr == null || CrossKeywordSearchPanel.this.propertyList.contains(nodeStr)) continue;
                                        CrossKeywordSearchPanel.this.propertyList.add(nodeStr);
                                    }
                                }
                            }
                            CrossKeywordSearchPanel.this.isProcessingProperty = false;
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.propertyList;
    }

    private List<EditableListItem> getTargetPropertyListItem() {
        if (this.targetObjectTypes == null) {
            this.targetObjectTypes = new ArrayList<EditableListItem>();
            this.targetObjectTypes.add(new EditableListItem(DEFAULT_PROPERTY_TYPE, false));
        }
        return this.targetObjectTypes;
    }

    private void awakeCandidateList(List<String> candidates, Point p) {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        this.popup = new JPopupMenu();
        for (String candidate : candidates) {
            JMenuItem item = new JMenuItem(candidate);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    CrossKeywordSearchPanel.this.propDialog.getList().getTextField().setText(((JMenuItem)e2.getSource()).getText());
                    CrossKeywordSearchPanel.this.popup.setVisible(false);
                    CrossKeywordSearchPanel.this.popup = null;
                }
            });
            this.popup.add(item);
        }
        this.popup.setLocation(p.x + 400, p.y + 20);
        this.popup.setVisible(true);
    }

    private void initHistory() {
        this.history = new ArrayList<String>();
        this.historyIndex = -1;
        this.updateButtonStates();
    }

    private void addHistory(String item) {
        if (this.historyIndex >= 0 && this.historyIndex < this.history.size() - 1) {
            int i = this.history.size() - 1;
            while (i > this.historyIndex) {
                this.history.remove(i);
                --i;
            }
        }
        this.history.add(item);
        ++this.historyIndex;
        this.updateButtonStates();
    }

    private String getPrev() {
        if (this.hasPrev()) {
            --this.historyIndex;
            this.updateButtonStates();
            return this.history.get(this.historyIndex);
        }
        return null;
    }

    private String getNext() {
        if (this.hasNext()) {
            ++this.historyIndex;
            this.updateButtonStates();
            return this.history.get(this.historyIndex);
        }
        return null;
    }

    private void updateButtonStates() {
        if (!this.processing) {
            this.getPrevButton().setEnabled(this.hasPrev());
            this.getNextButton().setEnabled(this.hasNext());
        } else {
            this.getPrevButton().setEnabled(false);
            this.getNextButton().setEnabled(false);
        }
    }

    private boolean hasPrev() {
        return this.history.size() != 0 && this.historyIndex > 0;
    }

    private boolean hasNext() {
        return this.historyIndex + 1 < this.history.size();
    }

    private JPanel getLimitMainPanel() {
        if (this.limitMainPanel == null) {
            this.limitMainPanel = new JPanel();
            this.limitMainPanel.setLayout(new BorderLayout());
            this.limitMainPanel.add((Component)this.getLimitComboBox(), "West");
            this.limitMainPanel.add((Component)this.getLimitPrevButton(), "Center");
            this.limitMainPanel.add((Component)this.getLimitNextButton(), "East");
        }
        return this.limitMainPanel;
    }

    private JButton getLimitPrevButton() {
        if (this.limitPrevButton == null) {
            this.limitPrevButton = new JButton("\u2190");
            this.limitPrevButton.setMargin(new Insets(0, 10, 0, 10));
            this.limitPrevButton.setEnabled(false);
            this.limitPrevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CrossKeywordSearchPanel.this.setProcessing(true);
                    ThreadedSparqlAccessor threadedSparqlAccessor = CrossKeywordSearchPanel.this.sa;
                    String string = CrossKeywordSearchPanel.this.word;
                    boolean bl = CrossKeywordSearchPanel.this.fullMatch;
                    Integer n = CrossKeywordSearchPanel.this.limit;
                    int n2 = CrossKeywordSearchPanel.this.limit;
                    CrossKeywordSearchPanel crossKeywordSearchPanel = CrossKeywordSearchPanel.this;
                    int n3 = crossKeywordSearchPanel.page - 1;
                    crossKeywordSearchPanel.page = n3;
                    threadedSparqlAccessor.findSubject(string, bl, n, n2 * n3, CrossKeywordSearchPanel.this.type, CrossKeywordSearchPanel.this.getTargetPropertyList(), CrossKeywordSearchPanel.this.createSparqlResultListener());
                }
            });
        }
        return this.limitPrevButton;
    }

    private JButton getLimitNextButton() {
        if (this.limitNextButton == null) {
            this.limitNextButton = new JButton("\u2192");
            this.limitNextButton.setMargin(new Insets(0, 10, 0, 10));
            this.limitNextButton.setEnabled(false);
            this.limitNextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CrossKeywordSearchPanel.this.setProcessing(true);
                    ThreadedSparqlAccessor threadedSparqlAccessor = CrossKeywordSearchPanel.this.sa;
                    String string = CrossKeywordSearchPanel.this.word;
                    boolean bl = CrossKeywordSearchPanel.this.fullMatch;
                    Integer n = CrossKeywordSearchPanel.this.limit;
                    int n2 = CrossKeywordSearchPanel.this.limit;
                    CrossKeywordSearchPanel crossKeywordSearchPanel = CrossKeywordSearchPanel.this;
                    int n3 = crossKeywordSearchPanel.page + 1;
                    crossKeywordSearchPanel.page = n3;
                    threadedSparqlAccessor.findSubject(string, bl, n, n2 * n3, CrossKeywordSearchPanel.this.type, CrossKeywordSearchPanel.this.getTargetPropertyList(), CrossKeywordSearchPanel.this.createSparqlResultListener());
                }
            });
        }
        return this.limitNextButton;
    }

    private void initLimit() {
        this.limit = this.getLimit();
        this.page = 0;
    }

    private String[] getTargetPropertyList() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.targetObjectTypes != null && this.targetObjectTypes.size() > 0) {
            for (EditableListItem item : this.targetObjectTypes) {
                ret.add(item.text);
            }
        } else {
            ret.add(DEFAULT_PROPERTY_TYPE);
        }
        return ret.toArray(new String[0]);
    }

    private void updateLimitButtonStates() {
        if (!this.processing && this.getLimitEnableCheckBox().isSelected()) {
            this.getLimitPrevButton().setEnabled(this.page != 0);
            this.getLimitNextButton().setEnabled(this.hasLimitNext);
        } else {
            this.getLimitPrevButton().setEnabled(false);
            this.getLimitNextButton().setEnabled(false);
        }
    }

    class PropertyDialog
    extends JDialog {
        private static final long serialVersionUID = -638100288439239858L;
        private EditableList list;
        private boolean isOK;

        public PropertyDialog(Window parent, EditableList list) {
            super(parent);
            this.setLayout(new BorderLayout());
            this.list = list;
            this.add((Component)list, "Center");
        }

        public EditableList getList() {
            return this.list;
        }

        public void setOK(boolean value) {
            this.isOK = value;
        }

        public boolean isOK() {
            return this.isOK;
        }
    }
}

