/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.QueryThread;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;
import jp.ac.osaka_u.sanken.sparql.ThreadedSparqlAccessor;

public class PlainSparqlAccessor
implements ThreadedSparqlAccessor {
    private EndpointSettings setting;
    private SparqlQueryListener queryListener;

    public PlainSparqlAccessor(EndpointSettings endpoint, SparqlQueryListener queryListener) {
        this.queryListener = queryListener;
        this.setting = endpoint;
    }

    public PlainSparqlAccessor(EndpointSettings endpoint) {
        this(endpoint, null);
    }

    public EndpointSettings getSetting() {
        return this.setting;
    }

    protected QueryExecution makeQuery(String queryString) {
        System.out.println("query:[" + queryString + "]");
        Query query2 = QueryFactory.create(queryString);
        QueryExecution qe = QueryExecutionFactory.sparqlService(this.getSetting().getEndpoint(), query2);
        return qe;
    }

    @Override
    public boolean executeQuery(String queryString, SparqlResultListener resultListener) {
        QueryThread thread = new QueryThread(queryString, resultListener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(PlainSparqlAccessor.this.executeQuery(this.getQueryString())));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(resultListener);
        thread.start();
        return true;
    }

    @Override
    public List<Map<String, RDFNode>> executeQuery(String queryString) throws Exception {
        ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
        QueryExecution qe = this.makeQuery(queryString);
        if (qe == null) {
            throw new Exception("Can't connect to endpoint");
        }
        try {
            try {
                if (this.queryListener != null) {
                    this.queryListener.sparqlExecuted(queryString);
                }
                ResultSet results = null;
                try {
                    results = !this.setting.isUseCustomParam() ? qe.execSelect() : this.customQuery(queryString);
                    List<String> keys = results.getResultVars();
                    while (results.hasNext()) {
                        QuerySolution result = results.next();
                        HashMap<String, RDFNode> map = new HashMap<String, RDFNode>();
                        for (String key : keys) {
                            RDFNode node = result.get(key);
                            map.put(key, node);
                        }
                        ret.add(map);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw e3;
            }
        }
        finally {
            qe.close();
        }
        return ret;
    }

    private ResultSet customQuery(String query2) throws Exception {
        URL url = new URL(String.valueOf(this.setting.getEndpoint()) + "?" + this.setting.getQueryKey() + "=" + URLEncoder.encode(query2, this.setting.getEncoding()) + "&" + this.setting.getOption());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Accept-Language", "ja");
        conn.setRequestProperty("Referer", this.setting.getEndpoint());
        int resultType = this.setting.getResultType();
        ResultSet ret = null;
        if (resultType == 1) {
            ret = ResultSetFactory.fromJSON(conn.getInputStream());
        } else if (resultType == 0) {
            ret = ResultSetFactory.fromXML(conn.getInputStream());
        } else if (resultType == 2) {
            ret = ResultSetFactory.fromSSE(conn.getInputStream());
        } else if (resultType == 3) {
            ret = ResultSetFactory.fromTSV(conn.getInputStream());
        }
        conn.disconnect();
        return ret;
    }

    @Override
    public SparqlResultSet findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type, String[] propList) throws Exception {
        String query2;
        word = word.replace(" ", "%20");
        if (!fullMatch) {
            if (type == 1) {
                query2 = "select distinct ?s where {\n?s <http://www.w3.org/2000/01/rdf-schema#label> ?o \nFILTER(regex(str(?s), \"" + word + "\", \"m\"))\n" + "}";
            } else if (type == 2) {
                query2 = "select distinct ?s where {\n?s ?p ?o \nFILTER(regex(str(?o), \"" + word + "\", \"m\"))\n" + "}";
            } else if (type == 3) {
                query2 = "select distinct ?s where {\n";
                query2 = String.valueOf(query2) + this.getPropertySparql(propList);
                query2 = String.valueOf(query2) + "FILTER(regex(str(?o), \"" + word + "\", \"m\"))\n" + "}";
            } else {
                query2 = "select distinct ?s where {\n";
                query2 = String.valueOf(query2) + this.getPropertySparql(propList);
                query2 = String.valueOf(query2) + "FILTER(regex(str(?o), \"" + word + "\", \"m\"))\n" + "}";
            }
        } else if (type == 2) {
            query2 = "select distinct ?s where \n{{?s ?p \"" + word + "\"} UNION \n" + "{?s ?p \"" + word + "\"@en} UNION \n" + "{?s ?p \"" + word + "\"@ja} ";
            String[] namespaces = this.setting.getNamespaceList();
            if (namespaces != null && namespaces.length > 0) {
                query2 = String.valueOf(query2) + "UNION \n";
            }
            int i = 0;
            while (i < namespaces.length) {
                String ns = namespaces[i];
                query2 = String.valueOf(query2) + "{?s ?p <" + ns + "/" + word + ">} ";
                query2 = i != namespaces.length - 1 ? String.valueOf(query2) + "UNION \n" : String.valueOf(query2) + "\n";
                ++i;
            }
            query2 = String.valueOf(query2) + "}";
        } else if (type == 3) {
            query2 = "select distinct ?s where \n{";
            query2 = String.valueOf(query2) + this.getPropertySparql(propList, word);
            query2 = String.valueOf(query2) + "}";
        } else {
            if (type == 1) {
                String[] namespaces = this.setting.getNamespaceList();
                ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
                int i = 0;
                while (i < namespaces.length) {
                    String ns = namespaces[i];
                    String query3 = "select ?o where {\n<" + ns + "/" + word + "> ?p ?o \n";
                    List<Map<String, RDFNode>> temp = this.executeQuery(query3 = String.valueOf(query3) + "}");
                    if (temp != null && temp.size() > 0) {
                        HashMap<String, ResourceImpl> node = new HashMap<String, ResourceImpl>();
                        node.put("s", new ResourceImpl(String.valueOf(ns) + "/" + word));
                        ret.add(node);
                    }
                    ++i;
                }
                return new SparqlResultSet(ret, false);
            }
            query2 = "select distinct ?s where {\n";
            query2 = String.valueOf(query2) + this.getPropertySparql(propList, word);
            query2 = String.valueOf(query2) + "}";
        }
        if (limit != null && limit > 0) {
            query2 = String.valueOf(query2) + "\n LIMIT " + String.valueOf(limit + 1);
        }
        if (offset != null && offset > 0) {
            query2 = String.valueOf(query2) + "\n OFFSET " + String.valueOf(offset);
        }
        List<Map<String, RDFNode>> result = this.executeQuery(query2);
        SparqlResultSet ret = new SparqlResultSet(result);
        if (limit != null && result != null && result.size() > limit) {
            result = result.subList(0, limit);
            ret.setDefaultResult(result);
            ret.setHasNext(true);
        }
        return ret;
    }

    private String getPropertySparql(String[] propList) {
        StringBuilder sb = new StringBuilder();
        if (propList == null) {
            propList = new String[]{"http://www.w3.org/2000/01/rdf-schema#label"};
        }
        if (propList.length == 1) {
            sb.append("?s <");
            sb.append(propList[0]);
            sb.append("> ?o \n");
        } else {
            sb.append("{\n");
            int i = 0;
            while (i < propList.length) {
                sb.append("{?s <");
                sb.append(propList[i]);
                sb.append("> ?o ");
                if (i == propList.length - 1) {
                    sb.append("}\n");
                } else {
                    sb.append("} UNION \n");
                }
                ++i;
            }
            sb.append("}");
        }
        return sb.toString();
    }

    private String getPropertySparql(String[] propList, String word) {
        StringBuilder sb = new StringBuilder();
        if (propList == null) {
            propList = new String[]{"http://www.w3.org/2000/01/rdf-schema#label"};
        }
        sb.append("{\n");
        int i = 0;
        while (i < propList.length) {
            sb.append("{?s <" + propList[i] + "> \"" + word + "\"} UNION \n");
            sb.append("{?s <" + propList[i] + "> \"" + word + "\"@en} UNION \n");
            sb.append("{?s <" + propList[i] + "> \"" + word + "\"@ja");
            if (i == propList.length - 1) {
                sb.append("}\n");
            } else {
                sb.append("} UNION \n");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type, String[] propList, SparqlResultListener resultListener) {
        QueryThread thread = new QueryThread(word, new Object[]{new Boolean(fullMatch), limit, offset, new Integer(type), propList}, resultListener){

            @Override
            public void run() {
                try {
                    Boolean fullMatch = (Boolean)((Object[])this.getOption())[0];
                    Integer limit = (Integer)((Object[])this.getOption())[1];
                    Integer offset = (Integer)((Object[])this.getOption())[2];
                    Integer type = (Integer)((Object[])this.getOption())[3];
                    String[] propList = (String[])((Object[])this.getOption())[4];
                    this.getSparqlResultListener().resultReceived(PlainSparqlAccessor.this.findSubject(this.getQueryString(), fullMatch, limit, offset, type, propList));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(resultListener);
        thread.start();
        return true;
    }

    @Override
    public List<Map<String, RDFNode>> findTripleFromSubject(String subject) throws Exception {
        subject = subject.replace(" ", "%20");
        String query2 = "select ?p ?o where {\n<" + subject + "> ?p ?o\n" + "}";
        return this.executeQuery(query2);
    }

    @Override
    public boolean findTripleFromSubject(String subject, SparqlResultListener listener) {
        QueryThread thread = new QueryThread(subject, listener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(PlainSparqlAccessor.this.findTripleFromSubject(this.getQueryString())));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(listener);
        thread.start();
        return true;
    }

    @Override
    public List<Map<String, RDFNode>> findPropertyList() throws Exception {
        ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
        HashMap<String, RDFNode> result = new HashMap<String, RDFNode>();
        ret.add(result);
        String query2 = "select ?s {\n?s ?p ?o\n} LIMIT 10";
        List<Map<String, RDFNode>> subjects = this.executeQuery(query2);
        for (Map<String, RDFNode> subjectMap : subjects) {
            RDFNode subject = subjectMap.get("s");
            query2 = "select distinct ?p where {\n<" + subject + "> ?p ?o\n" + "}";
            List<Map<String, RDFNode>> properties = this.executeQuery(query2);
            for (Map<String, RDFNode> propertyMap : properties) {
                RDFNode property = propertyMap.get("p");
                result.put(property.toString(), property);
                System.out.println("p[" + property.toString() + "]");
            }
        }
        return ret;
    }

    @Override
    public boolean findPropertyList(SparqlResultListener listener) {
        QueryThread thread = new QueryThread(null, listener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(PlainSparqlAccessor.this.findPropertyList()));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(listener);
        thread.start();
        return true;
    }

    public static void main(String[] args) {
        try {
            URL url = new URL("http://www.wikipediaontology.org/query/?q=" + URLEncoder.encode("select * {?s ?p ?o}", "UTF-8") + "&type=xml&LIMIT=100");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "test");
            conn.setRequestProperty("Accept-Language", "ja");
            conn.setRequestProperty("Referer", "http://www.wikipediaontology.org/query/");
            InputStreamReader isr = new InputStreamReader(conn.getInputStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
            conn.disconnect();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

