/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import java.util.HashMap;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;

public class EndpointSettingsManager {
    private HashMap<String, EndpointSettings> settingMap = new HashMap();
    private boolean isChanged = false;
    public static final EndpointSettingsManager instance = new EndpointSettingsManager();

    private EndpointSettingsManager() {
    }

    public EndpointSettings getSetting(String endpoint) {
        EndpointSettings setting = this.settingMap.get(endpoint);
        if (setting == null) {
            this.isChanged = true;
            setting = new EndpointSettings(endpoint);
            this.settingMap.put(endpoint, setting);
        }
        return setting;
    }

    public EndpointSettings[] getSettings() {
        return this.settingMap.values().toArray(new EndpointSettings[0]);
    }

    public void setSettings(EndpointSettings[] settings) {
        this.settingMap = new HashMap();
        EndpointSettings[] endpointSettingsArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            EndpointSettings setting = endpointSettingsArray[n2];
            this.settingMap.put(setting.getEndpoint(), setting);
            ++n2;
        }
    }

    public boolean removeSetting(String endpoint) {
        EndpointSettings removed = this.settingMap.remove(endpoint);
        if (removed != null) {
            this.isChanged = true;
        }
        return removed != null;
    }

    public boolean isChanged() {
        if (this.isChanged) {
            return true;
        }
        EndpointSettings[] endpointSettingsArray = this.getSettings();
        int n = endpointSettingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndpointSettings setting = endpointSettingsArray[n2];
            if (setting.isChanged()) {
                this.isChanged = true;
                break;
            }
            ++n2;
        }
        return this.isChanged;
    }

    public void resetChanged() {
        this.isChanged = false;
        EndpointSettings[] endpointSettingsArray = this.getSettings();
        int n = endpointSettingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndpointSettings setting = endpointSettingsArray[n2];
            setting.resetChanged();
            ++n2;
        }
    }
}

