/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.QueryThread;
import jp.ac.osaka_u.sanken.sparql.SparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.SparqlAccessorFactory;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;
import jp.ac.osaka_u.sanken.sparql.ThreadedSparqlAccessor;

public class CrossSparqlAccessor
implements ThreadedSparqlAccessor {
    private List<EndpointSettings> settings;
    private Map<EndpointSettings, SparqlAccessor> accessorHash = new LinkedHashMap<EndpointSettings, SparqlAccessor>();
    private Map<Integer, CrossOffset> crossOffsetMap;

    public CrossSparqlAccessor(List<EndpointSettings> settings, SparqlQueryListener listener) {
        for (EndpointSettings setting : settings) {
            this.accessorHash.put(setting, SparqlAccessorFactory.createSparqlAccessor(setting, listener));
        }
        this.settings = settings;
        this.init();
    }

    public CrossSparqlAccessor(List<EndpointSettings> settings) {
        for (EndpointSettings setting : settings) {
            this.accessorHash.put(setting, SparqlAccessorFactory.createSparqlAccessor(setting));
        }
        this.settings = settings;
        this.init();
    }

    private void init() {
        this.crossOffsetMap = new LinkedHashMap<Integer, CrossOffset>();
    }

    @Override
    public List<Map<String, RDFNode>> executeQuery(String queryString) throws Exception {
        throw new UnsupportedOperationException("Can't Execute Query");
    }

    @Override
    public SparqlResultSet findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type, String[] propList) throws Exception {
        SparqlResultSet ret = new SparqlResultSet(new ArrayList<Map<String, RDFNode>>());
        Integer limit_ = limit;
        Integer offset_ = offset;
        CrossOffset cOffset = null;
        if (offset != null) {
            this.crossOffsetMap.get(new Integer(offset));
            cOffset = new CrossOffset(0, offset);
        }
        int i = 0;
        while (i < this.settings.size()) {
            if (cOffset != null) {
                i = cOffset.endpointIndex;
            }
            EndpointSettings setting = this.settings.get(i);
            SparqlAccessor sa = this.accessorHash.get(setting);
            SparqlResultSet set = sa.findSubject(word, fullMatch, limit_, cOffset == null ? null : Integer.valueOf(cOffset.offset), type, propList);
            ret.addResult(setting.getEndpoint(), set.getDefaultResult());
            if (cOffset != null) {
                if (ret.getDefaultResult().size() >= limit) {
                    cOffset = new CrossOffset(i, limit_ + offset_);
                    this.crossOffsetMap.put(new Integer(limit + offset), cOffset);
                    break;
                }
                limit_ = limit - set.getDefaultResult().size();
                offset_ = 0;
                if (i == this.settings.size() - 1 && set.isHasNext()) {
                    ret.setHasNext(true);
                }
            }
            ++i;
        }
        return ret;
    }

    @Override
    public List<Map<String, RDFNode>> findTripleFromSubject(String subject) throws Exception {
        ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
        for (EndpointSettings setting : this.settings) {
            boolean hit = false;
            String[] stringArray = setting.getNamespaceList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ns = stringArray[n2];
                if (subject.startsWith(ns)) {
                    hit = true;
                }
                ++n2;
            }
            if (!hit) continue;
            SparqlAccessor sa = this.accessorHash.get(setting);
            List<Map<String, RDFNode>> set = sa.findTripleFromSubject(subject);
            ret.addAll(set);
        }
        return ret;
    }

    private boolean isThereTargetEndpoint(String subject) {
        for (EndpointSettings setting : this.settings) {
            String[] stringArray = setting.getNamespaceList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ns = stringArray[n2];
                if (subject.startsWith(ns)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean executeQuery(String queryString, SparqlResultListener resultListener) {
        throw new UnsupportedOperationException("Can't Execute Query");
    }

    @Override
    public boolean findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type, String[] propList, SparqlResultListener resultListener) {
        QueryThread thread = new QueryThread(word, new Object[]{new Boolean(fullMatch), limit, offset, new Integer(type), propList}, resultListener){

            @Override
            public void run() {
                try {
                    Boolean fullMatch = (Boolean)((Object[])this.getOption())[0];
                    Integer limit = (Integer)((Object[])this.getOption())[1];
                    Integer offset = (Integer)((Object[])this.getOption())[2];
                    Integer type = (Integer)((Object[])this.getOption())[3];
                    String[] propList = (String[])((Object[])this.getOption())[4];
                    this.getSparqlResultListener().resultReceived(CrossSparqlAccessor.this.findSubject(this.getQueryString(), fullMatch, limit, offset, type, propList));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(resultListener);
        thread.start();
        return true;
    }

    @Override
    public boolean findTripleFromSubject(String subject, SparqlResultListener listener) {
        if (!this.isThereTargetEndpoint(subject)) {
            return false;
        }
        QueryThread thread = new QueryThread(subject, listener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(CrossSparqlAccessor.this.findTripleFromSubject(this.getQueryString())));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(listener);
        thread.start();
        return true;
    }

    @Override
    public List<Map<String, RDFNode>> findPropertyList() throws Exception {
        ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
        LinkedHashMap<String, RDFNode> result = new LinkedHashMap<String, RDFNode>();
        ret.add(result);
        for (EndpointSettings setting : this.settings) {
            SparqlAccessor sa = this.accessorHash.get(setting);
            List<Map<String, RDFNode>> set = sa.findPropertyList();
            for (Map<String, RDFNode> r : set) {
                for (String key : r.keySet()) {
                    result.put(key, r.get(key));
                }
            }
        }
        return ret;
    }

    @Override
    public boolean findPropertyList(SparqlResultListener listener) {
        QueryThread thread = new QueryThread(null, listener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(CrossSparqlAccessor.this.findPropertyList()));
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        thread.setUncaughtExceptionHandler(listener);
        thread.start();
        return true;
    }

    private class CrossOffset {
        public int endpointIndex;
        public int offset;

        public CrossOffset(int endpointIndex, int offset) {
            this.endpointIndex = endpointIndex;
            this.offset = offset;
        }
    }
}

