/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.mgt;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.sparql.mgt.SystemInfoMBean;

public class SystemInfo
implements SystemInfoMBean {
    private final String name;
    private final Node iri;
    private final String version;
    private final String buildDate;

    public SystemInfo(String name, String version2, String buildDate) {
        this.name = name;
        this.iri = SystemInfo.createIRI(name);
        this.version = version2;
        this.buildDate = buildDate;
    }

    private static Node createIRI(String iriStr) {
        try {
            return Node.createURI(IRIResolver.resolveGlobal(iriStr));
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    @Override
    public String getBuildDate() {
        return this.buildDate;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getIRI() {
        return Node.createURI(this.name);
    }
}

