/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprEvalTypeException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.RegexJava;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeFunctions;
import com.hp.hpl.jena.sparql.expr.nodevalue.NumericType;
import com.hp.hpl.jena.sparql.util.DateTimeStruct;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.atlas.logging.Log;

public class XSDFuncOp {
    private static final int DIVIDE_PRECISION = 24;
    private static final BigDecimal BigDecimalZero = new BigDecimal(0.0);
    private static Set<XSDDatatype> integerSubTypes = new HashSet<XSDDatatype>();
    public static boolean strictDateTimeFO;
    public static final String defaultTimezone = "Z";

    private XSDFuncOp() {
    }

    public static NodeValue add(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("add", nv1, nv2)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv1.getInteger().add(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv1.getDecimal().add(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() + nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() + nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue subtract(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("subtract", nv1, nv2)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv1.getInteger().subtract(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv1.getDecimal().subtract(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() - nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() - nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue multiply(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("multiply", nv1, nv2)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv1.getInteger().multiply(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv1.getDecimal().multiply(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() * nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() * nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue divide(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("divide", nv1, nv2)) {
            case OP_INTEGER: {
                if (nv2.getInteger().equals(BigInteger.ZERO)) {
                    throw new ExprEvalException("Divide by zero in divide");
                }
                BigDecimal d1 = new BigDecimal(nv1.getInteger());
                BigDecimal d2 = new BigDecimal(nv2.getInteger());
                return XSDFuncOp.decimalDivide(d1, d2);
            }
            case OP_DECIMAL: {
                if (nv2.getDecimal().compareTo(BigDecimalZero) == 0) {
                    throw new ExprEvalException("Divide by zero in decimal divide");
                }
                BigDecimal d1 = nv1.getDecimal();
                BigDecimal d2 = nv2.getDecimal();
                return XSDFuncOp.decimalDivide(d1, d2);
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() / nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() / nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    private static NodeValue decimalDivide(BigDecimal d1, BigDecimal d2) {
        try {
            BigDecimal d3 = d1.divide(d2, 24, 3);
            return XSDFuncOp.messAroundWithBigDecimalFormat(d3);
        }
        catch (ArithmeticException ex) {
            Log.warn(XSDFuncOp.class, "ArithmeticException in decimal divide - attempting to treat as doubles");
            BigDecimal d3 = new BigDecimal(d1.doubleValue() / d2.doubleValue());
            return NodeValue.makeDecimal(d3);
        }
    }

    private static NodeValue messAroundWithBigDecimalFormat(BigDecimal d) {
        int i;
        String x = d.toPlainString();
        int dotIdx = x.indexOf(46);
        if (dotIdx < 0) {
            return NodeValue.makeNode(x, XSDDatatype.XSDdecimal);
        }
        for (i = x.length() - 1; i > dotIdx && x.charAt(i) == '0'; --i) {
        }
        if (i < x.length() - 1) {
            x = x.substring(0, i + 1);
        }
        return NodeValue.makeNode(x, XSDDatatype.XSDdecimal);
    }

    public static NodeValue max(NodeValue nv1, NodeValue nv2) {
        int x = XSDFuncOp.compareNumeric(nv1, nv2);
        if (x == -1) {
            return nv2;
        }
        return nv1;
    }

    public static NodeValue min(NodeValue nv1, NodeValue nv2) {
        int x = XSDFuncOp.compareNumeric(nv1, nv2);
        if (x == 1) {
            return nv2;
        }
        return nv1;
    }

    public static NodeValue not(NodeValue nv) {
        boolean b = XSDFuncOp.booleanEffectiveValue(nv);
        return NodeValue.booleanReturn(!b);
    }

    public static NodeValue booleanEffectiveValueAsNodeValue(NodeValue nv) {
        if (nv.isBoolean()) {
            return nv;
        }
        return NodeValue.booleanReturn(XSDFuncOp.booleanEffectiveValue(nv));
    }

    public static boolean booleanEffectiveValue(NodeValue nv) {
        if (nv.isBoolean()) {
            return nv.getBoolean();
        }
        if (nv.isString()) {
            return nv.getString().length() > 0;
        }
        if (nv.isInteger()) {
            return !nv.getInteger().equals(NodeValue.IntegerZERO);
        }
        if (nv.isDecimal()) {
            return !nv.getDecimal().equals(NodeValue.DecimalZERO);
        }
        if (nv.isDouble()) {
            return nv.getDouble() != 0.0;
        }
        NodeValue.raise(new ExprEvalException("Not a boolean effective value (wrong type): " + nv));
        return false;
    }

    public static NodeValue unaryMinus(NodeValue nv) {
        switch (XSDFuncOp.classifyNumeric("unaryMinus", nv)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv.getInteger().negate());
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv.getDecimal().negate());
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(-nv.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(-nv.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + nv);
    }

    public static NodeValue unaryPlus(NodeValue nv) {
        NumericType opType = XSDFuncOp.classifyNumeric("unaryPlus", nv);
        return nv;
    }

    public static NodeValue abs(NodeValue nv) {
        switch (XSDFuncOp.classifyNumeric("abs", nv)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv.getInteger().abs());
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv.getDecimal().abs());
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(Math.abs(nv.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.abs(nv.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + nv);
    }

    public static NodeValue ceiling(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("ceiling", v)) {
            case OP_INTEGER: {
                return v;
            }
            case OP_DECIMAL: {
                BigDecimal dec = v.getDecimal().setScale(0, 2);
                return NodeValue.makeDecimal(dec);
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat((float)Math.ceil(v.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.ceil(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue floor(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("floor", v)) {
            case OP_INTEGER: {
                return v;
            }
            case OP_DECIMAL: {
                BigDecimal dec = v.getDecimal().setScale(0, 3);
                return NodeValue.makeDecimal(dec);
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat((float)Math.floor(v.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.floor(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue round(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("round", v)) {
            case OP_INTEGER: {
                return v;
            }
            case OP_DECIMAL: {
                int sgn = v.getDecimal().signum();
                BigDecimal dec = sgn < 0 ? v.getDecimal().setScale(0, 5) : v.getDecimal().setScale(0, 4);
                return NodeValue.makeDecimal(dec);
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(Math.round(v.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.round(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue sqrt(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("sqrt", v)) {
            case OP_INTEGER: 
            case OP_DECIMAL: {
                double dec = v.getDecimal().doubleValue();
                return NodeValue.makeDecimal(Math.sqrt(dec));
            }
            case OP_FLOAT: {
                return NodeValue.makeDouble(Math.sqrt(v.getDouble()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.sqrt(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue javaSubstring(NodeValue v1, NodeValue v2) {
        return XSDFuncOp.javaSubstring(v1, v2, null);
    }

    public static NodeValue javaSubstring(NodeValue nvString, NodeValue nvStart, NodeValue nvFinish) {
        try {
            String string = nvString.getString();
            int start = nvStart.getInteger().intValue();
            if (nvFinish == null) {
                return NodeValue.makeString(string.substring(start));
            }
            int finish = nvFinish.getInteger().intValue();
            return NodeValue.makeString(string.substring(start, finish));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    public static NodeValue strlen(NodeValue nvString) {
        Node n = NodeFunctions.checkAndGetStringLiteral("strlen", nvString);
        int len = n.getLiteralLexicalForm().length();
        return NodeValue.makeInteger(len);
    }

    public static NodeValue strReplace(NodeValue nvStr, NodeValue nvPattern, NodeValue nvReplacement, NodeValue nvFlags) {
        String pat = NodeFunctions.checkAndGetStringLiteral("replace", nvPattern).getLiteralLexicalForm();
        int flags = 0;
        if (nvFlags != null) {
            String flagsStr = NodeFunctions.checkAndGetStringLiteral("replace", nvFlags).getLiteralLexicalForm();
            flags = RegexJava.makeMask(flagsStr);
        }
        return XSDFuncOp.strReplace(nvStr, Pattern.compile(pat, flags), nvReplacement);
    }

    public static NodeValue strReplace(NodeValue nvStr, Pattern pattern, NodeValue nvReplacement) {
        String n = NodeFunctions.checkAndGetStringLiteral("replace", nvStr).getLiteralLexicalForm();
        String rep = NodeFunctions.checkAndGetStringLiteral("replace", nvReplacement).getLiteralLexicalForm();
        String x = pattern.matcher(n).replaceAll(rep);
        return XSDFuncOp.calcReturn(x, nvStr.asNode());
    }

    public static NodeValue strReplace(NodeValue nvStr, NodeValue nvPattern, NodeValue nvReplacement) {
        return XSDFuncOp.strReplace(nvStr, nvPattern, nvReplacement, null);
    }

    public static NodeValue substring(NodeValue v1, NodeValue v2) {
        return XSDFuncOp.substring(v1, v2, null);
    }

    public static NodeValue substring(NodeValue nvString, NodeValue nvStart, NodeValue nvLength) {
        Node n = NodeFunctions.checkAndGetStringLiteral("substring", nvString);
        RDFDatatype dt = n.getLiteralDatatype();
        String lang = n.getLiteralLanguage();
        try {
            int length;
            String string = n.getLiteralLexicalForm();
            int start = XSDFuncOp.intValueStr(nvStart, string.length() + 1);
            if (nvLength != null) {
                length = XSDFuncOp.intValueStr(nvLength, 0);
            } else {
                length = string.length();
                if (start < 0) {
                    length -= start;
                }
            }
            int finish = start + length;
            if (start <= 0) {
                start = 1;
            }
            --start;
            if (--finish > string.length()) {
                finish = string.length();
            }
            if (finish < start) {
                finish = start;
            }
            if (finish < 0) {
                finish = 0;
            }
            if (string.length() == 0) {
                return XSDFuncOp.calcReturn("", n);
            }
            String lex2 = string.substring(start, finish);
            return XSDFuncOp.calcReturn(lex2, n);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    private static int intValueStr(NodeValue nv, int valueNan) {
        if (nv.isInteger()) {
            return nv.getInteger().intValue();
        }
        if (nv.isDecimal()) {
            return (int)Math.round(nv.getDecimal().doubleValue());
        }
        if (nv.isFloat()) {
            float f = nv.getFloat();
            if (Float.isNaN(f)) {
                return valueNan;
            }
            return Math.round(f);
        }
        if (nv.isDouble()) {
            double d = nv.getDouble();
            if (Double.isNaN(d)) {
                return valueNan;
            }
            return (int)Math.round(d);
        }
        throw new ExprEvalException("Not a number:" + nv);
    }

    public static NodeValue strContains(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("contains", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        boolean x = StrUtils.contains(lex1, lex2);
        return NodeValue.booleanReturn(x);
    }

    public static NodeValue strStartsWith(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("strStarts", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        return NodeValue.booleanReturn(lex1.startsWith(lex2));
    }

    public static NodeValue strEndsWith(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("strEnds", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        return NodeValue.booleanReturn(lex1.endsWith(lex2));
    }

    private static NodeValue calcReturn(String result, Node arg) {
        Node n2 = Node.createLiteral(result, arg.getLiteralLanguage(), arg.getLiteralDatatype());
        return NodeValue.makeNode(n2);
    }

    public static NodeValue strBefore(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("strBefore", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        Node mainArg = string.asNode();
        if (lex2.length() == 0) {
            return XSDFuncOp.calcReturn("", mainArg);
        }
        int i = lex1.indexOf(lex2);
        if (i < 0) {
            return XSDFuncOp.calcReturn("", mainArg);
        }
        String s = lex1.substring(0, i);
        return XSDFuncOp.calcReturn(s, string.asNode());
    }

    public static NodeValue strAfter(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("strAfter", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        Node mainArg = string.asNode();
        if (lex2.length() == 0) {
            return XSDFuncOp.calcReturn("", mainArg);
        }
        int i = lex1.indexOf(lex2);
        if (i < 0) {
            return XSDFuncOp.calcReturn("", mainArg);
        }
        String s = lex1.substring(i += lex2.length());
        return XSDFuncOp.calcReturn(s, string.asNode());
    }

    public static NodeValue strLowerCase(NodeValue string) {
        Node n = NodeFunctions.checkAndGetStringLiteral("lcase", string);
        String lex = n.getLiteralLexicalForm();
        String lex2 = lex.toLowerCase();
        return XSDFuncOp.calcReturn(lex2, string.asNode());
    }

    public static NodeValue strUpperCase(NodeValue string) {
        Node n = NodeFunctions.checkAndGetStringLiteral("ucase", string);
        String lex = n.getLiteralLexicalForm();
        String lex2 = lex.toUpperCase();
        return XSDFuncOp.calcReturn(lex2, string.asNode());
    }

    public static NodeValue fnConcat(List<NodeValue> args) {
        StringBuilder sb = new StringBuilder();
        for (NodeValue arg : args) {
            String x = arg.asString();
            sb.append(x);
        }
        return NodeValue.makeString(sb.toString());
    }

    public static NodeValue strConcat(List<NodeValue> args) {
        String lang = null;
        boolean mixedLang = false;
        boolean xsdString = false;
        boolean simpleLiteral = false;
        StringBuilder sb = new StringBuilder();
        for (NodeValue nv : args) {
            Node n = NodeFunctions.checkAndGetStringLiteral("CONCAT", nv);
            String lang1 = n.getLiteralLanguage();
            if (!lang1.equals("")) {
                if (lang != null && !lang1.equals(lang)) {
                    mixedLang = true;
                }
                lang = lang1;
            } else if (n.getLiteralDatatype() != null) {
                xsdString = true;
            } else {
                simpleLiteral = true;
            }
            sb.append(n.getLiteralLexicalForm());
        }
        if (mixedLang) {
            return NodeValue.makeString(sb.toString());
        }
        if (lang != null) {
            if (!xsdString && !simpleLiteral) {
                return NodeValue.makeNode(sb.toString(), lang, (String)null);
            }
            return NodeValue.makeString(sb.toString());
        }
        if (simpleLiteral && xsdString) {
            return NodeValue.makeString(sb.toString());
        }
        if (xsdString) {
            return NodeValue.makeNode(sb.toString(), XSDDatatype.XSDstring);
        }
        if (simpleLiteral) {
            return NodeValue.makeString(sb.toString());
        }
        return NodeValue.makeString(sb.toString());
    }

    public static NumericType classifyNumeric(String fName, NodeValue nv1, NodeValue nv2) {
        if (!nv1.isNumber()) {
            throw new ExprEvalTypeException("Not a number (first arg to " + fName + "): " + nv1);
        }
        if (!nv2.isNumber()) {
            throw new ExprEvalTypeException("Not a number (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isInteger()) {
            if (nv2.isInteger()) {
                return NumericType.OP_INTEGER;
            }
            if (nv2.isDecimal()) {
                return NumericType.OP_DECIMAL;
            }
            if (nv2.isFloat()) {
                return NumericType.OP_FLOAT;
            }
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isDecimal()) {
            if (nv2.isDecimal()) {
                return NumericType.OP_DECIMAL;
            }
            if (nv2.isFloat()) {
                return NumericType.OP_FLOAT;
            }
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isFloat()) {
            if (nv2.isFloat()) {
                return NumericType.OP_FLOAT;
            }
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isDouble()) {
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        throw new ARQInternalErrorException("Numeric op unrecognized (first arg to " + fName + "): " + nv1);
    }

    public static NumericType classifyNumeric(String fName, NodeValue nv) {
        if (!nv.isNumber()) {
            throw new ExprEvalTypeException("Not a number: (" + fName + ") " + nv);
        }
        if (nv.isInteger()) {
            return NumericType.OP_INTEGER;
        }
        if (nv.isDecimal()) {
            return NumericType.OP_DECIMAL;
        }
        if (nv.isFloat()) {
            return NumericType.OP_FLOAT;
        }
        if (nv.isDouble()) {
            return NumericType.OP_DOUBLE;
        }
        throw new ARQInternalErrorException("Numeric op unrecognized (" + fName + "): " + nv);
    }

    public static boolean isNumericType(XSDDatatype xsdDatatype) {
        if (XSDDatatype.XSDfloat.equals(xsdDatatype)) {
            return true;
        }
        if (XSDDatatype.XSDdouble.equals(xsdDatatype)) {
            return true;
        }
        return XSDFuncOp.isDecimalType(xsdDatatype);
    }

    public static boolean isDecimalType(XSDDatatype xsdDatatype) {
        if (XSDDatatype.XSDdecimal.equals(xsdDatatype)) {
            return true;
        }
        return XSDFuncOp.isIntegerType(xsdDatatype);
    }

    public static boolean isIntegerType(XSDDatatype xsdDatatype) {
        return integerSubTypes.contains(xsdDatatype);
    }

    private static int calcReturn(int x) {
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }

    public static int compareNumeric(NodeValue nv1, NodeValue nv2) {
        NumericType opType = XSDFuncOp.classifyNumeric("compareNumeric", nv1, nv2);
        switch (opType) {
            case OP_INTEGER: {
                return XSDFuncOp.calcReturn(nv1.getInteger().compareTo(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return XSDFuncOp.calcReturn(nv1.getDecimal().compareTo(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return XSDFuncOp.calcReturn(Float.compare(nv1.getFloat(), nv2.getFloat()));
            }
            case OP_DOUBLE: {
                return XSDFuncOp.calcReturn(Double.compare(nv1.getDouble(), nv2.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static int compareString(NodeValue nv1, NodeValue nv2) {
        return XSDFuncOp.calcReturn(nv1.getString().compareTo(nv2.getString()));
    }

    public static int compareDateTime(NodeValue nv1, NodeValue nv2) {
        if (strictDateTimeFO) {
            return XSDFuncOp.compareDateTimeFO(nv1, nv2);
        }
        return XSDFuncOp.compareXSDDateTime(nv1.getDateTime(), nv2.getDateTime());
    }

    public static int compareDuration(NodeValue nv1, NodeValue nv2) {
        return XSDFuncOp.compareXSDDuration(nv1.getDuration(), nv2.getDuration());
    }

    public static int compareGYear(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    public static int compareGYearMonth(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    public static int compareGMonth(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    public static int compareGMonthDay(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    public static int compareGDay(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    private static int compareDateTimeFO(NodeValue nv1, NodeValue nv2) {
        XSDDateTime dt2;
        XSDDateTime dt1 = nv1.getDateTime();
        int x = XSDFuncOp.compareXSDDateTime(dt1, dt2 = nv2.getDateTime());
        if (x == 2) {
            NodeValue nv3 = XSDFuncOp.fixupDateTime(nv1);
            if (nv3 != null) {
                XSDDateTime dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt3, dt2);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            nv3 = XSDFuncOp.fixupDateTime(nv2);
            if (nv3 != null) {
                XSDDateTime dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt1, dt3);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            throw new ARQInternalErrorException("Failed to fixup dateTimes");
        }
        return x;
    }

    private static int compareDateFO(NodeValue nv1, NodeValue nv2) {
        XSDDateTime dt2;
        XSDDateTime dt1 = nv1.getDateTime();
        int x = XSDFuncOp.compareXSDDateTime(dt1, dt2 = nv2.getDateTime());
        if (x == 2) {
            NodeValue nv3 = XSDFuncOp.fixupDate(nv1);
            if (nv3 != null) {
                XSDDateTime dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt3, dt2);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            nv3 = XSDFuncOp.fixupDate(nv2);
            if (nv3 != null) {
                XSDDateTime dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt1, dt3);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            throw new ARQInternalErrorException("Failed to fixup dateTimes");
        }
        return x;
    }

    private static NodeValue fixupDateTime(NodeValue nv) {
        DateTimeStruct dts = DateTimeStruct.parseDateTime(nv.asNode().getLiteralLexicalForm());
        if (dts.timezone != null) {
            return null;
        }
        dts.timezone = defaultTimezone;
        nv = NodeValue.makeDateTime(dts.toString());
        if (!nv.isDateTime()) {
            throw new ARQInternalErrorException("Failed to reform an xsd:dateTime");
        }
        return nv;
    }

    private static NodeValue fixupDate(NodeValue nv) {
        DateTimeStruct dts = DateTimeStruct.parseDate(nv.asNode().getLiteralLexicalForm());
        if (dts.timezone != null) {
            return null;
        }
        dts.timezone = defaultTimezone;
        nv = NodeValue.makeDate(dts.toString());
        if (!nv.isDate()) {
            throw new ARQInternalErrorException("Failed to reform an xsd:date");
        }
        return nv;
    }

    private static int compareXSDDateTime(XSDDateTime dt1, XSDDateTime dt2) {
        int x = dt1.compare(dt2);
        if (x == 0) {
            return 0;
        }
        if (x == -1) {
            return -1;
        }
        if (x == 1) {
            return 1;
        }
        if (x == 2) {
            return 2;
        }
        throw new ARQInternalErrorException("Unexpected return from XSDDateTime.compare: " + x);
    }

    private static int compareXSDDuration(XSDDuration duration1, XSDDuration duration2) {
        int x = duration1.compare(duration2);
        if (x == 0) {
            return 0;
        }
        if (x == -1) {
            return -1;
        }
        if (x == 1) {
            return 1;
        }
        if (x == 2) {
            return 2;
        }
        throw new ARQInternalErrorException("Unexpected return from XSDDuration.compare: " + x);
    }

    public static int compareBoolean(NodeValue nv1, NodeValue nv2) {
        boolean b2;
        boolean b1 = nv1.getBoolean();
        if (b1 == (b2 = nv2.getBoolean())) {
            return 0;
        }
        if (!b1 && b2) {
            return -1;
        }
        if (b1 && !b2) {
            return 1;
        }
        throw new ARQInternalErrorException("Weird boolean comparison: " + nv1 + ", " + nv2);
    }

    public static boolean dateTimeCastCompatible(NodeValue nv, XSDDatatype xsd) {
        return nv.hasDateTime();
    }

    public static NodeValue dateTimeCast(NodeValue nv, String typeURI) {
        RDFDatatype t = Node.getType(typeURI);
        return XSDFuncOp.dateTimeCast(nv, t);
    }

    public static NodeValue dateTimeCast(NodeValue nv, RDFDatatype rdfDatatype) {
        if (!(rdfDatatype instanceof XSDDatatype)) {
            throw new ExprEvalTypeException("Can't cast to XSDDatatype: " + nv);
        }
        XSDDatatype xsd = (XSDDatatype)rdfDatatype;
        return XSDFuncOp.dateTimeCast(nv, xsd);
    }

    public static NodeValue dateTimeCast(NodeValue nv, XSDDatatype xsd) {
        if (!nv.hasDateTime()) {
            throw new ExprEvalTypeException("Not a date/time type: " + nv);
        }
        XSDDateTime xsdDT = nv.getDateTime();
        if (XSDDatatype.XSDdateTime.equals(xsd)) {
            if (nv.isDateTime()) {
                return nv;
            }
            if (!nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:dateTime: " + nv);
            }
            String x = String.format("%04d-%02d-%02dT00:00:00", xsdDT.getYears(), xsdDT.getMonths(), xsdDT.getDays());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDdate.equals(xsd)) {
            if (nv.isDate()) {
                return nv;
            }
            if (!nv.isDateTime()) {
                throw new ExprEvalTypeException("Can't cast to XSD:date: " + nv);
            }
            String x = String.format("%04d-%02d-%02d", xsdDT.getYears(), xsdDT.getMonths(), xsdDT.getDays());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDtime.equals(xsd)) {
            if (nv.isTime()) {
                return nv;
            }
            if (!nv.isDateTime()) {
                throw new ExprEvalTypeException("Can't cast to XSD:time: " + nv);
            }
            DecimalFormat nf = new DecimalFormat("00.####");
            nf.setDecimalSeparatorAlwaysShown(false);
            String x = nf.format(xsdDT.getSeconds());
            x = String.format("%02d:%02d:%s", xsdDT.getHours(), xsdDT.getMinutes(), x);
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgYear.equals(xsd)) {
            if (nv.isGYear()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gYear: " + nv);
            }
            String x = String.format("%04d", xsdDT.getYears());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgYearMonth.equals(xsd)) {
            if (nv.isGYearMonth()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gYearMonth: " + nv);
            }
            String x = String.format("%04d-%02d", xsdDT.getYears(), xsdDT.getMonths());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgMonth.equals(xsd)) {
            if (nv.isGMonth()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gMonth: " + nv);
            }
            String x = String.format("--%02d", xsdDT.getMonths());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgMonthDay.equals(xsd)) {
            if (nv.isGMonthDay()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gMonthDay: " + nv);
            }
            String x = String.format("--%02d-%02d", xsdDT.getMonths(), xsdDT.getDays());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgDay.equals(xsd)) {
            if (nv.isGDay()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gDay: " + nv);
            }
            String x = String.format("---%02d", xsdDT.getDays());
            return NodeValue.makeNode(x, xsd);
        }
        throw new ExprEvalTypeException("Can't case to <" + xsd.getURI() + ">: " + nv);
    }

    public static NodeValue dtGetYear(NodeValue nv) {
        if (nv.isDateTime() || nv.isDate() || nv.isGYear() || nv.isGYearMonth()) {
            DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
            return NodeValue.makeNode(dts.year, XSDDatatype.XSDinteger);
        }
        throw new ExprEvalException("Not a year datatype");
    }

    public static NodeValue dtGetMonth(NodeValue nv) {
        if (nv.isDateTime() || nv.isDate() || nv.isGYearMonth() || nv.isGMonth() || nv.isGMonthDay()) {
            DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
            return NodeValue.makeNode(dts.month, XSDDatatype.XSDinteger);
        }
        throw new ExprEvalException("Not a month datatype");
    }

    public static NodeValue dtGetDay(NodeValue nv) {
        if (nv.isDateTime() || nv.isDate() || nv.isGMonthDay() || nv.isGDay()) {
            DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
            return NodeValue.makeNode(dts.day, XSDDatatype.XSDinteger);
        }
        throw new ExprEvalException("Not a month datatype");
    }

    private static DateTimeStruct parseAnyDT(NodeValue nv) {
        String lex = nv.getNode().getLiteralLexicalForm();
        if (nv.isDateTime()) {
            return DateTimeStruct.parseDateTime(lex);
        }
        if (nv.isDate()) {
            return DateTimeStruct.parseDate(lex);
        }
        if (nv.isGYear()) {
            return DateTimeStruct.parseGYear(lex);
        }
        if (nv.isGYearMonth()) {
            return DateTimeStruct.parseGYearMonth(lex);
        }
        if (nv.isGMonth()) {
            return DateTimeStruct.parseGMonth(lex);
        }
        if (nv.isGMonthDay()) {
            return DateTimeStruct.parseGMonthDay(lex);
        }
        if (nv.isGDay()) {
            return DateTimeStruct.parseGDay(lex);
        }
        if (nv.isTime()) {
            return DateTimeStruct.parseTime(lex);
        }
        return null;
    }

    private static DateTimeStruct parseTime(NodeValue nv) {
        String lex = nv.getNode().getLiteralLexicalForm();
        if (nv.isDateTime()) {
            return DateTimeStruct.parseDateTime(lex);
        }
        if (nv.isTime()) {
            return DateTimeStruct.parseTime(lex);
        }
        throw new ExprEvalException("Not a datatype for time");
    }

    public static NodeValue dtGetHours(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseTime(nv);
        return NodeValue.makeNode(dts.hour, XSDDatatype.XSDinteger);
    }

    public static NodeValue dtGetMinutes(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseTime(nv);
        return NodeValue.makeNode(dts.minute, XSDDatatype.XSDinteger);
    }

    public static NodeValue dtGetSeconds(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseTime(nv);
        return NodeValue.makeNode(dts.second, XSDDatatype.XSDdecimal);
    }

    public static NodeValue dtGetTZ(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
        if (dts == null) {
            throw new ExprEvalException("Not a data/time value: " + nv);
        }
        if (dts.timezone == null) {
            return NodeValue.nvEmptyString;
        }
        return NodeValue.makeString(dts.timezone);
    }

    public static NodeValue dtGetTimezone(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
        if (dts == null || dts.timezone == null) {
            throw new ExprEvalException("Not a datatype with a timezone: " + nv);
        }
        if ("".equals(dts.timezone)) {
            return null;
        }
        if (defaultTimezone.equals(dts.timezone)) {
            Node n = Node.createLiteral("PT0S", null, Node.getType("http://www.w3.org/2001/XMLSchema#dayTimeDuration"));
            return NodeValue.makeNode(n);
        }
        if ("+00:00".equals(dts.timezone)) {
            Node n = Node.createLiteral("PT0S", null, Node.getType("http://www.w3.org/2001/XMLSchema#dayTimeDuration"));
            return NodeValue.makeNode(n);
        }
        if ("-00:00".equals(dts.timezone)) {
            Node n = Node.createLiteral("-PT0S", null, Node.getType("http://www.w3.org/2001/XMLSchema#dayTimeDuration"));
            return NodeValue.makeNode(n);
        }
        String s = dts.timezone;
        int idx = 0;
        StringBuilder sb = new StringBuilder();
        if (s.charAt(0) == '-') {
            sb.append('-');
        }
        sb.append("PT");
        XSDFuncOp.digitsTwo(s, ++idx, sb, 'H');
        idx += 2;
        XSDFuncOp.digitsTwo(s, ++idx, sb, 'M');
        idx += 2;
        return NodeValue.makeNode(sb.toString(), null, "http://www.w3.org/2001/XMLSchema#dayTimeDuration");
    }

    private static void digitsTwo(String s, int idx, StringBuilder sb, char indicator) {
        if (s.charAt(idx) == '0') {
            if (s.charAt(++idx) != '0') {
                sb.append(s.charAt(idx));
                sb.append(indicator);
            }
            ++idx;
        } else {
            sb.append(s.charAt(idx));
            sb.append(s.charAt(++idx));
            ++idx;
            sb.append(indicator);
        }
    }

    static {
        integerSubTypes.add(XSDDatatype.XSDint);
        integerSubTypes.add(XSDDatatype.XSDlong);
        integerSubTypes.add(XSDDatatype.XSDshort);
        integerSubTypes.add(XSDDatatype.XSDbyte);
        integerSubTypes.add(XSDDatatype.XSDunsignedByte);
        integerSubTypes.add(XSDDatatype.XSDunsignedShort);
        integerSubTypes.add(XSDDatatype.XSDunsignedInt);
        integerSubTypes.add(XSDDatatype.XSDunsignedLong);
        integerSubTypes.add(XSDDatatype.XSDinteger);
        integerSubTypes.add(XSDDatatype.XSDnonPositiveInteger);
        integerSubTypes.add(XSDDatatype.XSDnonNegativeInteger);
        integerSubTypes.add(XSDDatatype.XSDpositiveInteger);
        integerSubTypes.add(XSDDatatype.XSDnegativeInteger);
        strictDateTimeFO = false;
    }
}

