/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProcessBinding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.io.IndentedWriter;

public class QueryIterAssign
extends QueryIterProcessBinding {
    private VarExprList exprs;
    private final boolean mustBeNewVar;

    public QueryIterAssign(QueryIterator input, Var var, Expr expr, ExecutionContext qCxt) {
        this(input, new VarExprList(var, expr), qCxt, false);
    }

    public QueryIterAssign(QueryIterator input, VarExprList exprs, ExecutionContext qCxt, boolean mustBeNewVar) {
        super(input, qCxt);
        this.exprs = exprs;
        this.mustBeNewVar = mustBeNewVar;
    }

    @Override
    public Binding accept(Binding binding) {
        BindingMap b = BindingFactory.create(binding);
        for (Var v : this.exprs.getVars()) {
            Node n = this.exprs.get(v, b, this.getExecContext());
            if (n == null) continue;
            if (b.contains(v)) {
                if (this.mustBeNewVar) {
                    throw new QueryExecException("Already set: " + v);
                }
                Node n2 = b.get(v);
                if (n2.sameValueAs(n)) continue;
                return null;
            }
            b.add(v, n);
        }
        return b;
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext cxt) {
        out.print(Utils.className(this));
        out.print(" ");
        out.print(this.exprs.toString());
    }
}

