/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.engine.http.HttpQuery;
import com.hp.hpl.jena.sparql.engine.http.Params;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.resultset.XMLInput;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjena.atlas.lib.NotImplemented;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEngineHTTP
implements QueryExecution {
    private static Logger log = LoggerFactory.getLogger(QueryEngineHTTP.class);
    public static final String QUERY_MIME_TYPE = "application/sparql-query";
    private final Query query;
    private final String queryString;
    private final String service;
    private final Context context;
    Params params = null;
    List<String> defaultGraphURIs = new ArrayList<String>();
    List<String> namedGraphURIs = new ArrayList<String>();
    private String user = null;
    private char[] password = null;
    private boolean finished = false;
    private InputStream retainedConnection = null;

    public QueryEngineHTTP(String serviceURI, Query query2) {
        this(serviceURI, query2, query2.toString());
    }

    public QueryEngineHTTP(String serviceURI, String queryString) {
        this(serviceURI, null, queryString);
    }

    private QueryEngineHTTP(String serviceURI, Query query2, String queryString) {
        this.query = query2;
        this.queryString = queryString;
        this.service = serviceURI;
        this.context = new Context(ARQ.getContext());
    }

    @Override
    public void setFileManager(FileManager fm) {
        throw new UnsupportedOperationException("FileManagers do not apply to remote query execution");
    }

    @Override
    public void setInitialBinding(QuerySolution binding) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries");
    }

    public void setInitialBindings(ResultSet table) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries");
    }

    public void setDefaultGraphURIs(List<String> defaultGraphURIs) {
        this.defaultGraphURIs = defaultGraphURIs;
    }

    public void setNamedGraphURIs(List<String> namedGraphURIs) {
        this.namedGraphURIs = namedGraphURIs;
    }

    public void addParam(String field, String value) {
        if (this.params == null) {
            this.params = new Params();
        }
        this.params.addParam(field, value);
    }

    public void addDefaultGraph(String defaultGraph) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList<String>();
        }
        this.defaultGraphURIs.add(defaultGraph);
    }

    public void addNamedGraph(String name) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        this.namedGraphURIs.add(name);
    }

    public void setBasicAuthentication(String user, char[] password) {
        this.user = user;
        this.password = password;
    }

    @Override
    public ResultSet execSelect() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = httpQuery.exec();
        ResultSet rs = ResultSetFactory.fromXML(in);
        this.retainedConnection = in;
        return rs;
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execConstruct(Model model) {
        return this.execModel(model);
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execDescribe(Model model) {
        return this.execModel(model);
    }

    private Model execModel(Model model) {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/rdf+xml");
        InputStream in = httpQuery.exec();
        model.read(in, null);
        return model;
    }

    @Override
    public boolean execAsk() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = httpQuery.exec();
        boolean result = XMLInput.booleanFromXML(in);
        try {
            in.close();
        }
        catch (IOException e2) {
            log.warn("Failed to close connection", e2);
        }
        return result;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Dataset getDataset() {
        return null;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public void setTimeout(long timeout) {
        throw new NotImplemented("Not implemented yet - please send a patch to the Apache Jena project : https://issues.apache.org/jira/browse/JENA-56");
    }

    @Override
    public void setTimeout(long timeout1, long timeout2) {
        throw new NotImplemented("Not implemented yet - please send a patch to the Apache Jena project : https://issues.apache.org/jira/browse/JENA-56");
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeoutUnits) {
        throw new NotImplemented("Not implemented yet - please send a patch to the Apache Jena project : https://issues.apache.org/jira/browse/JENA-56");
    }

    @Override
    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        throw new NotImplemented("Not implemented yet - please send a patch to the Apache Jena project : https://issues.apache.org/jira/browse/JENA-56");
    }

    private HttpQuery makeHttpQuery() {
        if (this.finished) {
            throw new ARQException("HTTP execution already closed");
        }
        HttpQuery httpQuery = new HttpQuery(this.service);
        httpQuery.addParam("query", this.queryString);
        for (String dft : this.defaultGraphURIs) {
            httpQuery.addParam("default-graph-uri", dft);
        }
        for (String name : this.namedGraphURIs) {
            httpQuery.addParam("named-graph-uri", name);
        }
        if (this.params != null) {
            httpQuery.merge(this.params);
        }
        httpQuery.setBasicAuthentication(this.user, this.password);
        return httpQuery;
    }

    public void cancel() {
        this.finished = true;
    }

    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.finished = false;
        if (this.retainedConnection != null) {
            try {
                this.retainedConnection.close();
            }
            catch (IOException e2) {
                log.warn("Failed to close connection", e2);
            }
            finally {
                this.retainedConnection = null;
            }
        }
    }

    public String toString() {
        HttpQuery httpQuery = this.makeHttpQuery();
        return "GET " + httpQuery.toString();
    }
}

