/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BindingIndex
implements VariableIndexes,
IndexValues {
    List<String> indexes = new ArrayList<String>();
    Binding binding;

    public BindingIndex(Binding b) {
        this.binding = b;
        Iterator<Var> iter = this.binding.vars();
        while (iter.hasNext()) {
            Var var = iter.next();
            this.indexes.add(var.getVarName());
        }
    }

    @Override
    public int indexOf(String varname) {
        for (int i = 0; i < this.indexes.size(); ++i) {
            if (!this.indexes.get(i).equals(varname)) continue;
            return i;
        }
        throw new DoesNotExistException("Name not bound: " + varname);
    }

    @Override
    public Object get(int index) {
        if (index < 0 || index > this.indexes.size()) {
            return null;
        }
        String name = this.indexes.get(index);
        return this.binding.get(Var.alloc(name));
    }
}

