/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.table;

import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.table.TableBase;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TableN
extends TableBase {
    protected List<Binding> rows = new ArrayList<Binding>();
    protected List<Var> vars = new ArrayList<Var>();

    public TableN() {
    }

    public TableN(QueryIterator qIter) {
        this.materialize(qIter);
    }

    public void materialize(QueryIterator qIter) {
        while (qIter.hasNext()) {
            Binding binding = qIter.nextBinding();
            this.addBinding(binding);
        }
        qIter.close();
    }

    @Override
    public void addBinding(Binding binding) {
        Iterator<Var> names = binding.vars();
        while (names.hasNext()) {
            Var v = names.next();
            if (this.vars.contains(v)) continue;
            this.vars.add(v);
        }
        this.rows.add(binding);
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public QueryIterator matchRightLeft(Binding bindingLeft, boolean includeOnNoMatch, ExprList conditions, ExecutionContext execContext) {
        ArrayList<Binding> out = new ArrayList<Binding>();
        for (Binding bindingRight : this.rows) {
            Binding r = Algebra.merge(bindingLeft, bindingRight);
            if (r == null || conditions != null && !conditions.isSatisfied(r, execContext)) continue;
            out.add(r);
        }
        if (out.size() == 0 && includeOnNoMatch) {
            out.add(bindingLeft);
        }
        if (out.size() == 0) {
            return new QueryIterNullIterator(execContext);
        }
        return new QueryIterPlainWrapper(out.iterator(), execContext);
    }

    @Override
    public QueryIterator iterator(ExecutionContext execCxt) {
        return new QueryIterPlainWrapper(this.rows.iterator(), execCxt);
    }

    @Override
    public void closeTable() {
        this.rows = null;
    }

    @Override
    public List<String> getVarNames() {
        return Var.varNames(this.vars);
    }

    @Override
    public List<Var> getVars() {
        return this.vars;
    }
}

