/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid;

import com.hp.hpl.jena.shared.uuid.Bits;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.shared.uuid.LibUUID;
import com.hp.hpl.jena.shared.uuid.UUIDFactory;
import com.hp.hpl.jena.shared.uuid.UUID_V1;

public class UUID_V1_Gen
implements UUIDFactory {
    static final int versionHere = 1;
    static final int variantHere = 2;
    static final long maskTimeLow = -4294967296L;
    static final long maskTimeMid = 0xFFFF0000L;
    static final long maskTimeHigh = 4095L;
    static final long maskVersion = 61440L;
    static final long maskVariant = -4611686018427387904L;
    static final long maskClockSeq = 0x3FFF000000000000L;
    static final long maskNode = 0xFFFFFFFFFFFFL;
    long gregorianTime = 0L;
    static final long UUIDS_PER_TICK = 100L;
    long uuids_this_tick = 101L;
    int clockSeq = 0;
    private static final int CLOCK_BITS = 8;
    long node = 0L;
    private long lastTime = 0L;
    private long DELAY = 10L;

    public UUID_V1_Gen() {
        this.reset();
    }

    @Override
    public void reset() {
        this.setInitialState();
        this.setTime();
    }

    @Override
    public JenaUUID generate() {
        return this.generateV1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID_V1 generateV1() {
        long timestamp = 0L;
        UUID_V1_Gen uUID_V1_Gen = this;
        synchronized (uUID_V1_Gen) {
            if (this.uuids_this_tick >= 100L) {
                this.setTime();
            }
            timestamp = this.gregorianTime + this.uuids_this_tick;
            ++this.uuids_this_tick;
        }
        return this.generate(timestamp);
    }

    @Override
    public JenaUUID parse(String s) throws JenaUUID.FormatException {
        if ((s = s.toLowerCase()).length() != 36) {
            throw new JenaUUID.FormatException("UUID string is not 36 chars long: it's " + s.length() + " [" + s + "]");
        }
        if (s.charAt(8) != '-' && s.charAt(13) != '-' && s.charAt(18) != '-' && s.charAt(23) != '-') {
            throw new JenaUUID.FormatException("String does not have dashes in the right places: " + s);
        }
        UUID_V1 u = UUID_V1_Gen.parse$(s);
        if (u.getVersion() != 1) {
            throw new JenaUUID.FormatException("Wrong version (Expected: 1Got: " + u.getVersion() + "): " + s);
        }
        if (u.getVariant() != 2) {
            throw new JenaUUID.FormatException("Wrong version (Expected: 2Got: " + u.getVariant() + "): " + s);
        }
        return u;
    }

    static UUID_V1 parse$(String s) {
        int x = (int)Bits.unpack(s, 19, 23);
        int variant = x >>> 14;
        int clockSeq = x & 0x3FFF;
        long timeHigh = Bits.unpack(s, 15, 18);
        long timeMid = Bits.unpack(s, 9, 13);
        long timeLow = Bits.unpack(s, 0, 8);
        long node = Bits.unpack(s, 24, 36);
        int version2 = (int)Bits.unpack(s, 14, 15);
        return UUID_V1_Gen.generate(version2, variant, timeHigh, timeMid, timeLow, clockSeq, node);
    }

    public static String unparse(UUID_V1 uuid) {
        int _variant = uuid.getVariant();
        int _version = uuid.getVersion();
        long timeHigh = uuid.getTimeHigh();
        long timeMid = uuid.getTimeMid();
        long timeLow = uuid.getTimeLow();
        long node = uuid.getNode();
        long clockSeq = uuid.getClockSequence();
        StringBuffer sBuff = new StringBuffer();
        JenaUUID.toHex(sBuff, timeLow, 4);
        sBuff.append('-');
        JenaUUID.toHex(sBuff, timeMid, 2);
        sBuff.append('-');
        JenaUUID.toHex(sBuff, (long)(_version << 12) | timeHigh, 2);
        sBuff.append('-');
        JenaUUID.toHex(sBuff, (long)_variant << 14 | clockSeq, 2);
        sBuff.append('-');
        JenaUUID.toHex(sBuff, node, 6);
        return sBuff.toString();
    }

    private UUID_V1 generate(long timestamp) {
        return UUID_V1_Gen.generate(1, 2, timestamp, this.clockSeq, this.node);
    }

    public static UUID_V1 generate(int version2, int variant, long timestamp, long clockSeq, long node) {
        long timeHigh = timestamp >>> 48;
        long timeMid = timestamp >>> 32 & 0xFFFFL;
        long timeLow = timestamp & 0xFFFFFFFFL;
        return UUID_V1_Gen.generate(version2, variant, timeHigh, timeMid, timeLow, clockSeq, node);
    }

    private static UUID_V1 generate(int version2, int variant, long timeHigh, long timeMid, long timeLow, long clockSeq, long node) {
        long mostSigBits = timeLow << 32 | timeMid << 16 | 0x1000L | timeHigh;
        long leastSigBits = Long.MIN_VALUE | clockSeq << 48 | node;
        return new UUID_V1(mostSigBits, leastSigBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTime() {
        long time = 0L;
        UUID_V1_Gen uUID_V1_Gen = this;
        synchronized (uUID_V1_Gen) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            boolean done = false;
            while (!done) {
                time = System.currentTimeMillis();
                if (time < this.lastTime + this.DELAY) {
                    try {
                        Thread.sleep(this.DELAY);
                    }
                    catch (InterruptedException e2) {}
                    continue;
                }
                done = true;
            }
        }
        this.lastTime = time;
        this.uuids_this_tick = 0L;
        this.gregorianTime = time * 10L + 122192928000000000L;
    }

    private void setInitialState() {
        long random = LibUUID.makeRandom().nextLong();
        this.node = Bits.unpack(random, 0, 47);
        this.node = Bits.set(this.node, 47);
        this.clockSeq = 0;
        this.clockSeq = (int)Bits.unpack(random, 48, 56);
    }
}

