/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssembler;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.util.DatasetUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;

public class DatasetFactory {
    public static Dataset createMem() {
        return DatasetFactory.create(DatasetGraphFactory.createMem());
    }

    public static Dataset createMemFixed() {
        return DatasetFactory.create(DatasetGraphFactory.createMem());
    }

    @Deprecated
    public static DataSource create() {
        return new DatasetImpl(ModelFactory.createModelForGraph(GraphFactory.createDefaultGraph()));
    }

    public static DataSource create(Model model) {
        return new DatasetImpl(model);
    }

    public static DataSource create(Dataset dataset) {
        return new DatasetImpl(dataset);
    }

    public static DataSource create(DatasetGraph dataset) {
        return (DataSource)DatasetImpl.wrap(dataset);
    }

    public static Dataset create(List<String> uriList) {
        return DatasetFactory.create(uriList, null, null, null);
    }

    public static Dataset create(String uri) {
        return DatasetFactory.create(uri, null, null, null);
    }

    public static Dataset create(List<String> uriList, FileManager fileManager) {
        return DatasetFactory.create(uriList, null, fileManager, null);
    }

    public static Dataset create(String uri, FileManager fileManager) {
        return DatasetFactory.create(uri, null, fileManager, null);
    }

    public static Dataset createNamed(List<String> namedSourceList, FileManager fileManager) {
        return DatasetFactory.create((List<String>)null, namedSourceList, fileManager, null);
    }

    public static Dataset create(List<String> uriList, List<String> namedSourceList) {
        return DatasetFactory.create(uriList, namedSourceList, null, null);
    }

    public static Dataset create(String uri, List<String> namedSourceList) {
        return DatasetFactory.create(uri, namedSourceList, null, null);
    }

    public static Dataset create(String uri, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDataset(uri, namedSourceList, fileManager, baseURI);
    }

    public static Dataset create(List<String> uriList, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDataset(uriList, namedSourceList, fileManager, baseURI);
    }

    public static Dataset make(Dataset ds, Model defaultModel) {
        DatasetImpl ds2 = new DatasetImpl(ds);
        ds2.setDefaultModel(defaultModel);
        return ds2;
    }

    public static Dataset assemble(String filename) {
        Model model = FileManager.get().loadModel(filename);
        return DatasetFactory.assemble(model);
    }

    public static Dataset assemble(Model model) {
        Resource r = GraphUtils.findRootByType(model, DatasetAssembler.getType());
        if (r == null) {
            throw new ARQException("No root found for type <" + DatasetAssembler.getType() + ">");
        }
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Resource resource) {
        Dataset ds = (Dataset)Assembler.general.open(resource);
        return ds;
    }
}

