/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.n3.N3IndentedWriter;
import com.hp.hpl.jena.n3.N3JenaWriter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class N3JenaWriterCommon
implements RDFWriter {
    static Logger logger = LoggerFactory.getLogger(N3JenaWriterCommon.class);
    protected Map<String, Object> writerPropertyMap = null;
    protected boolean alwaysAllocateBNodeLabel = false;
    protected RDFErrorHandler errorHandler = null;
    protected Map<String, String> prefixMap = new HashMap<String, String>();
    protected Map<String, String> reversePrefixMap = new HashMap<String, String>();
    protected Map<Resource, String> bNodesMap = null;
    protected int bNodeCounter = 0;
    protected static final String NS_W3_log = "http://www.w3.org/2000/10/swap/log#";
    protected static Map<String, String> wellKnownPropsMapN3 = new HashMap<String, String>();
    protected static Map<String, String> wellKnownPropsMapTurtle;
    protected Map<String, String> wellKnownPropsMap = wellKnownPropsMapN3;
    protected N3IndentedWriter out = null;
    protected int minGap = this.getIntValue("minGap", 1);
    protected String minGapStr = N3JenaWriterCommon.pad(this.minGap);
    protected int indentProperty = this.getIntValue("indentProperty", 6);
    protected int widePropertyLen = this.getIntValue("widePropertyLen", 20);
    protected int propertyCol;
    protected int indentObject = this.propertyCol = this.getIntValue("propertyColumn", 8);
    protected int subjectColumn = this.getIntValue("subjectColumn", this.indentProperty);
    protected int shortSubject = this.subjectColumn - this.minGap;
    protected boolean useWellKnownPropertySymbols = this.getBooleanValue("usePropertySymbols", true);
    protected boolean allowTripleQuotedStrings = this.getBooleanValue("useTripleQuotedStrings", true);
    protected boolean allowDoubles = this.getBooleanValue("useDoubles", true);
    protected boolean allowDecimals = this.getBooleanValue("useDecimals", true);
    protected static final String WS = "\n\r\t";

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        if (!(propValue instanceof String)) {
            logger.warn("N3.setProperty: Property for '" + propName + "' is not a string");
            propValue = propValue.toString();
        }
        propName = this.absolutePropName(propName);
        if (this.writerPropertyMap == null) {
            this.writerPropertyMap = new HashMap<String, Object>();
        }
        Object oldValue = this.writerPropertyMap.get(propName);
        this.writerPropertyMap.put(propName, propValue);
        return oldValue;
    }

    @Override
    public void write(Model baseModel, Writer _out, String base) {
        if (!(_out instanceof BufferedWriter)) {
            _out = new BufferedWriter(_out);
        }
        this.out = new N3IndentedWriter(_out);
        this.processModel(baseModel);
    }

    @Override
    public synchronized void write(Model model, OutputStream output, String base) {
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            this.write(model, w, base);
            try {
                ((Writer)w).flush();
            }
            catch (IOException ioEx) {}
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Failed to create UTF-8 writer");
        }
    }

    protected void startWriting() {
    }

    protected void finishWriting() {
    }

    protected void prepare(Model model) {
    }

    protected void processModel(Model baseModel) {
        this.prefixMap = baseModel.getNsPrefixMap();
        Model model = ModelFactory.withHiddenStatements(baseModel);
        this.bNodesMap = new HashMap<Resource, String>();
        String base2 = this.prefixMap.get("");
        Iterator<Map.Entry<String, String>> iter = this.prefixMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> e2 = iter.next();
            String prefix = e2.getKey();
            String uri = e2.getValue();
            if (!N3JenaWriterCommon.checkPrefixPart(prefix)) {
                iter.remove();
                continue;
            }
            if (!N3JenaWriterCommon.checkPrefixPart(prefix)) continue;
            this.reversePrefixMap.put(uri, prefix);
        }
        this.startWriting();
        this.prepare(model);
        this.writeHeader(model);
        this.writePrefixes(model);
        if (this.prefixMap.size() != 0) {
            this.out.println();
        }
        this.writeModel(model);
        this.finishWriting();
        this.bNodesMap = null;
    }

    protected void writeModel(Model model) {
        boolean doingFirst = true;
        ResIterator rIter = this.listSubjects(model);
        while (rIter.hasNext()) {
            Resource subject = rIter.nextResource();
            if (this.skipThisSubject(subject)) {
                if (!N3JenaWriter.DEBUG) continue;
                this.out.println("# Skipping: " + this.formatResource(subject));
                continue;
            }
            if (doingFirst) {
                doingFirst = false;
            } else {
                this.out.println();
            }
            this.writeOneGraphNode(subject);
        }
        rIter.close();
    }

    protected ResIterator listSubjects(Model model) {
        return model.listSubjects();
    }

    protected void writeOneGraphNode(Resource subject) {
        this.out.incIndent(this.indentProperty);
        this.writeSubject(subject);
        ClosableIterator<Property> iter = this.preparePropertiesForSubject(subject);
        this.writePropertiesForSubject(subject, iter);
        this.out.decIndent(this.indentProperty);
        this.out.println(" .");
    }

    protected void writePropertiesForSubject(Resource subj, ClosableIterator<Property> iter) {
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            this.writeObjectList(subj, property);
            if (!iter.hasNext()) continue;
            this.out.println(" ;");
        }
        iter.close();
    }

    protected boolean skipThisSubject(Resource r) {
        return false;
    }

    protected void writeSubject(Resource subject) {
        String subjStr = this.formatResource(subject);
        this.out.print(subjStr);
        if (subjStr.length() < this.shortSubject) {
            this.out.print(N3JenaWriterCommon.pad(this.subjectColumn - subjStr.length()));
        } else {
            this.out.println();
        }
    }

    protected void writeHeader(Model model) {
    }

    protected N3IndentedWriter getOutput() {
        return this.out;
    }

    protected Map<String, String> getPrefixes() {
        return this.prefixMap;
    }

    protected void writePrefixes(Model model) {
        for (String p : this.prefixMap.keySet()) {
            String u = this.prefixMap.get(p);
            String tmp = "@prefix " + p + ": ";
            this.out.print(tmp);
            this.out.print(N3JenaWriterCommon.pad(16 - tmp.length()));
            this.out.println(" <" + u + "> .");
        }
    }

    protected void writeObjectList(Resource subject, Property property) {
        String propStr = this.formatProperty(property);
        StmtIterator sIter = subject.listProperties(property);
        while (sIter.hasNext()) {
            Statement stmt = sIter.nextStatement();
            String objStr = this.formatNode(stmt.getObject());
            this.out.print(propStr);
            this.out.incIndent(this.indentObject);
            if (propStr.length() + this.minGap <= this.widePropertyLen) {
                int padding = this.calcPropertyPadding(propStr);
                this.out.print(N3JenaWriterCommon.pad(padding));
            } else {
                this.out.println();
            }
            this.out.print(objStr);
            this.out.decIndent(this.indentObject);
            if (!sIter.hasNext()) continue;
            this.out.println(" ;");
        }
        sIter.close();
    }

    protected String formatNode(RDFNode node) {
        if (node instanceof Literal) {
            return this.formatLiteral((Literal)node);
        }
        return this.formatResource((Resource)node);
    }

    protected void writeObject(RDFNode node) {
        if (node instanceof Literal) {
            this.writeLiteral((Literal)node);
            return;
        }
        Resource rObj = (Resource)node;
        this.out.print(this.formatResource(rObj));
    }

    protected void writeLiteral(Literal literal) {
        this.out.print(this.formatLiteral(literal));
    }

    protected ClosableIterator<Property> preparePropertiesForSubject(Resource r) {
        HashSet<Property> properties = new HashSet<Property>();
        StmtIterator sIter = r.listProperties();
        while (sIter.hasNext()) {
            properties.add(sIter.nextStatement().getPredicate());
        }
        sIter.close();
        return WrappedIterator.create(properties.iterator());
    }

    protected String formatResource(Resource r) {
        if (r.isAnon()) {
            if (!this.alwaysAllocateBNodeLabel) {
                StmtIterator sIter = r.getModel().listStatements(null, null, r);
                if (!sIter.hasNext()) {
                    sIter.close();
                    return "[]";
                }
                sIter.close();
            }
            if (!this.bNodesMap.containsKey(r)) {
                this.bNodesMap.put(r, "_:b" + ++this.bNodeCounter);
            }
            return this.bNodesMap.get(r);
        }
        if (((Object)r).equals(RDF.nil)) {
            return "()";
        }
        return this.formatURI(r.getURI());
    }

    protected String formatLiteral(Literal literal) {
        String datatype = literal.getDatatypeURI();
        String lang = literal.getLanguage();
        String s = literal.getLexicalForm();
        if (datatype != null) {
            if (datatype.equals(XSD.integer.getURI())) {
                try {
                    new BigInteger(s);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.decimal.getURI()) && s.indexOf(46) >= 0 && s.indexOf(101) == -1 && s.indexOf(69) == -1) {
                try {
                    BigDecimal d = new BigDecimal(s);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (this.allowDoubles && datatype.equals(XSD.xdouble.getURI()) && (s.indexOf(101) >= 0 || s.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(s);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        StringBuffer sbuff = new StringBuffer();
        boolean singleQuoteLiteral = true;
        String quoteMarks = "\"";
        if (this.allowTripleQuotedStrings && (s.indexOf("\n") != -1 || s.indexOf("\r") != -1 || s.indexOf("\f") != -1)) {
            quoteMarks = "\"\"\"";
            singleQuoteLiteral = false;
        }
        sbuff.append(quoteMarks);
        N3JenaWriterCommon.string(sbuff, s, singleQuoteLiteral);
        sbuff.append(quoteMarks);
        if (lang != null && lang.length() > 0) {
            sbuff.append("@");
            sbuff.append(lang);
        }
        if (datatype != null) {
            sbuff.append("^^");
            sbuff.append(this.formatURI(datatype));
        }
        return sbuff.toString();
    }

    protected String formatProperty(Property p) {
        String prop = p.getURI();
        if (this.useWellKnownPropertySymbols && this.wellKnownPropsMap.containsKey(prop)) {
            return this.wellKnownPropsMap.get(prop);
        }
        return this.formatURI(prop);
    }

    protected String formatURI(String uriStr) {
        String localPart;
        String x;
        String prefix;
        String matchURI = "";
        Object matchPrefix = null;
        int idx = N3JenaWriterCommon.splitIdx(uriStr);
        if (idx >= 0 && (prefix = this.reversePrefixMap.get(x = uriStr.substring(0, idx + 1))) != null && N3JenaWriterCommon.checkNamePart(localPart = uriStr.substring(idx + 1))) {
            return prefix + ':' + localPart;
        }
        return "<" + uriStr + ">";
    }

    protected static int splitIdx(String uriStr) {
        int idx = uriStr.lastIndexOf(35);
        if (idx >= 0) {
            return idx;
        }
        idx = uriStr.lastIndexOf(47);
        return idx;
    }

    protected static boolean checkPrefixedName(String ns, String local) {
        return N3JenaWriterCommon.checkPrefixPart(ns) && N3JenaWriterCommon.checkNamePart(local);
    }

    protected static boolean checkPrefixPart(String s) {
        if (s.length() == 0) {
            return true;
        }
        StringCharacterIterator cIter = new StringCharacterIterator(s);
        char ch = cIter.first();
        if (!N3JenaWriterCommon.checkNameStartChar(ch)) {
            return false;
        }
        if (ch == '_') {
            return false;
        }
        return N3JenaWriterCommon.checkNameTail(cIter);
    }

    protected static boolean checkNamePart(String s) {
        if (s.length() == 0) {
            return true;
        }
        StringCharacterIterator cIter = new StringCharacterIterator(s);
        char ch = cIter.first();
        if (!N3JenaWriterCommon.checkNameStartChar(ch)) {
            return false;
        }
        return N3JenaWriterCommon.checkNameTail(cIter);
    }

    private static boolean checkNameTail(CharacterIterator cIter) {
        char ch = cIter.next();
        while (ch != '\uffff') {
            if (!N3JenaWriterCommon.checkNameChar(ch)) {
                return false;
            }
            ch = cIter.next();
        }
        return true;
    }

    protected static boolean checkNameStartChar(char ch) {
        if (Character.isLetter(ch)) {
            return true;
        }
        return ch == '_';
    }

    protected static boolean checkNameChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        if (ch == '_') {
            return true;
        }
        return ch == '-';
    }

    protected static void string(StringBuffer sbuff, String s, boolean singleQuoteLiteral) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sbuff.append('\\');
                sbuff.append(c);
                continue;
            }
            if (singleQuoteLiteral && (c == '\n' || c == '\r' || c == '\f')) {
                if (c == '\n') {
                    sbuff.append("\\n");
                }
                if (c == '\t') {
                    sbuff.append("\\t");
                }
                if (c == '\r') {
                    sbuff.append("\\r");
                }
                if (c != '\f') continue;
                sbuff.append("\\f");
                continue;
            }
            sbuff.append(c);
        }
    }

    protected int calcPropertyPadding(String propStr) {
        int padding = this.propertyCol - propStr.length();
        if (padding < this.minGap) {
            padding = this.minGap;
        }
        return padding;
    }

    protected static String pad(int cols) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cols; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    protected int countProperties(Resource r) {
        int numProp = 0;
        StmtIterator sIter = r.listProperties();
        while (sIter.hasNext()) {
            sIter.nextStatement();
            ++numProp;
        }
        sIter.close();
        return numProp;
    }

    protected int countProperties(Resource r, Property p) {
        int numProp = 0;
        StmtIterator sIter = r.listProperties(p);
        while (sIter.hasNext()) {
            sIter.nextStatement();
            ++numProp;
        }
        sIter.close();
        return numProp;
    }

    protected int countArcsTo(Resource resource) {
        return this.countArcsTo(null, resource);
    }

    protected int countArcsTo(Property prop, Resource resource) {
        int numArcs = 0;
        StmtIterator sIter = resource.getModel().listStatements(null, prop, resource);
        while (sIter.hasNext()) {
            sIter.nextStatement();
            ++numArcs;
        }
        sIter.close();
        return numArcs;
    }

    protected Iterator<RDFNode> rdfListIterator(Resource r) {
        ArrayList<RDFNode> list = new ArrayList<RDFNode>();
        while (!((Object)r).equals(RDF.nil)) {
            StmtIterator sIter = r.getModel().listStatements(r, RDF.first, (RDFNode)null);
            list.add(sIter.nextStatement().getObject());
            if (sIter.hasNext()) {
                throw new JenaException("N3: Multi valued list item");
            }
            sIter = r.getModel().listStatements(r, RDF.rest, (RDFNode)null);
            r = (Resource)sIter.nextStatement().getObject();
            if (!sIter.hasNext()) continue;
            throw new JenaException("N3: List has two tails");
        }
        return list.iterator();
    }

    protected String getStringValue(String prop, String defaultValue) {
        String p = this.getPropValue(prop);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    protected boolean getBooleanValue(String prop, boolean defaultValue) {
        String p = this.getPropValue(prop);
        if (p == null) {
            return defaultValue;
        }
        if (p.equalsIgnoreCase("true")) {
            return true;
        }
        return p.equals("1");
    }

    protected int getIntValue(String prop, int defaultValue) {
        String p = this.getPropValue(prop);
        if (p == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException ex) {
            logger.warn("Format error for property: " + prop);
            return defaultValue;
        }
    }

    protected String getPropValue(String prop) {
        prop = this.absolutePropName(prop);
        if (this.writerPropertyMap != null && this.writerPropertyMap.containsKey(prop)) {
            Object obj = this.writerPropertyMap.get(prop);
            if (!(obj instanceof String)) {
                logger.warn("getPropValue: N3 Property for '" + prop + "' is not a string");
            }
            return (String)obj;
        }
        String s = JenaRuntime.getSystemProperty(prop);
        if (s == null) {
            s = JenaRuntime.getSystemProperty(this.localPropName(prop));
        }
        return s;
    }

    protected String absolutePropName(String propName) {
        if (propName.indexOf(58) == -1) {
            return "http://jena.hpl.hp.com/n3/properties/" + propName;
        }
        return propName;
    }

    protected String localPropName(String propName) {
        if (propName.startsWith("http://jena.hpl.hp.com/n3/properties/")) {
            propName = propName.substring("http://jena.hpl.hp.com/n3/properties/".length());
        }
        return propName;
    }

    private boolean isOpaque(String uri) {
        try {
            return new URI(uri).isOpaque();
        }
        catch (URISyntaxException ex) {
            return true;
        }
    }

    static {
        wellKnownPropsMapN3.put("http://www.w3.org/2000/10/swap/log#implies", "=>");
        wellKnownPropsMapN3.put(OWL.sameAs.getURI(), "=");
        wellKnownPropsMapN3.put(RDF.type.getURI(), "a");
        wellKnownPropsMapTurtle = new HashMap<String, String>();
        wellKnownPropsMapTurtle.put(RDF.type.getURI(), "a");
    }
}

