/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.RuleSetAssembler;
import com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import com.hp.hpl.jena.assembler.exceptions.CannotHaveRulesException;
import com.hp.hpl.jena.assembler.exceptions.NotExpectedTypeException;
import com.hp.hpl.jena.assembler.exceptions.UnknownReasonerException;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import java.util.ArrayList;
import java.util.List;

public class ReasonerFactoryAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.ReasonerFactory);
        return this.addSchema(root, a, this.addRules(root, a, ReasonerFactoryAssembler.getReasonerFactory(root)));
    }

    private ReasonerFactory addSchema(Resource root, Assembler a, final ReasonerFactory rf) {
        if (root.hasProperty(JA.ja_schema)) {
            final Graph schema = this.loadSchema(root, a);
            return new ReasonerFactory(){

                @Override
                public Reasoner create(Resource configuration) {
                    return rf.create(configuration).bindSchema(schema);
                }

                @Override
                public Model getCapabilities() {
                    return rf.getCapabilities();
                }

                @Override
                public String getURI() {
                    return rf.getURI();
                }
            };
        }
        return rf;
    }

    private Graph loadSchema(Resource root, Assembler a) {
        Graph result = Factory.createDefaultGraph();
        StmtIterator models = root.listProperties(JA.ja_schema);
        while (models.hasNext()) {
            this.loadSchema(result, a, ReasonerFactoryAssembler.getResource(models.nextStatement()));
        }
        return result;
    }

    private void loadSchema(Graph result, Assembler a, Resource root) {
        Model m = a.openModel(root);
        result.getBulkUpdateHandler().add(m.getGraph());
    }

    private ReasonerFactory addRules(Resource root, Assembler a, final ReasonerFactory r) {
        final List<Rule> rules = RuleSetAssembler.addRules(new ArrayList<Rule>(), a, root);
        if (rules.size() > 0) {
            if (r instanceof GenericRuleReasonerFactory) {
                return new ReasonerFactory(){

                    @Override
                    public Reasoner create(Resource configuration) {
                        GenericRuleReasoner result = (GenericRuleReasoner)r.create(configuration);
                        result.addRules(rules);
                        return result;
                    }

                    @Override
                    public Model getCapabilities() {
                        return r.getCapabilities();
                    }

                    @Override
                    public String getURI() {
                        return r.getURI();
                    }
                };
            }
            throw new CannotHaveRulesException(root);
        }
        return r;
    }

    protected Reasoner getReasoner(Resource root) {
        return ReasonerFactoryAssembler.getReasonerFactory(root).create(root);
    }

    protected static ReasonerFactory getReasonerFactory(Resource root) {
        Resource reasonerURL = ReasonerFactoryAssembler.getUniqueResource(root, JA.reasonerURL);
        String className = ReasonerFactoryAssembler.getOptionalClassName(root);
        return className != null ? ReasonerFactoryAssembler.getReasonerFactoryByClassName(root, className) : (reasonerURL == null ? GenericRuleReasonerFactory.theInstance() : ReasonerFactoryAssembler.getReasonerFactoryByURL(root, reasonerURL));
    }

    private static ReasonerFactory getReasonerFactoryByClassName(Resource root, String className) {
        Class<?> c = ReasonerFactoryAssembler.loadClass(root, className);
        ReasonerFactoryAssembler.mustBeReasonerFactory(root, c);
        ReasonerFactory theInstance = ReasonerFactoryAssembler.resultFromStatic(c, "theInstance");
        return theInstance == null ? ReasonerFactoryAssembler.createInstance(root, c) : theInstance;
    }

    private static ReasonerFactory createInstance(Resource root, Class<?> c) {
        try {
            return (ReasonerFactory)c.newInstance();
        }
        catch (Exception e2) {
            throw new AssemblerException(root, "could not create instance of " + c.getName(), e2);
        }
    }

    private static ReasonerFactory resultFromStatic(Class<?> c, String methodName) {
        try {
            return (ReasonerFactory)c.getMethod(methodName, null).invoke(null, (Object[])null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static void mustBeReasonerFactory(Resource root, Class<?> c) {
        if (!ReasonerFactory.class.isAssignableFrom(c)) {
            throw new NotExpectedTypeException(root, ReasonerFactory.class, c);
        }
    }

    private static String getOptionalClassName(Resource root) {
        return ReasonerFactoryAssembler.getOptionalClassName(root, JA.reasonerClass);
    }

    public static ReasonerFactory getReasonerFactoryByURL(Resource root, Resource reasonerURL) {
        String url = reasonerURL.getURI();
        ReasonerFactory factory = ReasonerRegistry.theRegistry().getFactory(url);
        if (factory == null) {
            throw new UnknownReasonerException(root, reasonerURL);
        }
        return factory;
    }
}

