/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.ImportManager;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.ModelExpansion;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.assembler.exceptions.AmbiguousSpecificTypeException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.BadDescriptionMultipleRootsException;
import com.hp.hpl.jena.shared.BadDescriptionNoRootException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AssemblerHelp {
    protected static final Property ANY = null;

    public static Resource withFullModel(Resource root) {
        return root.inModel(AssemblerHelp.fullModel(root.getModel()));
    }

    public static Model fullModel(Model m) {
        return AssemblerHelp.fullModel(ImportManager.instance, m);
    }

    public static Model fullModel(ImportManager im, Model m) {
        return m.contains(JA.This, RDF.type, JA.Expanded) ? m : (Model)ModelExpansion.withSchema(im.withImports(m), JA.getSchema()).add(JA.This, RDF.type, JA.Expanded).setNsPrefixes(PrefixMapping.Extended).setNsPrefixes(m);
    }

    public static void loadArbitraryClasses(AssemblerGroup g, Model m) {
        StmtIterator it = m.listStatements(null, JA.loadClass, ANY);
        while (it.hasNext()) {
            AssemblerHelp.loadArbitraryClass(g, it.nextStatement());
        }
    }

    public static void loadAssemblerClasses(AssemblerGroup group, Model m) {
        StmtIterator it = m.listStatements((Resource)ANY, JA.assembler, ANY);
        while (it.hasNext()) {
            AssemblerHelp.loadAssemblerClass(group, it.nextStatement());
        }
    }

    private static void loadAssemblerClass(AssemblerGroup group, Statement s) {
        Class<?> c = AssemblerHelp.loadArbitraryClass(group, s);
        AssemblerHelp.runAnyAssemblerConstructor(group, s, c);
    }

    private static Class<?> loadArbitraryClass(AssemblerGroup ag, Statement s) {
        Class<?> loaded = AssemblerHelp.loadClassNamedBy(s);
        try {
            Method m = loaded.getDeclaredMethod("whenRequiredByAssembler", AssemblerGroup.class);
            m.invoke(null, ag);
        }
        catch (NoSuchMethodException e2) {
        }
        catch (Exception e3) {
            throw new JenaException(e3);
        }
        return loaded;
    }

    private static Class<?> loadClassNamedBy(Statement s) {
        try {
            return Class.forName(AssemblerHelp.getString(s));
        }
        catch (Exception e2) {
            throw new JenaException(e2);
        }
    }

    private static void runAnyAssemblerConstructor(AssemblerGroup group, Statement s, Class<?> c) {
        try {
            Resource type = s.getSubject();
            Constructor<?> con = AssemblerHelp.getResourcedConstructor(c);
            if (con == null) {
                AssemblerHelp.establish(group, type, c.newInstance());
            } else {
                AssemblerHelp.establish(group, type, con.newInstance(s.getSubject()));
            }
        }
        catch (Exception e2) {
            throw new JenaException(e2);
        }
    }

    private static void establish(AssemblerGroup group, Resource type, Object x) {
        if (!(x instanceof Assembler)) {
            throw new JenaException("constructed entity is not an Assembler: " + x);
        }
        group.implementWith(type, (Assembler)x);
    }

    private static Constructor<?> getResourcedConstructor(Class<?> c) {
        try {
            return c.getConstructor(Resource.class);
        }
        catch (SecurityException e2) {
            return null;
        }
        catch (NoSuchMethodException e3) {
            return null;
        }
    }

    public static Resource findSpecificType(Resource root) {
        return AssemblerHelp.findSpecificType(root, JA.Object);
    }

    public static Resource findSpecificType(Resource root, Resource baseType) {
        Set<Resource> types = AssemblerHelp.findSpecificTypes(root, baseType);
        if (types.size() == 1) {
            return types.iterator().next();
        }
        if (types.size() == 0) {
            return baseType;
        }
        throw new AmbiguousSpecificTypeException(root, new ArrayList<Resource>(types));
    }

    public static Set<Resource> findSpecificTypes(Resource root, Resource baseType) {
        List<RDFNode> types = root.listProperties(RDF.type).mapWith(Statement.Util.getObject).toList();
        HashSet<Resource> results = new HashSet<Resource>();
        for (int i = 0; i < types.size(); ++i) {
            Resource candidate = (Resource)types.get(i);
            if (!candidate.hasProperty(RDFS.subClassOf, baseType) || !AssemblerHelp.hasNoCompetingSubclass(types, candidate)) continue;
            results.add(candidate);
        }
        return results;
    }

    private static boolean hasNoCompetingSubclass(List<RDFNode> types, Resource candidate) {
        for (int j = 0; j < types.size(); ++j) {
            Resource other = (Resource)types.get(j);
            if (!other.hasProperty(RDFS.subClassOf, candidate) || ((Object)candidate).equals(other)) continue;
            return false;
        }
        return true;
    }

    public static Resource getResource(Statement s) {
        RDFNode ob = s.getObject();
        if (ob.isLiteral()) {
            throw new BadObjectException(s);
        }
        return (Resource)ob;
    }

    public static String getString(Statement s) {
        RDFNode ob = s.getObject();
        if (ob.isResource()) {
            throw new BadObjectException(s);
        }
        Literal L = (Literal)ob;
        if (!L.getLanguage().equals("")) {
            throw new BadObjectException(s);
        }
        if (L.getDatatype() == null) {
            return L.getLexicalForm();
        }
        if (L.getDatatype() == XSDDatatype.XSDstring) {
            return L.getLexicalForm();
        }
        throw new BadObjectException(s);
    }

    public static String getString(Statement s, Literal L) {
        if (!L.getLanguage().equals("")) {
            throw new BadObjectException(s);
        }
        if (L.getDatatype() == null) {
            return L.getLexicalForm();
        }
        if (L.getDatatype() == XSDDatatype.XSDstring) {
            return L.getLexicalForm();
        }
        throw new BadObjectException(s);
    }

    public static Set<Resource> findAssemblerRoots(Model model) {
        return AssemblerHelp.findAssemblerRoots(model, JA.Object);
    }

    public static Set<Resource> findAssemblerRoots(Model model, Resource type) {
        return AssemblerHelp.fullModel(model).listResourcesWithProperty(RDF.type, type).toSet();
    }

    public static Resource singleModelRoot(Model singleRoot) {
        return AssemblerHelp.singleRoot(singleRoot, JA.Model);
    }

    public static Resource singleRoot(Model singleRoot, Resource type) {
        Set<Resource> roots = AssemblerHelp.findAssemblerRoots(singleRoot, type);
        if (roots.size() == 1) {
            return roots.iterator().next();
        }
        if (roots.size() == 0) {
            throw new BadDescriptionNoRootException(singleRoot, type);
        }
        throw new BadDescriptionMultipleRootsException(singleRoot, type);
    }
}

