/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import java.io.File;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryException;

public class AGVirtualRepository
implements AGAbstractRepository,
Closeable {
    private final AGServer server;
    final AGRepository wrapped;
    private final String spec;
    private final AGValueFactory vf;

    public AGVirtualRepository(AGServer server, String spec, AGRepository wrapped) {
        this.server = server;
        this.spec = spec;
        this.wrapped = wrapped;
        this.vf = new AGValueFactory(wrapped);
    }

    public AGServer getServer() {
        return this.server;
    }

    @Override
    public AGCatalog getCatalog() {
        return null;
    }

    @Override
    public String getSpec() {
        return this.spec;
    }

    @Override
    public boolean isWritable() {
        return this.wrapped != null;
    }

    @Override
    public AGValueFactory getValueFactory() {
        return this.vf;
    }

    @Override
    public AGRepositoryConnection getConnection() throws RepositoryException {
        AGHttpRepoClient repoclient;
        AGHTTPClient client = this.server.getHTTPClient();
        try {
            repoclient = new AGHttpRepoClient(this, client, null, client.openSession(this.spec, true));
        }
        catch (AGHttpException e2) {
            throw new RepositoryException(e2);
        }
        return new AGRepositoryConnection(this, repoclient);
    }

    @Override
    public void close() throws RepositoryException {
        this.shutDown();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void shutDown() throws RepositoryException {
    }

    @Override
    public void setDataDir(File dataDir) {
        throw new UnsupportedOperationException("setDataDir is inapplicable for AG repositories");
    }

    @Override
    public File getDataDir() {
        throw new UnsupportedOperationException("getDataDir is inapplicable for AG repositories");
    }

    public static String federatedSpec(String[] repoSpecs) {
        String spec = "";
        for (int i = 0; i < repoSpecs.length; ++i) {
            if (spec.length() > 0) {
                spec = spec + " + ";
            }
            spec = spec + repoSpecs[i];
        }
        return spec;
    }

    public static String reasoningSpec(String repoSpec, String reasoner) {
        return AGVirtualRepository.reasoningSpec(repoSpec, reasoner, null);
    }

    public static String reasoningSpec(String repoSpec, String reasoner, Resource inferredGraph) {
        String reasoningSpec = repoSpec + "[" + reasoner;
        if (null != inferredGraph && !inferredGraph.equals("")) {
            reasoningSpec = reasoningSpec + "#<" + inferredGraph.stringValue() + ">";
        }
        return reasoningSpec + "]";
    }

    public static String filteredSpec(AGAbstractRepository repo, Resource[] contexts) {
        String[] graphs = new String[contexts.length];
        for (int i = 0; i < contexts.length; ++i) {
            graphs[i] = null == contexts[i] ? null : "<" + contexts[i].stringValue() + ">";
        }
        return AGVirtualRepository.filteredSpec(repo.getSpec(), graphs);
    }

    public static String filteredSpec(String repoSpec, String[] graphs) {
        repoSpec = repoSpec + "{";
        for (String graph : graphs) {
            repoSpec = repoSpec + " " + graph;
        }
        return repoSpec + "}";
    }
}

