/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.pool;

import com.franz.agraph.pool.AGConnConfig;
import com.franz.agraph.pool.AGConnFactory;
import com.franz.agraph.pool.AGConnProp;
import com.franz.agraph.pool.AGPoolConfig;
import com.franz.agraph.pool.AGPoolProp;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.util.Closeable;
import com.franz.util.Closer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGConnPool
extends Closer
implements ObjectPool,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(AGConnPool.class);
    private final ObjectPool delegate;
    private final AGConnFactory factory;

    private AGConnPool(AGConnFactory factory, AGPoolConfig poolConfig) {
        this.delegate = new GenericObjectPool((PoolableObjectFactory)new ClosingFactory(factory), (GenericObjectPool.Config)poolConfig);
        this.closeLater(this.delegate);
        this.factory = factory;
        if (poolConfig.initialSize > 0) {
            ArrayList<AGRepositoryConnection> conns = new ArrayList<AGRepositoryConnection>(poolConfig.initialSize);
            try {
                for (int i = 0; i < poolConfig.initialSize; ++i) {
                    conns.add(this.borrowConnection());
                }
            }
            catch (RepositoryException e2) {
                throw new RuntimeException(e2);
            }
            this.closeAll(conns);
        }
        if (poolConfig.shutdownHook) {
            Runtime.getRuntime().addShutdownHook(this.closeLater(new ShutdownHookCloser(this)));
        }
    }

    public static AGConnPool create(AGConnFactory factory, AGPoolConfig poolConfig) {
        return new AGConnPool(factory, poolConfig);
    }

    public static AGConnPool create(Map<AGConnProp, String> connProps, Map<AGPoolProp, String> poolProps) throws RepositoryException {
        AGConnFactory fact = new AGConnFactory(new AGConnConfig(connProps));
        AGConnPool pool = AGConnPool.create(fact, new AGPoolConfig(poolProps));
        pool.closeLater(fact);
        return pool;
    }

    public static AGConnPool create(Object ... keyValuePairs) throws RepositoryException {
        Map<? extends Enum, String> connProps = AGConnPool.toMap(keyValuePairs, EnumSet.allOf(AGConnProp.class));
        Map<? extends Enum, String> poolProps = AGConnPool.toMap(keyValuePairs, EnumSet.allOf(AGPoolProp.class));
        return AGConnPool.create(connProps, poolProps);
    }

    protected static Map<? extends Enum, String> toMap(Object[] keyValuePairs, EnumSet<? extends Enum> enumSet) {
        HashMap<Enum, String> map = new HashMap<Enum, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            Enum key = (Enum)keyValuePairs[i];
            if (!enumSet.contains(key)) continue;
            Object val = keyValuePairs[i + 1];
            map.put(key, val == null ? null : val.toString());
        }
        return map;
    }

    public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
        this.delegate.addObject();
    }

    public Object borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
        return this.delegate.borrowObject();
    }

    public AGRepositoryConnection borrowConnection() throws RepositoryException {
        try {
            return (AGRepositoryConnection)this.delegate.borrowObject();
        }
        catch (Exception e2) {
            throw new RepositoryException(e2);
        }
    }

    public void clear() throws Exception, UnsupportedOperationException {
        this.delegate.clear();
    }

    public int getNumActive() throws UnsupportedOperationException {
        return this.delegate.getNumActive();
    }

    public int getNumIdle() throws UnsupportedOperationException {
        return this.delegate.getNumIdle();
    }

    public void invalidateObject(Object obj) throws Exception {
        this.delegate.invalidateObject(obj);
    }

    public void returnObject(Object obj) throws Exception {
        this.delegate.returnObject(obj);
    }

    public static Object unwrap(Object obj) {
        if (obj instanceof AGRepositoryConnectionPooled) {
            return ((AGRepositoryConnectionPooled)obj).conn;
        }
        return obj;
    }

    @Deprecated
    public void setFactory(PoolableObjectFactory obj) throws IllegalStateException, UnsupportedOperationException {
        this.delegate.setFactory(obj);
    }

    public void ensureIdle(int n) throws Exception {
        if (this.delegate instanceof GenericObjectPool) {
            GenericObjectPool gop = (GenericObjectPool)this.delegate;
            gop.setMinIdle(n);
            if (gop.getMaxIdle() < n) {
                gop.setMaxIdle(n);
            }
        }
        for (int i = 0; i < n; ++i) {
            this.addObject();
        }
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("close " + this);
        }
        this.close(this.delegate);
        super.close();
    }

    protected void finalize() throws Throwable {
        if (this.getNumActive() > 0) {
            this.close();
            log.warn("Finalizing with open connections, please close the pool properly. " + this);
        }
    }

    @Override
    public String toString() {
        return "{AGConnPool active=" + this.getNumActive() + " idle=" + this.getNumIdle() + " delegate=" + this.delegate + " factory=" + this.factory + " this=" + super.toString() + "}";
    }

    private static class ShutdownHookCloser
    extends Thread
    implements Closeable {
        private static final Logger log = LoggerFactory.getLogger(ShutdownHookCloser.class);
        private final Closer closer;

        public ShutdownHookCloser(Closer closer) {
            this.closer = closer;
        }

        @Override
        public void run() {
            log.info("closing " + this.closer);
            this.closer.remove(this);
            Closer.Close(this.closer);
            log.debug("closed " + this.closer);
        }

        @Override
        public void close() {
            Runtime.getRuntime().removeShutdownHook(this);
        }
    }

    class ClosingFactory
    implements PoolableObjectFactory {
        private final PoolableObjectFactory delegate;

        ClosingFactory(PoolableObjectFactory delegate) {
            this.delegate = delegate;
        }

        public void activateObject(Object object) throws Exception {
            this.delegate.activateObject(AGConnPool.unwrap(object));
        }

        public void destroyObject(Object object) throws Exception {
            this.delegate.destroyObject(AGConnPool.unwrap(object));
        }

        public Object makeObject() throws Exception {
            return new AGRepositoryConnectionPooled((AGRepositoryConnection)this.delegate.makeObject());
        }

        public void passivateObject(Object object) throws Exception {
            this.delegate.passivateObject(AGConnPool.unwrap(object));
        }

        public boolean validateObject(Object object) {
            return this.delegate.validateObject(AGConnPool.unwrap(object));
        }
    }

    class AGRepositoryConnectionPooled
    extends AGRepositoryConnection {
        final AGRepositoryConnection conn;

        public AGRepositoryConnectionPooled(AGRepositoryConnection conn) {
            super((AGRepository)conn.getRepository(), conn.getHttpRepoClient());
            this.conn = conn;
        }

        @Override
        public void close() throws RepositoryException {
            try {
                AGConnPool.this.returnObject(this);
            }
            catch (Exception e2) {
                throw new RepositoryException(e2);
            }
        }
    }
}

