/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.pool;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.pool.AGConnConfig;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.util.Closeable;
import com.franz.util.Closer;
import java.net.ConnectException;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.pool.PoolableObjectFactory;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGConnFactory
extends Closer
implements PoolableObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(AGConnFactory.class);
    private final AGConnConfig props;

    public AGConnFactory(AGConnConfig props) throws RepositoryException {
        this.props = props;
    }

    public Object makeObject() throws Exception {
        return this.makeConnection();
    }

    protected AGRepositoryConnection makeConnection() throws Exception {
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setDefaultMaxConnectionsPerHost(Integer.MAX_VALUE);
        params.setMaxTotalConnections(Integer.MAX_VALUE);
        if (this.props.httpSocketTimeout != null) {
            params.setSoTimeout(this.props.httpSocketTimeout);
        }
        HttpConnectionManager manager = this.closeLater(new MultiThreadedHttpConnectionManager());
        manager.setParams(params);
        AGHTTPClient httpClient = new AGHTTPClient(this.props.serverUrl, manager);
        AGServer server = this.closeLater(new AGServer(this.props.username, this.props.password, httpClient));
        AGCatalog cat = this.props.catalog != null ? server.getCatalog(this.props.catalog) : server.getRootCatalog();
        AGRepository repo = !cat.hasRepository(this.props.repository) ? this.closeLater(this.createRepo(cat)) : this.closeLater(new AGRepository(cat, this.props.repository));
        repo.initialize();
        AGRepositoryConnection conn = this.closeLater(new AGRepositoryConnectionCloseup(this, this.closeLater(repo.getConnection())));
        if (this.props.sessionLifetime != null) {
            conn.setSessionLifetime(this.props.sessionLifetime);
        }
        this.activateObject(conn);
        return conn;
    }

    private synchronized AGRepository createRepo(AGCatalog cat) throws Exception {
        if (!cat.hasRepository(this.props.repository)) {
            return cat.createRepository(this.props.repository, true);
        }
        return new AGRepository(cat, this.props.repository);
    }

    protected void activateConnection(AGRepositoryConnection conn) throws RepositoryException {
        conn.rollback();
        switch (this.props.session) {
            case SHARED: {
                if (conn.isAutoCommit()) break;
                conn.setAutoCommit(true);
                if (!log.isDebugEnabled()) break;
                log.debug("Dedicated (not shared) backend: " + conn.getHttpRepoClient().getRoot());
                break;
            }
            case DEDICATED: {
                if (!conn.getHttpRepoClient().getRoot().contains(this.props.serverUrl) && conn.isAutoCommit()) break;
                conn.setAutoCommit(true);
                if (!log.isDebugEnabled()) break;
                log.debug("Dedicated backend: " + conn.getHttpRepoClient().getRoot());
                break;
            }
            case TX: {
                if (!conn.isAutoCommit()) break;
                conn.setAutoCommit(false);
                if (!log.isDebugEnabled()) break;
                log.debug("TX dedicated backend: " + conn.getHttpRepoClient().getRoot());
            }
        }
    }

    public void activateObject(Object obj) throws Exception {
        this.activateConnection((AGRepositoryConnection)obj);
    }

    public void destroyObject(Object obj) throws Exception {
        this.close(obj);
    }

    public void passivateObject(Object obj) throws Exception {
        AGRepositoryConnection conn = (AGRepositoryConnection)obj;
        if (!conn.isAutoCommit() && conn.getRepository().isWritable()) {
            conn.rollback();
        }
    }

    public boolean validateObject(Object obj) {
        AGRepositoryConnection conn = (AGRepositoryConnection)obj;
        try {
            conn.size(new Resource[0]);
            return true;
        }
        catch (Exception e2) {
            log.debug("validateObject " + obj, e2);
            return false;
        }
    }

    @Override
    public <Obj> Obj handleCloseException(Obj o, Throwable e2) {
        if (e2.getCause() instanceof ConnectException && e2.getCause().getMessage().equals("Connection refused")) {
            log.debug("ignoring error with close (probably session timeout): " + o, e2);
        } else {
            log.warn("ignoring error with close: " + o, e2);
        }
        return o;
    }

    class AGRepositoryConnectionCloseup
    extends AGRepositoryConnection {
        private final AGRepositoryConnection conn;
        private final Closer closer;

        public AGRepositoryConnectionCloseup(Closer closer, AGRepositoryConnection conn) {
            super((AGRepository)conn.getRepository(), conn.getHttpRepoClient());
            this.closer = closer;
            this.conn = conn;
        }

        @Override
        public void close() throws RepositoryException {
            this.closer.close(new Closeable(){

                @Override
                public void close() throws Exception {
                    AGRepositoryConnectionCloseup.super.close();
                }
            });
            this.closer.close(this.conn);
            this.closer.close(this.conn.getRepository());
            this.closer.close(this.conn.getRepository().getCatalog().getServer());
        }
    }
}

