/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGNodeFactory;
import com.franz.util.Closeable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import org.openrdf.model.Statement;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class AGTripleIterator
extends NiceIterator<Triple>
implements Closeable {
    private final AGGraph graph;
    private final RepositoryResult<Statement> result;
    private Statement current = null;

    AGTripleIterator(AGGraph graph, RepositoryResult<Statement> result) {
        this.graph = graph;
        this.result = result;
    }

    @Override
    public void close() {
        try {
            this.result.close();
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.result.hasNext();
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Triple next() {
        Triple tr;
        try {
            this.current = this.result.next();
            tr = AGNodeFactory.asTriple(this.current);
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
        return tr;
    }

    @Override
    public void remove() {
        if (this.current != null) {
            Triple tr = AGNodeFactory.asTriple(this.current);
            this.graph.delete(tr);
            this.current = null;
        }
    }
}

