/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGNodeFactory;
import com.franz.agraph.jena.AGNodeIterator;
import com.franz.agraph.jena.AGTripleIteratorGQ;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGValueFactory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import org.openrdf.model.Statement;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;

public class AGReifier
implements Reifier {
    private AGGraph graph;

    AGReifier(AGGraph graph) {
        this.graph = graph;
    }

    @Override
    public Triple getTriple(Node n) {
        String queryString = "construct {?s ?p ?o} where { ?st rdf:subject ?s . ?st rdf:predicate ?p . ?st rdf:object ?o . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGGraphQuery bq = conn.prepareGraphQuery(QueryLanguage.SPARQL, queryString);
        try {
            bq.setBinding("st", vf.asValue(n));
            bq.setDataset(this.graph.getDataset());
            GraphQueryResult result = bq.evaluate();
            if (result.hasNext()) {
                Triple t = AGNodeFactory.asTriple((Statement)result.next());
                if (result.hasNext()) {
                    return null;
                }
                return t;
            }
            return null;
        }
        catch (QueryEvaluationException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m) {
        return this.graph.graphBaseFind(m);
    }

    @Override
    public ExtendedIterator<Triple> findExposed(TripleMatch m) {
        if (this.matchesReification(m)) {
            if (m.getMatchPredicate() != null) {
                return this.graph.graphBaseFind(m);
            }
            String queryString = "construct {?s ?p ?o} where { {?s ?p ?o . FILTER (?p = rdf:subject || ?p = rdf:predicate || ?p = rdf:object)} UNION {?s ?p ?o . FILTER (?p = rdf:type && ?o = rdf:Statement)} }";
            AGRepositoryConnection conn = this.graph.getConnection();
            AGValueFactory vf = conn.getValueFactory();
            AGGraphQuery gq = conn.prepareGraphQuery(QueryLanguage.SPARQL, queryString);
            try {
                if (m.getMatchSubject() != null) {
                    gq.setBinding("s", vf.asValue(m.getMatchSubject()));
                }
                if (m.getMatchObject() != null) {
                    gq.setBinding("o", vf.asValue(m.getMatchObject()));
                }
                gq.setDataset(this.graph.getDataset());
                GraphQueryResult result = gq.evaluate();
                return new AGTripleIteratorGQ(this.graph, result);
            }
            catch (QueryEvaluationException e2) {
                throw new RuntimeException(e2);
            }
        }
        return Triple.None;
    }

    @Override
    public ExtendedIterator<Triple> findEither(TripleMatch m, boolean showHidden) {
        return showHidden ? Triple.None : this.find(m);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public ReificationStyle getStyle() {
        return ReificationStyle.Standard;
    }

    @Override
    public Graph getParentGraph() {
        return this.graph;
    }

    @Override
    public Node reifyAs(Node n, Triple t) {
        Triple tn = this.getTriple(n);
        if (tn != null && !tn.equals(t)) {
            throw new AlreadyReifiedException(n);
        }
        if (tn == null) {
            String queryString = "select ?v { ?st ?p ?v . FILTER (?v != ?tv) }";
            AGRepositoryConnection conn = this.graph.getConnection();
            AGTupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
            try {
                q.setDataset(this.graph.getDataset());
                q.setBinding("st", this.graph.vf.asValue(n));
                q.setBinding("p", this.graph.vf.asValue(RDF.Nodes.subject));
                q.setBinding("tv", this.graph.vf.asValue(t.getSubject()));
                TupleQueryResult result = q.evaluate();
                if (result.hasNext()) {
                    throw new CannotReifyException(n);
                }
                q.setBinding("p", this.graph.vf.asValue(RDF.Nodes.predicate));
                q.setBinding("tv", this.graph.vf.asValue(t.getPredicate()));
                result = q.evaluate();
                if (result.hasNext()) {
                    throw new CannotReifyException(n);
                }
                q.setBinding("p", this.graph.vf.asValue(RDF.Nodes.object));
                q.setBinding("tv", this.graph.vf.asValue(t.getObject()));
                result = q.evaluate();
                if (result.hasNext()) {
                    throw new CannotReifyException(n);
                }
            }
            catch (QueryEvaluationException e2) {
                throw new RuntimeException(e2);
            }
            this.graph.add(Triple.create(n, RDF.Nodes.subject, t.getSubject()));
            this.graph.add(Triple.create(n, RDF.Nodes.predicate, t.getPredicate()));
            this.graph.add(Triple.create(n, RDF.Nodes.object, t.getObject()));
            this.graph.add(Triple.create(n, RDF.Nodes.type, RDF.Nodes.Statement));
        }
        return n;
    }

    @Override
    public boolean hasTriple(Node n) {
        boolean result;
        String queryString = "ask { ?st rdf:type rdf:Statement . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGBooleanQuery bq = conn.prepareBooleanQuery(QueryLanguage.SPARQL, queryString);
        try {
            bq.setBinding("st", vf.asValue(n));
            bq.setDataset(this.graph.getDataset());
            result = bq.evaluate();
        }
        catch (QueryEvaluationException e2) {
            throw new RuntimeException(e2);
        }
        return result;
    }

    @Override
    public boolean hasTriple(Triple t) {
        boolean result;
        String queryString = "ask { ?st rdf:subject ?s . ?st rdf:predicate ?p . ?st rdf:object ?o . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGBooleanQuery bq = conn.prepareBooleanQuery(QueryLanguage.SPARQL, queryString);
        try {
            bq.setBinding("s", vf.asValue(t.getSubject()));
            bq.setBinding("p", vf.asValue(t.getPredicate()));
            bq.setBinding("o", vf.asValue(t.getObject()));
            bq.setDataset(this.graph.getDataset());
            result = bq.evaluate();
        }
        catch (QueryEvaluationException e2) {
            throw new RuntimeException(e2);
        }
        return result;
    }

    @Override
    public ExtendedIterator<Node> allNodes() {
        String queryString = "select ?st where { ?st rdf:type rdf:Statement }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGTupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        try {
            q.setDataset(this.graph.getDataset());
            TupleQueryResult result = q.evaluate();
            return new AGNodeIterator(result);
        }
        catch (QueryEvaluationException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public ExtendedIterator<Node> allNodes(Triple t) {
        String queryString = "select ?st where { ?st rdf:type rdf:Statement . ?st rdf:subject ?s . ?st rdf:predicate ?p . ?st rdf:object ?o . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGTupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        try {
            q.setDataset(this.graph.getDataset());
            q.setBinding("s", vf.asValue(t.getSubject()));
            q.setBinding("p", vf.asValue(t.getPredicate()));
            q.setBinding("o", vf.asValue(t.getObject()));
            TupleQueryResult result = q.evaluate();
            return new AGNodeIterator(result);
        }
        catch (QueryEvaluationException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void remove(Node n, Triple t) {
        this.graph.delete(Triple.create(n, RDF.Nodes.subject, t.getSubject()));
        this.graph.delete(Triple.create(n, RDF.Nodes.predicate, t.getPredicate()));
        this.graph.delete(Triple.create(n, RDF.Nodes.object, t.getObject()));
        this.graph.delete(Triple.create(n, RDF.Nodes.type, RDF.Nodes.Statement));
    }

    @Override
    public void remove(Triple t) {
        String queryString = "select { ?st rdf:type rdf:Statement . ?st rdf:subject ?s . ?st rdf:predicate ?p . ?st rdf:object ?o . }";
        AGRepositoryConnection conn = this.graph.getConnection();
        AGValueFactory vf = conn.getValueFactory();
        AGTupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        try {
            q.setDataset(this.graph.getDataset());
            q.setBinding("s", vf.asValue(t.getSubject()));
            q.setBinding("p", vf.asValue(t.getPredicate()));
            q.setBinding("o", vf.asValue(t.getObject()));
            TupleQueryResult result = q.evaluate();
            while (result.hasNext()) {
                this.remove(AGNodeFactory.asNode(((BindingSet)result.next()).getValue("st")), t);
            }
        }
        catch (QueryEvaluationException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public boolean handledAdd(Triple t) {
        return false;
    }

    @Override
    public boolean handledRemove(Triple t) {
        return false;
    }

    @Override
    public void close() {
    }

    private boolean matchesReification(TripleMatch m) {
        Node predicate = m.asTriple().getPredicate();
        return !predicate.isConcrete() || predicate.equals(RDF.Nodes.subject) || predicate.equals(RDF.Nodes.predicate) || predicate.equals(RDF.Nodes.object) || predicate.equals(RDF.Nodes.type) && this.matchesStatement(m.asTriple().getObject());
    }

    private boolean matchesStatement(Node x) {
        return !x.isConcrete() || x.equals(RDF.Nodes.Statement);
    }
}

