/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGInfGraph;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGNodeFactory;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGResultSet;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.util.Closeable;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.util.Iterator;
import org.openrdf.model.Statement;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;

public class AGQueryExecution
implements QueryExecution,
Closeable {
    private final AGQuery query;
    private final AGModel model;
    private QuerySolution binding;

    public AGQueryExecution(AGQuery query2, AGModel model) {
        this.query = query2;
        this.model = model;
    }

    @Override
    public void abort() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public void close() {
    }

    @Override
    public boolean execAsk() {
        boolean result;
        if (this.query.getLanguage() != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(this.query.getLanguage().getName() + " language does not support ASK queries.");
        }
        AGBooleanQuery bq = this.model.getGraph().getConnection().prepareBooleanQuery(this.query.getLanguage(), this.query.getQueryString());
        bq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        bq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        bq.setCheckVariables(this.query.isCheckVariables());
        if (this.binding != null) {
            Iterator<String> vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = vars.next();
                bq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            bq.setDataset(this.model.getGraph().getDataset());
            result = bq.evaluate();
        }
        catch (QueryEvaluationException e2) {
            throw new QueryException(e2);
        }
        return result;
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(null);
    }

    @Override
    public Model execConstruct(Model m) {
        GraphQueryResult result;
        if (this.query.getLanguage() != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(this.query.getLanguage().getName() + " language does not support CONSTRUCT queries.");
        }
        AGGraphQuery gq = this.model.getGraph().getConnection().prepareGraphQuery(this.query.getLanguage(), this.query.getQueryString());
        gq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        gq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        gq.setCheckVariables(this.query.isCheckVariables());
        gq.setLimit(this.query.getLimit());
        gq.setOffset(this.query.getOffset());
        if (this.binding != null) {
            Iterator<String> vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = vars.next();
                gq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            gq.setDataset(this.model.getGraph().getDataset());
            result = gq.evaluate();
        }
        catch (QueryEvaluationException e2) {
            throw new QueryException(e2);
        }
        if (m == null) {
            m = ModelFactory.createDefaultModel();
        }
        try {
            m.setNsPrefixes(result.getNamespaces());
            while (result.hasNext()) {
                m.add(this.model.asStatement(AGNodeFactory.asTriple((Statement)result.next())));
            }
        }
        catch (QueryEvaluationException e3) {
            throw new QueryException(e3);
        }
        return m;
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(null);
    }

    @Override
    public Model execDescribe(Model m) {
        return this.execConstruct(m);
    }

    @Override
    public ResultSet execSelect() {
        TupleQueryResult result;
        AGTupleQuery tq = this.model.getGraph().getConnection().prepareTupleQuery(this.query.getLanguage(), this.query.getQueryString());
        tq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        tq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        tq.setCheckVariables(this.query.isCheckVariables());
        tq.setLimit(this.query.getLimit());
        tq.setOffset(this.query.getOffset());
        if (this.binding != null) {
            Iterator<String> vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = vars.next();
                tq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            tq.setDataset(this.model.getGraph().getDataset());
            result = tq.evaluate();
        }
        catch (QueryEvaluationException e2) {
            throw new QueryException(e2);
        }
        return new AGResultSet(result, this.model);
    }

    public long countSelect() {
        long count;
        AGTupleQuery tq = this.model.getGraph().getConnection().prepareTupleQuery(this.query.getLanguage(), this.query.getQueryString());
        tq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        tq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        tq.setCheckVariables(this.query.isCheckVariables());
        tq.setLimit(this.query.getLimit());
        tq.setOffset(this.query.getOffset());
        tq.setDataset(this.model.getGraph().getDataset());
        if (this.binding != null) {
            Iterator<String> vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = vars.next();
                tq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            count = tq.count();
        }
        catch (QueryEvaluationException e2) {
            throw new QueryException(e2);
        }
        return count;
    }

    public long countConstruct() {
        long count;
        if (this.query.getLanguage() != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(this.query.getLanguage().getName() + " language does not support CONSTRUCT queries.");
        }
        AGGraphQuery gq = this.model.getGraph().getConnection().prepareGraphQuery(this.query.getLanguage(), this.query.getQueryString());
        gq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        gq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        gq.setCheckVariables(this.query.isCheckVariables());
        gq.setLimit(this.query.getLimit());
        gq.setOffset(this.query.getOffset());
        gq.setDataset(this.model.getGraph().getDataset());
        if (this.binding != null) {
            Iterator<String> vars = this.binding.varNames();
            while (vars.hasNext()) {
                String var = vars.next();
                gq.setBinding(var, this.model.getGraph().vf.asValue(this.binding.get(var).asNode()));
            }
        }
        try {
            count = gq.count();
        }
        catch (QueryEvaluationException e2) {
            throw new QueryException(e2);
        }
        return count;
    }

    @Override
    public Context getContext() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public Dataset getDataset() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public void setFileManager(FileManager fm) {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public void setInitialBinding(QuerySolution binding) {
        binding = this.binding;
    }
}

