/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.AnonId;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class AGNodeFactory {
    public static Triple asTriple(Statement st) {
        Node s = AGNodeFactory.asNode(st.getSubject());
        Node p = AGNodeFactory.asNode(st.getPredicate());
        Node o = AGNodeFactory.asNode(st.getObject());
        return new Triple(s, p, o);
    }

    public static Node asNode(Value v) {
        Node node = null;
        if (v == null) {
            node = Node.ANY;
        } else if (v instanceof URI) {
            node = Node.createURI(v.stringValue());
        } else if (v instanceof BNode) {
            node = Node.createAnon(new AnonId(v.stringValue()));
        } else if (v instanceof Literal) {
            Literal lit = (Literal)v;
            URI datatype = lit.getDatatype();
            String lang = lit.getLanguage();
            node = lang != null ? Node.createLiteral(lit.getLabel(), lang, null) : (datatype != null ? Node.createLiteral(lit.getLabel(), null, Node.getType(((Object)datatype).toString())) : Node.createLiteral(lit.stringValue()));
        } else {
            throw new IllegalArgumentException("Cannot create Node from Value: " + v);
        }
        return node;
    }
}

