/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGStatement;
import com.franz.agraph.repository.AGRDFFormat;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import java.io.IOException;
import java.io.InputStream;
import org.openrdf.model.BNode;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class AGModel
extends ModelCom
implements Model,
Closeable {
    public AGModel(AGGraph base) {
        super(base);
    }

    @Override
    public AGGraph getGraph() {
        return (AGGraph)this.graph;
    }

    @Override
    public AGModel read(InputStream reader, String base) {
        return this.read(reader, base, "RDF/XML");
    }

    @Override
    public AGModel read(InputStream reader, String base, String lang) {
        RDFFormat format;
        if (lang.contains("TRIPLE")) {
            format = RDFFormat.NTRIPLES;
        } else if (lang.contains("RDF")) {
            format = RDFFormat.RDFXML;
        } else if (lang.contains("TURTLE")) {
            format = RDFFormat.TURTLE;
        } else if (lang.contains("QUADS")) {
            format = AGRDFFormat.NQUADS;
        } else {
            throw new IllegalArgumentException("Unsupported format: " + lang + " (expected RDF/XML, N-TRIPLE, TURTLE, or NQUADS).");
        }
        try {
            this.getGraph().getConnection().add(reader, base, format, this.getGraph().getGraphContext());
        }
        catch (RDFParseException e2) {
            throw new RuntimeException(e2);
        }
        catch (RepositoryException e3) {
            throw new RuntimeException(e3);
        }
        catch (IOException e4) {
            throw new RuntimeException(e4);
        }
        return this;
    }

    @Override
    public Resource createResource() {
        AGValueFactory vf = this.getGraph().getConnection().getValueFactory();
        BNode blank = vf.createBNode();
        return this.createResource(new AnonId(blank.stringValue()));
    }

    @Override
    public Resource createResource(AnonId id) {
        return super.createResource(id);
    }

    @Override
    public AGModel add(Statement[] statements) {
        this.getBulkUpdateHandler().add(AGStatement.asTriples(statements));
        return this;
    }

    @Override
    public AGModel remove(Statement[] statements) {
        this.getBulkUpdateHandler().delete(AGStatement.asTriples(statements));
        return this;
    }

    @Override
    public AGStatement createStatement(Resource r, Property p, RDFNode o) {
        return new AGStatement(r, p, o, this);
    }

    @Override
    public Statement asStatement(Triple t) {
        return AGStatement.toStatement(t, this);
    }
}

