/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.repository.AGValueFactory;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.repository.RepositoryException;

public class AGBulkUpdateHandler
extends SimpleBulkUpdateHandler
implements BulkUpdateHandler {
    private final AGGraph graph;

    public AGBulkUpdateHandler(AGGraph graph) {
        super(graph);
        this.graph = graph;
    }

    @Override
    protected void add(List<Triple> triples, boolean notify) {
        AGValueFactory vf = this.graph.getConnection().getValueFactory();
        ArrayList<StatementImpl> statements = new ArrayList<StatementImpl>(triples.size());
        for (Triple tr : triples) {
            statements.add(new StatementImpl(vf.asResource(tr.getSubject()), vf.asURI(tr.getPredicate()), vf.asValue(tr.getObject())));
        }
        try {
            this.graph.getConnection().add(statements, this.graph.getGraphContext());
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
        if (notify) {
            this.manager.notifyAddList(this.graph, triples);
        }
    }

    @Override
    protected void delete(List<Triple> triples, boolean notify) {
        AGValueFactory vf = this.graph.getConnection().getValueFactory();
        ArrayList<StatementImpl> statements = new ArrayList<StatementImpl>(triples.size());
        for (Triple tr : triples) {
            statements.add(new StatementImpl(vf.asResource(tr.getSubject()), vf.asURI(tr.getPredicate()), vf.asValue(tr.getObject())));
        }
        try {
            this.graph.getConnection().remove(statements, this.graph.getGraphContext());
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
        if (notify) {
            this.manager.notifyDeleteList(this.graph, triples);
        }
    }

    @Override
    public void removeAll() {
        try {
            this.graph.getConnection().clear(this.graph.getGraphContexts());
            this.notifyRemoveAll();
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
    }
}

