/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.repository.AGValueFactory;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

public class AGRDFHandler
extends AGResponseHandler {
    private final RDFFormat format;
    private final RDFHandler rdfhandler;
    private final AGValueFactory vf;

    public AGRDFHandler(RDFFormat format, RDFHandler rdfhandler, AGValueFactory vf, boolean recoverExternalBNodes) {
        super(format.getDefaultMIMEType());
        this.format = format;
        this.rdfhandler = recoverExternalBNodes ? this.recoverBNodesRDFHandler(rdfhandler) : rdfhandler;
        this.vf = vf;
    }

    @Override
    public void handleResponse(HttpMethod method) throws IOException, AGHttpException {
        String mimeType = this.getResponseMIMEType(method);
        if (!mimeType.equals(this.getRequestMIMEType())) {
            throw new AGHttpException("unexpected response MIME type: " + mimeType);
        }
        InputStream response = AGRDFHandler.getInputStream(method);
        try {
            RDFParser parser = Rio.createParser(this.format, this.vf);
            parser.setPreserveBNodeIDs(true);
            parser.setRDFHandler(this.rdfhandler);
            parser.parse(response, method.getURI().getURI());
        }
        catch (RDFParseException e2) {
            throw new AGHttpException(e2);
        }
        catch (RDFHandlerException e3) {
            throw new AGHttpException(e3);
        }
    }

    private RDFHandler recoverBNodesRDFHandler(final RDFHandler handler) {
        return new RDFHandler(){

            @Override
            public void startRDF() throws RDFHandlerException {
                handler.startRDF();
            }

            @Override
            public void endRDF() throws RDFHandlerException {
                handler.endRDF();
            }

            @Override
            public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
                handler.handleNamespace(prefix, uri);
            }

            @Override
            public void handleStatement(Statement st) throws RDFHandlerException {
                Resource s = AGHttpRepoClient.getApplicationResource(st.getSubject(), AGRDFHandler.this.vf);
                Value o = AGHttpRepoClient.getApplicationValue(st.getObject(), AGRDFHandler.this.vf);
                Resource c = AGHttpRepoClient.getApplicationResource(st.getContext(), AGRDFHandler.this.vf);
                st = AGRDFHandler.this.vf.createStatement(s, st.getPredicate(), o, c);
                handler.handleStatement(st);
            }

            @Override
            public void handleComment(String comment) throws RDFHandlerException {
                handler.handleComment(comment);
            }
        };
    }
}

