package jp.ac.osaka_u.sanken.sparql.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableModel;

import com.hp.hpl.jena.rdf.model.RDFNode;

import jp.ac.osaka_u.sanken.sparql.SparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.EndpointSettingsManager;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class KeywordSearchPanel extends JPanel {

	private static final long serialVersionUID = 1L;
	private JPanel keywordPanel = null;
	private JLabel keywordLabel = null;
	private JTextField keywordTextField = null;
	private JList subjectList = null;
	private JScrollPane subjectScrollPane = null;
	private JPanel centerPanel = null;
	private JPanel footerPanel = null;
	private JScrollPane resultListScrollPane = null;  //  @jve:decl-index=0:visual-constraint="153,224"
	private JTable resultList = null;  //  @jve:decl-index=0:visual-constraint="369,21"
	private JButton runQueryButton = null;  //  @jve:decl-index=0:visual-constraint="390,64"
	private JSplitPane mainSplitPane = null;
	private JPanel optionPanel = null;
	private JPanel findTypePanel = null;
	private JRadioButton fullMatchRadioButton = null;
	private JRadioButton partMatchRadioButton = null;
	private JSeparator findSeparator = null;

	private boolean processing = false;
	private JPanel headerPanel = null;
	private JPanel limitPanel = null;
	private JCheckBox limitEnableCheckBox = null;
	private JLabel limitLabel = null;
	private JComboBox limitComboBox = null;
	private JRadioButton findSubjectRadioButton = null;
	private JRadioButton findObjectRadioButton = null;
	private JRadioButton findAllRadioButton = null;
	private JRadioButton findLabelObjectRadioButton = null;
	private Date fromDate;
	private JPanel movePanel = null;
	private JButton prevButton = null;
	private JButton nextButton = null;
	private JPanel limitMainPanel = null;
	private JButton limitPrevButton = null;
	private JButton limitNextButton = null;

	
	
	private SparqlAccessorForm parent;
	
	private DefaultListModel listModel;
	private DefaultTableModel tableModel;
	
	private SparqlAccessor sa;  //  @jve:decl-index=0:

	/* subjectジャンプヒストリ */
	private int historyIndex = 0;
	private List<String> history;  //  @jve:decl-index=0:
	private List<String> subjectHistoryList;

	/* limitヒストリ */
	private Integer limit = null;  //  @jve:decl-index=0:
	private int page = 0;
	private String word;
	private boolean fullMatch = false;
	private int type;
	private boolean hasLimitNext = false;
	
	
	/**
	 * This is the default constructor
	 */
	public KeywordSearchPanel(SparqlAccessorForm parent) {
		super();
		initialize();
		this.parent = parent;
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(300, 200);
		this.setLayout(new BorderLayout());
		this.add(getHeaderPanel(), BorderLayout.NORTH);
		this.add(getMainSplitPane(), BorderLayout.CENTER);
	}

	private JSplitPane getMainSplitPane(){
		if (mainSplitPane == null){
			mainSplitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, getCenterPanel(), getFooterPanel());
			mainSplitPane.setDividerLocation(200);
		}
		
		return mainSplitPane;
	}
	
	/**
	 * This method initializes keywordPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getKeywordPanel() {
		if (keywordPanel == null) {
			keywordPanel = new JPanel();
			keywordPanel.setLayout(new BorderLayout());
			keywordLabel = new JLabel();
			keywordLabel.setText("Enter Keyword");
			keywordPanel.add(keywordLabel, BorderLayout.WEST);
			keywordPanel.add(getKeywordTextField(), BorderLayout.CENTER);
			keywordPanel.add(getRunQueryButton(), BorderLayout.EAST);
		}
		return keywordPanel;
	}
	

	/**
	 * This method initializes optionPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getOptionPanel() {
		if (optionPanel == null) {
			optionPanel = new JPanel();
			optionPanel.setLayout(new BorderLayout());
			optionPanel.add(getFindTypePanel(), BorderLayout.CENTER);
			optionPanel.add(getLimitPanel(), BorderLayout.EAST);
		}
		return optionPanel;
	}

	/**
	 * This method initializes findTypePanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getFindTypePanel() {
		if (findTypePanel == null) {
			FlowLayout flowLayout = new FlowLayout();
			flowLayout.setHgap(10);
			flowLayout.setVgap(0);
			findTypePanel = new JPanel();
			findTypePanel.setLayout(flowLayout);
			findTypePanel.add(getFullMatchRadioButton(), null);
			findTypePanel.add(getPartMatchRadioButton(), null);
			findTypePanel.add(getFindSeparator(), null);
			findTypePanel.add(getFindAllRadioButton(), null);
			findTypePanel.add(getFindSubjectRadioButton(), null);
			findTypePanel.add(getFindObjectRadioButton(), null);
			findTypePanel.add(getFindLabelObjectRadioButton(), null);
			ButtonGroup bg = new ButtonGroup();
			bg.add(getFullMatchRadioButton());
			bg.add(getPartMatchRadioButton());
			getFullMatchRadioButton().setSelected(true);
			ButtonGroup bg2 = new ButtonGroup();
			bg2.add(getFindAllRadioButton());
			bg2.add(getFindSubjectRadioButton());
			bg2.add(getFindObjectRadioButton());
			bg2.add(getFindLabelObjectRadioButton());
			getFindSubjectRadioButton().setSelected(true);
		}
		return findTypePanel;
	}
	
	private boolean isFullMatch(){
		return getFullMatchRadioButton().isSelected();
	}

	private int getFindType(){
		if (getFindSubjectRadioButton().isSelected()){
			return SparqlAccessor.FIND_TARGET_SUBJECT;
		}
		if (getFindObjectRadioButton().isSelected()){
			return SparqlAccessor.FIND_TARGET_OBJECT;
		}
		if (getFindLabelObjectRadioButton().isSelected()){
			return SparqlAccessor.FIND_TARGET_LABEL_OBJECT;
		}
		return SparqlAccessor.FIND_TARGET_ALL;
	}

	/**
	 * This method initializes fulMatchRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getFullMatchRadioButton() {
		if (fullMatchRadioButton == null) {
			fullMatchRadioButton = new JRadioButton("Full Match");
		}
		return fullMatchRadioButton;
	}

	/**
	 * This method initializes partMatchRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getPartMatchRadioButton() {
		if (partMatchRadioButton == null) {
			partMatchRadioButton = new JRadioButton("Part Match");
		}
		return partMatchRadioButton;
	}

	/**
	 * This method initializes findSeparator	
	 * 	
	 * @return JSeparator	
	 */
	private JSeparator getFindSeparator() {
		if (findSeparator == null) {
			findSeparator = new JSeparator(SwingConstants.VERTICAL);
			findSeparator.setPreferredSize(new Dimension(5, 20));
		}
		return findSeparator;
	}


	/**
	 * This method initializes keywordTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getKeywordTextField() {
		if (keywordTextField == null) {
			keywordTextField = new JTextField();
			keywordTextField.addKeyListener(new KeyAdapter() {
				@Override
				public void keyTyped(KeyEvent arg0) {
					if (arg0.getKeyChar() == KeyEvent.VK_ENTER){
						doSearch();
					}
				}
			});
		}
		return keywordTextField;
	}
	
	/**
	 * 検索ワードを取得する
	 * @return
	 */
	public String getFindWord(){
		return getKeywordTextField().getText();
	}

	
	/**
	 * This method initializes subjectList	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getSubjectList() {
		if (subjectList == null) {
			subjectList = new JList();
			subjectList.addMouseListener(new MouseAdapter() {
				
				@Override
				public void mouseClicked(MouseEvent e) {
					if (e.getClickCount() >= 2){
						String subject = (String)getSubjectList().getSelectedValue();
						
						if (findSubjectTriple(subject)){
							addHistory(subject);
						}
					}
				}
			});

		}
		return subjectList;
	}

	private SparqlResultListener createSparqlResultListener2(){
		return new SparqlResultListener() {
			
			@Override
			public void resultReceived(SparqlResultSet result) {
				// 結果をまずはlistに追加
				setProcessing(false);
				setResults(result);
			}

			@Override
			public void uncaughtException(Thread t, Throwable e) {
				JOptionPane.showMessageDialog(parent, "Execute error:"+e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
				setProcessing(false);
				
			}
		};
	}

	private void setSubjectList(String obj){
		listModel = new DefaultListModel();
		listModel.addElement(obj);
		getSubjectList().setModel(listModel);
	}
	
	public void setSubjectList(List<String> list){
		subjectHistoryList = list;
		listModel = new DefaultListModel();
		for (String item : list){
			listModel.addElement(item);
		}
		getSubjectList().setModel(listModel);
	}
	
	/**
	 * This method initializes subjectScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getSubjectScrollPane() {
		if (subjectScrollPane == null) {
			subjectScrollPane = new JScrollPane(getSubjectList());
		}
		return subjectScrollPane;
	}

	/**
	 * This method initializes centerPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getCenterPanel() {
		if (centerPanel == null) {
			centerPanel = new JPanel();
			centerPanel.setLayout(new BorderLayout());
			centerPanel.add(getSubjectScrollPane(), BorderLayout.CENTER);
		}
		return centerPanel;
	}

	/**
	 * This method initializes footerPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getFooterPanel() {
		if (footerPanel == null) {
			footerPanel = new JPanel();
			footerPanel.setLayout(new BorderLayout());
			footerPanel.add(getResultListScrollPane(), BorderLayout.CENTER);
		}
		return footerPanel;
	}

	/**
	 * This method initializes resultListScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getResultListScrollPane() {
		if (resultListScrollPane == null) {
			resultListScrollPane = new JScrollPane(getResultList());
		}
		return resultListScrollPane;
	}

	/**
	 * This method initializes resultList	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JTable getResultList() {
		if (resultList == null) {
			resultList = new JTable();
			resultList.setDefaultEditor(Object.class, null);
			resultList.addMouseListener(new MouseAdapter() {
				@Override
				public void mouseClicked(MouseEvent e) {

					if (e.getClickCount() >= 2){
						int index = resultList.getSelectedRow();
						
						String o = (resultList.getValueAt(index, 1)).toString();

						setSubjectList(o);

						if (findSubjectTriple(o)){
							addHistory(o);
						}
					}
					
				}
			});

		}
		return resultList;
	}
	
	public void setResults(SparqlResultSet result){ // TODO
		
		if (result == null || result.getResult() == null || result.getResult().size() == 0){
			tableModel = new DefaultTableModel();
			getResultList().setModel(tableModel);
			return;
		}
		List<Map<String, RDFNode>> list = result.getResult();
		
		// headerセット
		Map<String, RDFNode> columns = list.get(0);
		List<String> clm = new ArrayList<String>();
		for (String key : columns.keySet()){
			clm.add(key);
		}
		tableModel = new DefaultTableModel(clm.toArray(new String[]{}), 0);

		
		// 中身セット
		for (Map<String, RDFNode> r : list){
			List<Object> row = new ArrayList<Object>();
			for (String key : clm){
				RDFNode node = r.get(key);
				row.add(node);
			}
			tableModel.addRow(row.toArray(new Object[]{}));
		}
		
		getResultList().setModel(tableModel);
		
		parent.setResults(sa, result);
		
	}

	private void setProcessing(boolean processing){
		this. processing = processing;
		getSubjectList().setEnabled(!processing);
		getRunQueryButton().setEnabled(!processing);
		getResultList().setEnabled(!processing);
		getKeywordTextField().setEnabled(!processing);
		getFullMatchRadioButton().setEnabled(!processing);
		getPartMatchRadioButton().setEnabled(!processing);
//		getFindAllRadioButton().setEnabled(!processing);
		getFindSubjectRadioButton().setEnabled(!processing);
		getFindObjectRadioButton().setEnabled(!processing);
		getFindLabelObjectRadioButton().setEnabled(!processing);
		
		updateButtonStates();
		updateLimitButtonStates();
		
		parent.setProcessing(processing);
	}
	
	private boolean isProcessing(){
		return this.processing;
	}
	
	/**
	 * This method initializes runQueryButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getRunQueryButton() {
		if (runQueryButton == null) {
			runQueryButton = new JButton("Find");
			runQueryButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent e) {
					doSearch();
				}
			});
		}
		return runQueryButton;
	}
	
	private void doSearch(){
		if (isProcessing()){
			return;
		}
		
		initHistory();
		initLimit();
		
		setResults(null);
		setProcessing(true);
		sa = new SparqlAccessor(EndpointSettingsManager.instance.getSetting(parent.getCurrentEndPoint()), new SparqlQueryListener() {
			@Override
			public void sparqlExecuted(String query) {
				fromDate = new Date();
				parent.addLogText("----------------");
				parent.addLogText(query);
			}
		});
		
		// page切替用にバックアップ
		this.word = getFindWord();
		this.fullMatch = isFullMatch();
		this.limit = getLimit();
		this.type = getFindType();
		
		sa.findSubject(word, fullMatch, limit, (limit != null ? (limit * page) : null), type, createSparqlResultListener());
	}
	
	private SparqlResultListener createSparqlResultListener(){
		return new SparqlResultListener() {
			
			@Override
			public void resultReceived(SparqlResultSet result) {

				hasLimitNext = result.isHasNext();
				
				Date now = new Date();
				long time = now.getTime() - fromDate.getTime();
				parent.addLogText("---------------- result:"+time+" ms");
				// 結果をまずはlistに追加
				List<String> resultList = new ArrayList<String>();
				for (Map<String, RDFNode> item : result.getResult()){
					RDFNode node = item.get("s");
					resultList.add(node.toString());
				}
				
				setSubjectList(resultList);
				setProcessing(false);
			}

			@Override
			public void uncaughtException(Thread t, Throwable e) {
				JOptionPane.showMessageDialog(parent, "Execute error:"+e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
				setProcessing(false);

			}
		};
	}

	/**
	 * This method initializes headerPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getHeaderPanel() {
		if (headerPanel == null) {
			headerPanel = new JPanel();
			headerPanel.setLayout(new BorderLayout());
			headerPanel.add(getKeywordPanel(), BorderLayout.CENTER);
			headerPanel.add(getOptionPanel(), BorderLayout.SOUTH);
			headerPanel.add(getMovePanel(), BorderLayout.WEST);
		}
		return headerPanel;
	}

	/**
	 * This method initializes limitPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getLimitPanel() {
		if (limitPanel == null) {
			limitLabel = new JLabel();
			limitLabel.setText(" LIMIT  ");
			limitLabel.setEnabled(false);
			limitPanel = new JPanel();
			limitPanel.setLayout(new BorderLayout());
			limitPanel.add(getLimitEnableCheckBox(), BorderLayout.WEST);
			limitPanel.add(limitLabel, BorderLayout.CENTER);
			limitPanel.add(getLimitMainPanel(), BorderLayout.EAST);
		}
		return limitPanel;
	}

	private Integer getLimit(){
		try {
			if (getLimitComboBox().isEnabled()){
				return Integer.parseInt((String)getLimitComboBox().getSelectedItem());
			}
		} catch(Exception e){}
		return null;
	}
	
	/**
	 * This method initializes limitEnableCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getLimitEnableCheckBox() {
		if (limitEnableCheckBox == null) {
			limitEnableCheckBox = new JCheckBox();
			limitEnableCheckBox.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent e) {
					boolean enabled = getLimitEnableCheckBox().isSelected();
					getLimitComboBox().setEnabled(enabled);
					limitLabel.setEnabled(enabled);
					updateLimitButtonStates();
				}
			});
		}
		return limitEnableCheckBox;
	}

	/**
	 * This method initializes limitComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getLimitComboBox() {
		if (limitComboBox == null) {
			String[] limits = {"100","250","500","1000"};
			limitComboBox = new JComboBox(limits);
			limitComboBox.setEnabled(false);
		}
		return limitComboBox;
	}

	/**
	 * This method initializes findSubjectRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getFindSubjectRadioButton() {
		if (findSubjectRadioButton == null) {
			findSubjectRadioButton = new JRadioButton("Find Subject");
		}
		return findSubjectRadioButton;
	}

	/**
	 * This method initializes findObjectRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getFindObjectRadioButton() {
		if (findObjectRadioButton == null) {
			findObjectRadioButton = new JRadioButton("Find All Object");
		}
		return findObjectRadioButton;
	}

	/**
	 * This method initializes findAllRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getFindAllRadioButton() {
		if (findAllRadioButton == null) {
			findAllRadioButton = new JRadioButton("Find All");
			findAllRadioButton.setEnabled(false);
		}
		return findAllRadioButton;
	}

	/**
	 * This method initializes findLabelObjectRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getFindLabelObjectRadioButton() {
		if (findLabelObjectRadioButton == null) {
			findLabelObjectRadioButton = new JRadioButton("Find Label Object");
		}
		return findLabelObjectRadioButton;
	}

	/**
	 * This method initializes movePanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getMovePanel() {
		if (movePanel == null) {
			movePanel = new JPanel();
			movePanel.setLayout(new BoxLayout(movePanel, BoxLayout.X_AXIS));
			movePanel.add(getPrevButton(), null);
			movePanel.add(getNextButton(), null);
		}
		return movePanel;
	}

	/**
	 * This method initializes prevButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getPrevButton() {
		if (prevButton == null) {
			prevButton = new JButton("←");
			prevButton.setMargin(new Insets(0, 10, 0, 10));
			prevButton.setEnabled(false);
			prevButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					String s = getPrev();
					if (s != null){
						if (historyIndex == 0){
							setSubjectList(subjectHistoryList);
						} else {
							setSubjectList(s);
						}
						findSubjectTriple(s);
					}
				}
			});
		}
		return prevButton;
	}

	/**
	 * This method initializes nextButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getNextButton() {
		if (nextButton == null) {
			nextButton = new JButton("→");
			nextButton.setMargin(new Insets(0, 10, 0, 10));
			nextButton.setEnabled(false);
			nextButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					String s = getNext();
					if (s != null){
						setSubjectList(s);
						findSubjectTriple(s);
					}
				}
			});
		}
		return nextButton;
	}
	
	private boolean findSubjectTriple(String s){
		if (isProcessing()){
			return false;
		}
		setProcessing(true);
		// tableクリア
		setResults(null);
		sa.findTripleFromSubject(s, createSparqlResultListener2());
		return true;
	}

	private void initHistory(){
		this.history = new ArrayList<String>();
		this.historyIndex = -1;
		updateButtonStates();
	}
	
	private void addHistory(String item){
		
		if (this.historyIndex >= 0 && this.historyIndex < (this.history.size() - 1)){
			for (int i=this.history.size()-1; i > this.historyIndex; i--){
				this.history.remove(i);
			}
		}
		this.history.add(item);
		this.historyIndex++;
		updateButtonStates();
		}
	
	private String getPrev(){
		if (hasPrev()){
			--historyIndex;
			updateButtonStates();
			return this.history.get(historyIndex);
		}
		return null;
	}

	private String getNext(){
		if (hasNext()){
			++historyIndex;
			updateButtonStates();
			return this.history.get(historyIndex);
		}
		return null;
	}
	
	private void updateButtonStates(){
		if (!this.processing){
			this.getPrevButton().setEnabled(hasPrev());
			this.getNextButton().setEnabled(hasNext());
		} else {
			this.getPrevButton().setEnabled(false);
			this.getNextButton().setEnabled(false);
		}
	}
	
	private boolean hasPrev(){
		if (history.size() != 0 && historyIndex > 0){
			return true;
		}
		return false;
	}

	private boolean hasNext(){
		if ((historyIndex + 1) < history.size()){
			return true;
		}
		return false;
	}

	/**
	 * This method initializes limitMainPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getLimitMainPanel() {
		if (limitMainPanel == null) {
			limitMainPanel = new JPanel();
			limitMainPanel.setLayout(new BorderLayout());
			limitMainPanel.add(getLimitComboBox(), BorderLayout.WEST);
			limitMainPanel.add(getLimitPrevButton(), BorderLayout.CENTER);
			limitMainPanel.add(getLimitNextButton(), BorderLayout.EAST);
		}
		return limitMainPanel;
	}

	/**
	 * This method initializes limitPrevButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getLimitPrevButton() {
		if (limitPrevButton == null) {
			limitPrevButton = new JButton("←");
			limitPrevButton.setMargin(new Insets(0, 10, 0, 10));
			limitPrevButton.setEnabled(false);
			limitPrevButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					setProcessing(true);
					sa.findSubject(word, fullMatch, limit, (limit * (--page)), type, createSparqlResultListener());
				}
			});
		}
		return limitPrevButton;
	}

	/**
	 * This method initializes limitNextButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getLimitNextButton() {
		if (limitNextButton == null) {
			limitNextButton = new JButton("→");
			limitNextButton.setMargin(new Insets(0, 10, 0, 10));
			limitNextButton.setEnabled(false);
			limitNextButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					setProcessing(true);

					sa.findSubject(word, fullMatch, limit, (limit * (++page)), type, createSparqlResultListener());
				}
			});
		}
		return limitNextButton;
	}

	private void initLimit(){
		limit = this.getLimit();
		page = 0;
	}
	
	private void updateLimitButtonStates(){
		if (!this.processing && this.getLimitEnableCheckBox().isSelected()){
			this.getLimitPrevButton().setEnabled(page != 0);
			this.getLimitNextButton().setEnabled(hasLimitNext);
		} else {
			this.getLimitPrevButton().setEnabled(false);
			this.getLimitNextButton().setEnabled(false);
		}
	}
	
}
