package jp.ac.osaka_u.sanken.sparql.gui;

import javax.swing.JPanel;
import java.awt.Frame;
import java.awt.BorderLayout;
import javax.swing.JDialog;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import java.awt.GridBagConstraints;
import javax.swing.JTextField;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import com.ibm.icu.text.SimpleDateFormat;

import jp.ac.osaka_u.sanken.Version;
import jp.ac.osaka_u.sanken.sparql.CoreVersion;

public class VersionDialog extends JDialog {

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JLabel coreVersionLabel = null;
	private JLabel guiVersionLabel = null;
	private JTextField coreVersionTextField = null;
	private JTextField coreVersionDateTextField = null;
	private JTextField guiVersionTextField = null;
	private JTextField guiVersionDateTextField = null;
	private JButton okButton = null;

	/**
	 * @param owner
	 */
	public VersionDialog(Frame owner) {
		super(owner);
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(401, 151);
		this.setContentPane(getJContentPane());
		this.setResizable(false);
		this.setModal(true);
		this.setTitle("Version Info");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		
		Version cv = new CoreVersion();
		
		this.getCoreVersionTextField().setText(cv.getVersion());
		this.getCoreVersionDateTextField().setText(sdf.format(cv.getDate()));

		GUIVersion gv = new GUIVersion();
		this.getGuiVersionTextField().setText(gv.getVersion());
		this.getGuiVersionDateTextField().setText(sdf.format(gv.getDate()));

		
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.gridx = 2;
			gridBagConstraints6.insets = new Insets(20, 0, 0, 20);
			gridBagConstraints6.anchor = GridBagConstraints.EAST;
			gridBagConstraints6.gridy = 2;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.fill = GridBagConstraints.BOTH;
			gridBagConstraints5.gridy = 1;
			gridBagConstraints5.weightx = 1.0;
			gridBagConstraints5.insets = new Insets(10, 10, 0, 10);
			gridBagConstraints5.gridx = 2;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.fill = GridBagConstraints.BOTH;
			gridBagConstraints4.gridy = 1;
			gridBagConstraints4.weightx = 1.0;
			gridBagConstraints4.insets = new Insets(10, 10, 0, 0);
			gridBagConstraints4.gridx = 1;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.gridy = 0;
			gridBagConstraints3.weightx = 1.0;
			gridBagConstraints3.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints3.gridx = 2;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.gridy = 0;
			gridBagConstraints2.weightx = 1.0;
			gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
			gridBagConstraints2.gridx = 1;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.insets = new Insets(10, 10, 0, 0);
			gridBagConstraints1.gridy = 1;
			guiVersionLabel = new JLabel();
			guiVersionLabel.setText("GUI Version");
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.insets = new Insets(0, 10, 0, 0);
			gridBagConstraints.gridy = 0;
			coreVersionLabel = new JLabel();
			coreVersionLabel.setText("Core Version");
			jContentPane = new JPanel();
			jContentPane.setLayout(new GridBagLayout());
			jContentPane.add(coreVersionLabel, gridBagConstraints);
			jContentPane.add(guiVersionLabel, gridBagConstraints1);
			jContentPane.add(getCoreVersionTextField(), gridBagConstraints2);
			jContentPane.add(getCoreVersionDateTextField(), gridBagConstraints3);
			jContentPane.add(getGuiVersionTextField(), gridBagConstraints4);
			jContentPane.add(getGuiVersionDateTextField(), gridBagConstraints5);
			jContentPane.add(getOkButton(), gridBagConstraints6);
		}
		return jContentPane;
	}

	/**
	 * This method initializes coreVersionTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getCoreVersionTextField() {
		if (coreVersionTextField == null) {
			coreVersionTextField = new JTextField();
			coreVersionTextField.setEditable(false);
		}
		return coreVersionTextField;
	}

	/**
	 * This method initializes coreVersionDateTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getCoreVersionDateTextField() {
		if (coreVersionDateTextField == null) {
			coreVersionDateTextField = new JTextField();
			coreVersionDateTextField.setEditable(false);
		}
		return coreVersionDateTextField;
	}

	/**
	 * This method initializes guiVersionTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getGuiVersionTextField() {
		if (guiVersionTextField == null) {
			guiVersionTextField = new JTextField();
			guiVersionTextField.setEditable(false);
		}
		return guiVersionTextField;
	}

	/**
	 * This method initializes guiVersionDateTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getGuiVersionDateTextField() {
		if (guiVersionDateTextField == null) {
			guiVersionDateTextField = new JTextField();
			guiVersionDateTextField.setEditable(false);
		}
		return guiVersionDateTextField;
	}

	/**
	 * This method initializes okButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getOkButton() {
		if (okButton == null) {
			okButton = new JButton("OK");
			okButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent e) {
					close();
				}
			});
		}
		return okButton;
	}
	
	private void close(){
		this.setVisible(false);
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
