/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.FunctionBase1;
import com.hp.hpl.jena.sparql.function.FunctionFactory;

public class CastXSD
implements FunctionFactory {
    protected final XSDDatatype castType;

    public CastXSD(XSDDatatype dt) {
        this.castType = dt;
    }

    @Override
    public Function create(String uri) {
        return new Instance(this.castType);
    }

    protected static class Instance
    extends FunctionBase1 {
        XSDDatatype castType;

        Instance(XSDDatatype dt) {
            this.castType = dt;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public NodeValue exec(NodeValue v) {
            String s = null;
            Node n = v.asNode();
            if (n.isBlank()) {
                throw new ExprEvalException("CastXSD: Can't cast blank nodes: " + v);
            }
            if (n.isURI()) {
                if (!this.castType.equals(XSDDatatype.XSDstring)) throw new ExprEvalException("CastXSD: Can't cast node: " + v + " to " + this.castType.getURI());
                s = n.getURI();
            } else {
                if (!n.isLiteral()) throw new ExprEvalException("CastXSD: Can't cast node: " + v + "(not a literal, not URI to string)");
                s = n.getLiteralLexicalForm();
            }
            if (s == null && v.isString()) {
                s = v.getString();
            }
            if (s != null) return this.cast(s, v, this.castType);
            throw new ExprEvalException("CastXSD: Can't cast: " + v + "(has no string appearance)");
        }

        protected NodeValue cast(String s, NodeValue nv, XSDDatatype castType2) {
            if (!this.castType.isValid(s)) {
                throw new ExprEvalException("CastXSD: Not a valid literal form: " + s);
            }
            return NodeValue.makeNode(s, this.castType);
        }
    }
}

