/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGRDFHandler;
import com.franz.agraph.repository.AGRepositoryConnection;
import org.openrdf.model.Statement;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.StatementCollector;

public class AGFreetextQuery {
    private final AGRepositoryConnection conn;
    protected String pattern;
    protected String expression;
    protected String index;
    protected boolean sorted = false;
    protected int limit = 0;
    protected int offset = 0;

    public AGFreetextQuery(AGRepositoryConnection conn) {
        this.conn = conn;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public RepositoryResult<Statement> evaluate() throws QueryEvaluationException {
        try {
            StatementCollector collector = new StatementCollector();
            this.evaluate((RDFHandler)collector);
            return this.conn.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        try {
            this.conn.getHttpRepoClient().evalFreetextQuery(this.pattern, this.expression, this.index, this.sorted, this.limit, this.offset, new AGRDFHandler(this.conn.getHttpRepoClient().getPreferredRDFFormat(), handler, this.conn.getValueFactory(), this.conn.getHttpRepoClient().getAllowExternalBlankNodeIds()));
        }
        catch (AGHttpException e) {
            throw new QueryEvaluationException((Throwable)((Object)e));
        }
    }
}

