/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.openrdf.sail.rdbms.schema.Batch;
import org.openrdf.sail.rdbms.schema.RdbmsTable;
import org.openrdf.sail.rdbms.schema.ValueBatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTable {
    public static int BATCH_SIZE = 8192;
    public static final long NIL_ID = 0L;
    private static final String[] PKEY = new String[]{"id"};
    private static final String[] VALUE_INDEX = new String[]{"value"};
    private int length = -1;
    private int sqlType;
    private int idType;
    private String INSERT;
    private String INSERT_SELECT;
    private String EXPUNGE;
    private RdbmsTable table;
    private RdbmsTable temporary;
    private ValueBatch batch;
    private BlockingQueue<Batch> queue;
    private boolean indexingValues;
    private PreparedStatement insertSelect;

    public void setQueue(BlockingQueue<Batch> queue) {
        this.queue = queue;
    }

    public boolean isIndexingValues() {
        return this.indexingValues;
    }

    public void setIndexingValues(boolean indexingValues) {
        this.indexingValues = indexingValues;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public int getIdType() {
        return this.idType;
    }

    public void setIdType(int sqlType) {
        this.idType = sqlType;
    }

    public RdbmsTable getRdbmsTable() {
        return this.table;
    }

    public void setRdbmsTable(RdbmsTable table) {
        this.table = table;
    }

    public RdbmsTable getTemporaryTable() {
        return this.temporary;
    }

    public void setTemporaryTable(RdbmsTable temporary) {
        this.temporary = temporary;
    }

    public String getName() {
        return this.table.getName();
    }

    public long size() {
        return this.table.size();
    }

    public int getBatchSize() {
        return BATCH_SIZE;
    }

    public void initialize() throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(this.getInsertTable().getName());
        sb.append(" (id, value) VALUES (?, ?)");
        this.INSERT = sb.toString();
        sb.delete(0, sb.length());
        sb.append("DELETE FROM ").append(this.table.getName()).append("\n");
        sb.append("WHERE 1=1 ");
        this.EXPUNGE = sb.toString();
        if (this.temporary != null) {
            sb.delete(0, sb.length());
            sb.append("INSERT INTO ").append(this.table.getName());
            sb.append(" (id, value) SELECT DISTINCT id, value FROM ");
            sb.append(this.temporary.getName()).append(" tmp\n");
            sb.append("WHERE NOT EXISTS (SELECT id FROM ").append(this.table.getName());
            sb.append(" val WHERE val.id = tmp.id)");
            this.INSERT_SELECT = sb.toString();
        }
        if (!this.table.isCreated()) {
            this.createTable(this.table);
            this.table.primaryIndex(PKEY);
            if (this.isIndexingValues()) {
                this.table.index(VALUE_INDEX);
            }
        } else {
            this.table.count();
        }
        if (this.temporary != null && !this.temporary.isCreated()) {
            this.createTemporaryTable(this.temporary);
        }
    }

    public void close() throws SQLException {
        if (this.insertSelect != null) {
            this.insertSelect.close();
        }
        if (this.temporary != null) {
            this.temporary.close();
        }
        this.table.close();
    }

    public synchronized void insert(Number id, String value) throws SQLException, InterruptedException {
        ValueBatch batch = this.getValueBatch();
        if (this.isExpired(batch)) {
            batch = this.newValueBatch();
            this.initBatch(batch);
        }
        batch.setObject(1, id);
        batch.setString(2, value);
        batch.addBatch();
        this.queue(batch);
    }

    public synchronized void insert(Number id, Number value) throws SQLException, InterruptedException {
        ValueBatch batch = this.getValueBatch();
        if (this.isExpired(batch)) {
            batch = this.newValueBatch();
            this.initBatch(batch);
        }
        batch.setObject(1, id);
        batch.setObject(2, value);
        batch.addBatch();
        this.queue(batch);
    }

    public ValueBatch getValueBatch() {
        return this.batch;
    }

    public boolean isExpired(ValueBatch batch) {
        if (batch == null || batch.isFull()) {
            return true;
        }
        return this.queue == null || !this.queue.remove(batch);
    }

    public ValueBatch newValueBatch() {
        return new ValueBatch();
    }

    public void initBatch(ValueBatch batch) throws SQLException {
        batch.setTable(this.table);
        batch.setBatchStatement(this.prepareInsert(this.INSERT));
        batch.setMaxBatchSize(this.getBatchSize());
        if (this.temporary != null) {
            batch.setTemporary(this.temporary);
            if (this.insertSelect == null) {
                this.insertSelect = this.prepareInsertSelect(this.INSERT_SELECT);
            }
            batch.setInsertStatement(this.insertSelect);
        }
    }

    public void queue(ValueBatch batch) throws SQLException, InterruptedException {
        this.batch = batch;
        if (this.queue == null) {
            batch.flush();
        } else {
            this.queue.put(batch);
        }
    }

    public void optimize() throws SQLException {
        this.table.optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expunge(String condition) throws SQLException {
        RdbmsTable rdbmsTable = this.table;
        synchronized (rdbmsTable) {
            int count = this.table.executeUpdate(this.EXPUNGE + condition, new String[0]);
            if (count < 1) {
                return false;
            }
            this.table.modified(0, count);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> maxIds(int shift, int mod) throws SQLException {
        String column = "id";
        StringBuilder expr = new StringBuilder();
        expr.append("MOD((").append(column);
        expr.append(" >> ").append(shift);
        expr.append(") + ").append(mod).append(", ");
        expr.append(mod);
        expr.append(")");
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append("MAX(");
        sb.append(column);
        sb.append("), ").append((CharSequence)expr).append(" AS grp");
        sb.append("\nFROM ").append(this.getName());
        sb.append("\nGROUP BY grp");
        String query2 = sb.toString();
        PreparedStatement st = this.table.prepareStatement(query2);
        try {
            ArrayList<Long> arrayList;
            ResultSet rs = st.executeQuery();
            try {
                ArrayList<Long> result = new ArrayList<Long>();
                while (rs.next()) {
                    result.add(rs.getLong(1));
                }
                arrayList = result;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return arrayList;
        }
        finally {
            st.close();
        }
    }

    public String sql(int type, int length) {
        switch (type) {
            case 12: {
                if (length > 0) {
                    return "VARCHAR(" + length + ")";
                }
                return "TEXT";
            }
            case -1: {
                if (length > 0) {
                    return "LONGVARCHAR(" + length + ")";
                }
                return "TEXT";
            }
            case -5: {
                return "BIGINT";
            }
            case 4: {
                return "INTEGER";
            }
            case 5: {
                return "SMALLINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 93: {
                return "TIMESTAMP";
            }
        }
        throw new AssertionError((Object)("Unsupported SQL Type: " + type));
    }

    public String toString() {
        return this.getName();
    }

    protected RdbmsTable getInsertTable() {
        RdbmsTable tmp = this.getTemporaryTable();
        if (tmp == null) {
            tmp = this.getRdbmsTable();
        }
        return tmp;
    }

    protected PreparedStatement prepareInsert(String sql) throws SQLException {
        return this.table.prepareStatement(sql);
    }

    protected PreparedStatement prepareInsertSelect(String sql) throws SQLException {
        return this.table.prepareStatement(sql);
    }

    protected void createTable(RdbmsTable table) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("  id ").append(this.sql(this.idType, -1)).append(" NOT NULL,\n");
        sb.append("  value ").append(this.sql(this.sqlType, this.length));
        sb.append(" NOT NULL\n");
        table.createTable(sb);
    }

    protected void createTemporaryTable(RdbmsTable table) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("  id ").append(this.sql(this.idType, -1)).append(" NOT NULL,\n");
        sb.append("  value ").append(this.sql(this.sqlType, this.length));
        sb.append(" NOT NULL\n");
        table.createTemporaryTable(sb);
    }
}

