/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.schema.NamespacesTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceManager {
    private Map<String, NamespaceImpl> byNamespace = new ConcurrentHashMap<String, NamespaceImpl>();
    private Map<String, NamespaceImpl> byPrefix = new ConcurrentHashMap<String, NamespaceImpl>();
    private Connection conn;
    private NamespacesTable table;

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void setNamespacesTable(NamespacesTable table) {
        this.table = table;
    }

    public void close() throws RdbmsException {
        try {
            this.conn.close();
        }
        catch (SQLException e2) {
            throw new RdbmsException(e2);
        }
    }

    public void initialize() throws RdbmsException {
        try {
            this.load();
        }
        catch (SQLException e2) {
            throw new RdbmsException(e2);
        }
    }

    public NamespaceImpl findNamespace(String namespace2) throws RdbmsException {
        if (namespace2 == null) {
            return null;
        }
        if (this.byNamespace.containsKey(namespace2)) {
            return this.byNamespace.get(namespace2);
        }
        try {
            return this.create(namespace2);
        }
        catch (SQLException e2) {
            throw new RdbmsException(e2);
        }
    }

    private void load() throws SQLException {
        HashMap<String, NamespaceImpl> map = new HashMap<String, NamespaceImpl>();
        HashMap<String, NamespaceImpl> prefixes = new HashMap<String, NamespaceImpl>();
        for (Object[] row : this.table.selectAll()) {
            String prefix = (String)row[0];
            String namespace2 = (String)row[1];
            if (namespace2 == null) continue;
            NamespaceImpl ns = new NamespaceImpl(prefix, namespace2);
            map.put(namespace2, ns);
            if (prefix == null) continue;
            prefixes.put(prefix, ns);
        }
        this.byNamespace.putAll(map);
        this.byPrefix.clear();
        this.byPrefix.putAll(prefixes);
    }

    private synchronized NamespaceImpl create(String namespace2) throws SQLException {
        if (this.byNamespace.containsKey(namespace2)) {
            return this.byNamespace.get(namespace2);
        }
        this.table.insert(null, namespace2);
        NamespaceImpl ns = new NamespaceImpl(null, namespace2);
        this.byNamespace.put(ns.getName(), ns);
        return ns;
    }

    public void setPrefix(String prefix, String name) throws RdbmsException {
        NamespaceImpl ns = this.findNamespace(name);
        try {
            this.table.updatePrefix(prefix, name);
        }
        catch (SQLException e2) {
            throw new RdbmsException(e2);
        }
        ns.setPrefix(prefix);
        this.byPrefix.put(prefix, ns);
    }

    public NamespaceImpl findByPrefix(String prefix) {
        return this.byPrefix.get(prefix);
    }

    public void removePrefix(String prefix) throws RdbmsException {
        NamespaceImpl ns = this.findByPrefix(prefix);
        if (ns == null) {
            return;
        }
        try {
            this.table.updatePrefix(prefix, ns.getName());
        }
        catch (SQLException e2) {
            throw new RdbmsException(e2);
        }
        ns.setPrefix(null);
        this.byPrefix.remove(prefix);
    }

    public Collection<? extends Namespace> getNamespacesWithPrefix() throws RdbmsException {
        return this.byPrefix.values();
    }

    public void clearPrefixes() throws RdbmsException {
        try {
            this.table.clearPrefixes();
            this.load();
        }
        catch (SQLException e2) {
            throw new RdbmsException(e2);
        }
    }
}

