/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers;

import java.sql.SQLException;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.sail.rdbms.managers.base.ValueManagerBase;
import org.openrdf.sail.rdbms.model.RdbmsLiteral;
import org.openrdf.sail.rdbms.schema.LiteralTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralManager
extends ValueManagerBase<RdbmsLiteral> {
    private static TimeZone Z = TimeZone.getTimeZone("GMT");
    public static LiteralManager instance;
    private LiteralTable table;

    public static long getCalendarValue(XMLGregorianCalendar xcal) {
        return xcal.toGregorianCalendar(Z, Locale.US, null).getTimeInMillis();
    }

    public LiteralManager() {
        instance = this;
    }

    public void setTable(LiteralTable table) {
        this.table = table;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.table != null) {
            this.table.close();
        }
    }

    @Override
    protected boolean expunge(String condition) throws SQLException {
        return this.table.expunge(condition);
    }

    @Override
    protected void optimize() throws SQLException {
        super.optimize();
        this.table.optimize();
    }

    protected Literal key(RdbmsLiteral value) {
        return value;
    }

    @Override
    protected void insert(Number id, RdbmsLiteral literal) throws SQLException, InterruptedException {
        String label = literal.getLabel();
        String language = literal.getLanguage();
        URI datatype = literal.getDatatype();
        if (datatype == null && language == null) {
            this.table.insertSimple(id, label);
        } else if (datatype == null) {
            this.table.insertLanguage(id, label, language);
        } else {
            String dt = datatype.stringValue();
            try {
                if (XMLDatatypeUtil.isNumericDatatype(datatype)) {
                    this.table.insertNumeric(id, label, dt, literal.doubleValue());
                } else if (XMLDatatypeUtil.isCalendarDatatype(datatype)) {
                    long value = LiteralManager.getCalendarValue(literal.calendarValue());
                    this.table.insertDateTime(id, label, dt, value);
                } else {
                    this.table.insertDatatype(id, label, dt);
                }
            }
            catch (NumberFormatException e2) {
                this.table.insertDatatype(id, label, dt);
            }
            catch (IllegalArgumentException e3) {
                this.table.insertDatatype(id, label, dt);
            }
        }
    }

    @Override
    protected int getBatchSize() {
        return this.table.getBatchSize();
    }
}

