/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.evaluation;

import info.aduna.iteration.CloseableIteration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.rdbms.RdbmsTripleRepository;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.SelectProjection;
import org.openrdf.sail.rdbms.algebra.SelectQuery;
import org.openrdf.sail.rdbms.evaluation.QueryBuilder;
import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.RdbmsTripleSource;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.exceptions.RdbmsQueryEvaluationException;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;
import org.openrdf.sail.rdbms.iteration.RdbmsBindingIteration;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdbmsEvaluation
extends EvaluationStrategyImpl {
    private Logger logger = LoggerFactory.getLogger(RdbmsEvaluation.class);
    private QueryBuilderFactory factory;
    private RdbmsValueFactory vf;
    private RdbmsTripleRepository triples;
    private IdSequence ids;

    public RdbmsEvaluation(QueryBuilderFactory factory, RdbmsTripleRepository triples, Dataset dataset, IdSequence ids) {
        super(new RdbmsTripleSource(triples), dataset);
        this.factory = factory;
        this.triples = triples;
        this.vf = triples.getValueFactory();
        this.ids = ids;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings2) throws QueryEvaluationException {
        if (expr instanceof SelectQuery) {
            return this.evaluate((SelectQuery)expr, bindings2);
        }
        return super.evaluate(expr, bindings2);
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> evaluate(SelectQuery qb, BindingSet b) throws UnsupportedRdbmsOperatorException, RdbmsQueryEvaluationException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        try {
            QueryBindingSet bindings2 = new QueryBindingSet(b);
            String query2 = this.toQueryString(qb, bindings2, parameters);
            try {
                Connection conn = this.triples.getConnection();
                PreparedStatement stmt = conn.prepareStatement(query2);
                int p = 0;
                for (Object e2 : parameters) {
                    stmt.setObject(++p, e2);
                }
                Collection<ColumnVar> proj = qb.getProjections();
                RdbmsBindingIteration rdbmsBindingIteration = new RdbmsBindingIteration(stmt);
                rdbmsBindingIteration.setProjections(proj);
                rdbmsBindingIteration.setBindings(bindings2);
                rdbmsBindingIteration.setValueFactory(this.vf);
                rdbmsBindingIteration.setIdSequence(this.ids);
                return rdbmsBindingIteration;
            }
            catch (SQLException e2) {
                throw new RdbmsQueryEvaluationException(e2.toString() + "\n" + query2, e2);
            }
        }
        catch (RdbmsException e3) {
            throw new RdbmsQueryEvaluationException(e3);
        }
    }

    private String toQueryString(SelectQuery qb, QueryBindingSet bindings2, List<Object> parameters) throws RdbmsException, UnsupportedRdbmsOperatorException {
        QueryBuilder query2 = this.factory.createQueryBuilder();
        if (qb.isDistinct()) {
            query2.distinct();
        }
        query2.from(qb.getFrom());
        for (ColumnVar var : qb.getVars()) {
            for (String name : qb.getBindingNames(var)) {
                if (var.getValue() == null && bindings2.hasBinding(name)) {
                    query2.filter(var, bindings2.getValue(name));
                    continue;
                }
                if (var.getValue() == null || bindings2.hasBinding(name) || !qb.getBindingNames().contains(name)) continue;
                bindings2.addBinding(name, var.getValue());
            }
        }
        int index = 0;
        for (SelectProjection proj : qb.getSqlSelectVar()) {
            ColumnVar var = proj.getVar();
            if (var.isHiddenOrConstant()) continue;
            for (String name : qb.getBindingNames(var)) {
                if (bindings2.hasBinding(name)) continue;
                var.setIndex(index);
                query2.select(proj.getId());
                query2.select(proj.getStringValue());
                index += 2;
                if (!var.getTypes().isLiterals()) continue;
                query2.select(proj.getLanguage());
                query2.select(proj.getDatatype());
                index += 2;
            }
        }
        for (SelectQuery.OrderElem by : qb.getOrderElems()) {
            query2.orderBy(by.sqlExpr, by.isAscending);
            if (!qb.isDistinct()) continue;
            query2.select(by.sqlExpr);
        }
        if (qb.getLimit() != null) {
            query2.limit(qb.getLimit());
        }
        if (qb.getOffset() != null) {
            query2.offset(qb.getOffset());
        }
        parameters.addAll(query2.getParameters());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(query2.toString());
            this.logger.debug(parameters.toString());
        }
        return query2.toString();
    }
}

