/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.factories;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.LabelColumn;
import org.openrdf.sail.rdbms.algebra.LongLabelColumn;
import org.openrdf.sail.rdbms.algebra.SqlCase;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.algebra.factories.SqlExprFactory;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelExprFactory
extends QueryModelVisitorBase<UnsupportedRdbmsOperatorException> {
    protected SqlExpr result;
    private SqlExprFactory sql;

    public void setSqlExprFactory(SqlExprFactory sql) {
        this.sql = sql;
    }

    public SqlExpr createLabelExpr(ValueExpr expr) throws UnsupportedRdbmsOperatorException {
        this.result = null;
        if (expr == null) {
            return new SqlNull();
        }
        expr.visit(this);
        if (this.result == null) {
            return new SqlNull();
        }
        return this.result;
    }

    @Override
    public void meet(Datatype node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(Lang node) throws UnsupportedRdbmsOperatorException {
        SqlCase sqlCase = new SqlCase();
        sqlCase.when(SqlExprSupport.isNotNull(this.lang(node.getArg())), this.lang(node.getArg()));
        sqlCase.when(SqlExprSupport.isNotNull(this.createLabelExpr(node.getArg())), SqlExprSupport.str(""));
        this.result = sqlCase;
    }

    @Override
    public void meet(MathExpr node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.text(this.num(node));
    }

    @Override
    public void meet(Str str2) throws UnsupportedRdbmsOperatorException {
        ValueExpr arg = str2.getArg();
        this.result = SqlExprSupport.coalesce(this.uri(arg), this.createLabelExpr(arg));
    }

    @Override
    public void meet(ValueConstant vc) {
        this.result = this.valueOf(vc.getValue());
    }

    @Override
    public void meet(Var var) {
        this.result = var.getValue() == null ? SqlExprSupport.coalesce(new LabelColumn(var), new LongLabelColumn(var)) : this.valueOf(var.getValue());
    }

    @Override
    protected void meetNode(QueryModelNode arg) throws UnsupportedRdbmsOperatorException {
        throw SqlExprSupport.unsupported(arg);
    }

    private SqlExpr lang(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createLanguageExpr(arg);
    }

    private SqlExpr uri(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createUriExpr(arg);
    }

    private SqlExpr num(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createNumericExpr(arg);
    }

    private SqlExpr valueOf(Value value) {
        if (value instanceof Literal) {
            return SqlExprSupport.str(((Literal)value).getLabel());
        }
        return SqlExprSupport.sqlNull();
    }
}

