/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.factories;

import org.openrdf.model.Value;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.algebra.NumberValue;
import org.openrdf.sail.rdbms.algebra.RefIdColumn;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.exceptions.RdbmsRuntimeException;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashExprFactory
extends QueryModelVisitorBase<UnsupportedRdbmsOperatorException> {
    protected SqlExpr result;
    private RdbmsValueFactory vf;

    public HashExprFactory(RdbmsValueFactory vf) {
        this.vf = vf;
    }

    public SqlExpr createHashExpr(ValueExpr expr) throws UnsupportedRdbmsOperatorException {
        this.result = null;
        if (expr == null) {
            return new SqlNull();
        }
        expr.visit(this);
        if (this.result == null) {
            return new SqlNull();
        }
        return this.result;
    }

    @Override
    public void meet(ValueConstant vc) {
        this.result = this.valueOf(vc.getValue());
    }

    @Override
    public void meet(Var var) {
        this.result = var.getValue() == null ? new RefIdColumn(var) : this.valueOf(var.getValue());
    }

    @Override
    protected void meetNode(QueryModelNode arg) throws UnsupportedRdbmsOperatorException {
        throw SqlExprSupport.unsupported(arg);
    }

    public SqlExpr valueOf(Value value) {
        try {
            return new NumberValue(this.vf.getInternalId(value));
        }
        catch (RdbmsException e2) {
            throw new RdbmsRuntimeException(e2);
        }
    }
}

