/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.io.IOUtil;
import java.io.File;
import java.io.IOException;

class TxnStatusFile {
    public static final String FILE_NAME = "txn-status";
    private final File file;

    public TxnStatusFile(File dataDir) throws IOException {
        this.file = new File(dataDir, FILE_NAME);
        if (!this.file.exists()) {
            this.setTxnStatus(TxnStatus.NONE);
        }
    }

    public void setTxnStatus(TxnStatus txnStatus) throws IOException {
        IOUtil.writeString(txnStatus.name(), this.file);
    }

    public TxnStatus getTxnStatus() throws IOException {
        String s = IOUtil.readString(this.file);
        try {
            return TxnStatus.valueOf(s);
        }
        catch (IllegalArgumentException e2) {
            return TxnStatus.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TxnStatus {
        NONE,
        ACTIVE,
        COMMITTING,
        ROLLING_BACK,
        UNKNOWN;

    }
}

