/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory;

import info.aduna.concurrent.locks.ExclusiveLockManager;
import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.ReadPrefReadWriteLockManager;
import info.aduna.concurrent.locks.ReadWriteLockManager;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Timer;
import java.util.TimerTask;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.helpers.DirectoryLockManager;
import org.openrdf.sail.helpers.NotifyingSailBase;
import org.openrdf.sail.memory.FileIO;
import org.openrdf.sail.memory.MemNamespaceStore;
import org.openrdf.sail.memory.MemoryStoreConnection;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementIterator;
import org.openrdf.sail.memory.model.MemStatementList;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.MemValueFactory;
import org.openrdf.sail.memory.model.ReadMode;
import org.openrdf.sail.memory.model.TxnStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStore
extends NotifyingSailBase {
    protected static final String DATA_FILE_NAME = "memorystore.data";
    protected static final String SYNC_FILE_NAME = "memorystore.sync";
    private final MemValueFactory valueFactory = new MemValueFactory();
    private final MemStatementList statements = new MemStatementList(256);
    private volatile IdentityHashMap<MemStatement, MemStatement> txnStatements;
    private volatile int currentSnapshot;
    private final MemNamespaceStore namespaceStore = new MemNamespaceStore();
    private final ReadWriteLockManager statementListLockManager = new ReadPrefReadWriteLockManager(MemoryStore.debugEnabled());
    private final ExclusiveLockManager txnLockManager = new ExclusiveLockManager(MemoryStore.debugEnabled());
    private volatile boolean persist = false;
    private volatile File dataFile;
    private volatile File syncFile;
    private volatile Lock dirLock;
    private volatile boolean contentsChanged;
    private volatile long syncDelay = 0L;
    private final Object syncSemaphore = new Object();
    private volatile Timer syncTimer;
    private volatile TimerTask syncTimerTask;
    private final Object syncTimerSemaphore = new Object();
    private volatile Thread snapshotCleanupThread;
    private final Object snapshotCleanupThreadSemaphore = new Object();

    public MemoryStore() {
    }

    public MemoryStore(File dataDir) {
        this.setDataDir(dataDir);
        this.setPersist(true);
    }

    public void setPersist(boolean persist) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.persist = persist;
    }

    public boolean getPersist() {
        return this.persist;
    }

    public void setSyncDelay(long syncDelay) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.syncDelay = syncDelay;
    }

    public long getSyncDelay() {
        return this.syncDelay;
    }

    @Override
    protected void initializeInternal() throws SailException {
        this.logger.debug("Initializing MemoryStore...");
        this.currentSnapshot = 1;
        if (this.persist) {
            File dataDir = this.getDataDir();
            DirectoryLockManager locker = new DirectoryLockManager(dataDir);
            this.dataFile = new File(dataDir, DATA_FILE_NAME);
            this.syncFile = new File(dataDir, SYNC_FILE_NAME);
            if (this.dataFile.exists()) {
                this.logger.debug("Reading data from {}...", this.dataFile);
                if (!this.dataFile.canRead()) {
                    this.logger.error("Data file is not readable: {}", this.dataFile);
                    throw new SailException("Can't read data file: " + this.dataFile);
                }
                this.dirLock = locker.tryLock();
                if (this.dirLock == null) {
                    this.logger.warn("Failed to lock directory: {}", dataDir);
                }
                if (this.dataFile.length() == 0L) {
                    this.logger.warn("Ignoring empty data file: {}", this.dataFile);
                } else {
                    try {
                        new FileIO(this).read(this.dataFile);
                        this.logger.debug("Data file read successfully");
                    }
                    catch (IOException e2) {
                        this.logger.error("Failed to read data file", e2);
                        throw new SailException(e2);
                    }
                }
            } else {
                try {
                    File dir = this.dataFile.getParentFile();
                    if (dir != null && !dir.exists()) {
                        this.logger.debug("Creating directory for data file...");
                        if (!dir.mkdirs()) {
                            this.logger.debug("Failed to create directory for data file: {}", dir);
                            throw new SailException("Failed to create directory for data file: " + dir);
                        }
                    }
                    this.dirLock = locker.lockOrFail();
                    this.logger.debug("Initializing data file...");
                    new FileIO(this).write(this.syncFile, this.dataFile);
                    this.logger.debug("Data file initialized");
                }
                catch (IOException e3) {
                    this.logger.debug("Failed to initialize data file", e3);
                    throw new SailException("Failed to initialize data file " + this.dataFile, e3);
                }
                catch (SailException e4) {
                    this.logger.debug("Failed to initialize data file", e4);
                    throw new SailException("Failed to initialize data file " + this.dataFile, e4);
                }
            }
        }
        this.contentsChanged = false;
        this.logger.debug("MemoryStore initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutDownInternal() throws SailException {
        try {
            Lock stLock = this.statementListLockManager.getWriteLock();
            try {
                this.cancelSyncTimer();
                this.syncWithLock();
                this.valueFactory.clear();
                this.statements.clear();
                this.dataFile = null;
                this.syncFile = null;
            }
            finally {
                stLock.release();
                if (this.dirLock != null) {
                    this.dirLock.release();
                }
            }
        }
        catch (InterruptedException e2) {
            throw new SailException(e2);
        }
    }

    @Override
    public boolean isWritable() {
        return !this.persist || this.dirLock != null;
    }

    @Override
    protected NotifyingSailConnection getConnectionInternal() throws SailException {
        return new MemoryStoreConnection(this);
    }

    @Override
    public MemValueFactory getValueFactory() {
        if (this.valueFactory == null) {
            throw new IllegalStateException("sail not initialized.");
        }
        return this.valueFactory;
    }

    protected MemNamespaceStore getNamespaceStore() {
        return this.namespaceStore;
    }

    protected MemStatementList getStatements() {
        return this.statements;
    }

    protected int getCurrentSnapshot() {
        return this.currentSnapshot;
    }

    protected Lock getStatementsReadLock() throws SailException {
        try {
            return this.statementListLockManager.getReadLock();
        }
        catch (InterruptedException e2) {
            throw new SailException(e2);
        }
    }

    protected Lock getTransactionLock() throws SailException {
        try {
            return this.txnLockManager.getExclusiveLock();
        }
        catch (InterruptedException e2) {
            throw new SailException(e2);
        }
    }

    protected int size() {
        return this.statements.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasStatement(Resource subj, URI pred, Value obj, boolean explicitOnly, int snapshot, ReadMode readMode, Resource ... contexts) {
        CloseableIteration<MemStatement, RuntimeException> iter = this.createStatementIterator(RuntimeException.class, subj, pred, obj, explicitOnly, snapshot, readMode, contexts);
        try {
            boolean bl = iter.hasNext();
            return bl;
        }
        finally {
            iter.close();
        }
    }

    protected <X extends Exception> CloseableIteration<MemStatement, X> createStatementIterator(Class<X> excClass, Resource subj, URI pred, Value obj, boolean explicitOnly, int snapshot, ReadMode readMode, Resource ... contexts) {
        MemStatementList l;
        MemStatementList smallestList;
        MemResource[] memContexts;
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (subj != null && memSubj == null) {
            return new EmptyIteration();
        }
        MemURI memPred = this.valueFactory.getMemURI(pred);
        if (pred != null && memPred == null) {
            return new EmptyIteration();
        }
        MemValue memObj = this.valueFactory.getMemValue(obj);
        if (obj != null && memObj == null) {
            return new EmptyIteration();
        }
        if (contexts.length == 0) {
            memContexts = new MemResource[]{};
            smallestList = this.statements;
        } else if (contexts.length == 1 && contexts[0] != null) {
            MemResource memContext = this.valueFactory.getMemResource(contexts[0]);
            if (memContext == null) {
                return new EmptyIteration();
            }
            memContexts = new MemResource[]{memContext};
            smallestList = memContext.getContextStatementList();
        } else {
            LinkedHashSet<MemResource> contextSet = new LinkedHashSet<MemResource>(2 * contexts.length);
            for (Resource context : contexts) {
                MemResource memContext = this.valueFactory.getMemResource(context);
                if (context != null && memContext == null) continue;
                contextSet.add(memContext);
            }
            if (contextSet.isEmpty()) {
                return new EmptyIteration();
            }
            memContexts = contextSet.toArray(new MemResource[contextSet.size()]);
            smallestList = this.statements;
        }
        if (memSubj != null && (l = memSubj.getSubjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (memPred != null && (l = memPred.getPredicateStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (memObj != null && (l = memObj.getObjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        return new MemStatementIterator(smallestList, memSubj, memPred, memObj, explicitOnly, snapshot, readMode, memContexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement addStatement(Resource subj, URI pred, Value obj, Resource context, boolean explicit) throws SailException {
        MemResource memContext;
        assert (this.txnStatements != null);
        MemResource memSubj = this.valueFactory.getOrCreateMemResource(subj);
        MemURI memPred = this.valueFactory.getOrCreateMemURI(pred);
        MemValue memObj = this.valueFactory.getOrCreateMemValue(obj);
        MemResource memResource = memContext = context == null ? null : this.valueFactory.getOrCreateMemResource(context);
        if (memSubj.hasStatements() && memPred.hasStatements() && memObj.hasStatements() && (memContext == null || memContext.hasStatements())) {
            CloseableIteration<MemStatement, SailException> stIter = this.createStatementIterator(SailException.class, memSubj, memPred, memObj, false, this.currentSnapshot + 1, ReadMode.RAW, memContext);
            try {
                if (stIter.hasNext()) {
                    MemStatement st = (MemStatement)stIter.next();
                    this.txnStatements.put(st, st);
                    TxnStatus txnStatus = st.getTxnStatus();
                    if (txnStatus == TxnStatus.NEUTRAL && !st.isExplicit() && explicit) {
                        st.setTxnStatus(TxnStatus.EXPLICIT);
                    } else if (txnStatus == TxnStatus.NEW && !st.isExplicit() && explicit) {
                        st.setExplicit(true);
                    } else {
                        if (txnStatus == TxnStatus.DEPRECATED) {
                            if (st.isExplicit() == explicit) {
                                st.setTxnStatus(TxnStatus.NEUTRAL);
                            } else if (explicit) {
                                st.setTxnStatus(TxnStatus.EXPLICIT);
                            } else {
                                st.setTxnStatus(TxnStatus.INFERRED);
                            }
                            MemStatement memStatement = st;
                            return memStatement;
                        }
                        if (txnStatus == TxnStatus.INFERRED && st.isExplicit() && explicit) {
                            st.setTxnStatus(TxnStatus.NEUTRAL);
                        } else if (txnStatus == TxnStatus.ZOMBIE) {
                            st.setTxnStatus(TxnStatus.NEW);
                            st.setExplicit(explicit);
                            MemStatement memStatement = st;
                            return memStatement;
                        }
                    }
                    Statement statement = null;
                    return statement;
                }
            }
            finally {
                stIter.close();
            }
        }
        MemStatement st = new MemStatement(memSubj, memPred, memObj, memContext, explicit, this.currentSnapshot + 1, TxnStatus.NEW);
        this.statements.add(st);
        st.addToComponentLists();
        this.txnStatements.put(st, st);
        assert (this.hasStatement(memSubj, memPred, memObj, explicit, this.currentSnapshot + 1, ReadMode.TRANSACTION, memContext));
        return st;
    }

    protected boolean removeStatement(MemStatement st, boolean explicit) throws SailException {
        boolean statementsRemoved = false;
        TxnStatus txnStatus = st.getTxnStatus();
        if (txnStatus == TxnStatus.NEUTRAL && st.isExplicit() == explicit) {
            st.setTxnStatus(TxnStatus.DEPRECATED);
            statementsRemoved = true;
        } else if (txnStatus == TxnStatus.NEW && st.isExplicit() == explicit) {
            st.setTxnStatus(TxnStatus.ZOMBIE);
            statementsRemoved = true;
        } else if (txnStatus == TxnStatus.INFERRED && st.isExplicit() && !explicit) {
            st.setTxnStatus(TxnStatus.DEPRECATED);
            statementsRemoved = true;
        } else if (txnStatus == TxnStatus.EXPLICIT && !st.isExplicit() && explicit) {
            st.setTxnStatus(TxnStatus.NEUTRAL);
        }
        this.txnStatements.put(st, st);
        return statementsRemoved;
    }

    protected void startTransaction() throws SailException {
        this.cancelSyncTask();
        assert (this.txnStatements == null);
        this.txnStatements = new IdentityHashMap();
    }

    protected void commit() throws SailException {
        assert (this.txnStatements != null);
        boolean statementsAdded = false;
        boolean statementsRemoved = false;
        boolean statementsDeprecated = false;
        int txnSnapshot = this.currentSnapshot + 1;
        for (MemStatement st : this.txnStatements.keySet()) {
            TxnStatus txnStatus = st.getTxnStatus();
            if (txnStatus == TxnStatus.NEUTRAL) continue;
            if (txnStatus == TxnStatus.NEW) {
                statementsAdded = true;
            } else if (txnStatus == TxnStatus.DEPRECATED) {
                st.setTillSnapshot(txnSnapshot);
                statementsRemoved = true;
            } else if (txnStatus == TxnStatus.ZOMBIE) {
                st.setTillSnapshot(txnSnapshot);
                statementsDeprecated = true;
            } else if (txnStatus == TxnStatus.EXPLICIT || txnStatus == TxnStatus.INFERRED) {
                st.setTillSnapshot(txnSnapshot);
                statementsDeprecated = true;
                MemStatement explSt = new MemStatement(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext(), txnStatus == TxnStatus.EXPLICIT, txnSnapshot);
                this.statements.add(explSt);
                explSt.addToComponentLists();
            }
            st.setTxnStatus(TxnStatus.NEUTRAL);
        }
        this.txnStatements = null;
        if (statementsAdded || statementsRemoved || statementsDeprecated) {
            this.currentSnapshot = txnSnapshot;
        }
        if (statementsAdded || statementsRemoved) {
            this.contentsChanged = true;
            this.scheduleSyncTask();
            DefaultSailChangedEvent event = new DefaultSailChangedEvent(this);
            event.setStatementsAdded(statementsAdded);
            event.setStatementsRemoved(statementsRemoved);
            this.notifySailChanged(event);
        }
        if (statementsRemoved || statementsDeprecated) {
            this.scheduleSnapshotCleanup();
        }
    }

    protected void rollback() throws SailException {
        assert (this.txnStatements != null);
        this.logger.debug("rolling back transaction");
        boolean statementsDeprecated = false;
        for (MemStatement st : this.txnStatements.keySet()) {
            TxnStatus txnStatus = st.getTxnStatus();
            if (txnStatus == TxnStatus.NEW || txnStatus == TxnStatus.ZOMBIE) {
                st.setTillSnapshot(this.currentSnapshot);
                statementsDeprecated = true;
                continue;
            }
            if (txnStatus == TxnStatus.NEUTRAL) continue;
            st.setTxnStatus(TxnStatus.NEUTRAL);
        }
        this.txnStatements = null;
        if (statementsDeprecated) {
            this.scheduleSnapshotCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSyncTask() throws SailException {
        if (!this.persist) {
            return;
        }
        if (this.syncDelay == 0L) {
            this.sync();
        } else if (this.syncDelay > 0L) {
            Object object = this.syncTimerSemaphore;
            synchronized (object) {
                if (this.syncTimer == null) {
                    this.syncTimer = new Timer("MemoryStore synchronization", true);
                }
                if (this.syncTimerTask != null) {
                    this.logger.error("syncTimerTask is not null");
                }
                this.syncTimerTask = new TimerTask(){

                    public void run() {
                        try {
                            MemoryStore.this.sync();
                        }
                        catch (SailException e2) {
                            MemoryStore.this.logger.warn("Unable to sync on timer", e2);
                        }
                    }
                };
                this.syncTimer.schedule(this.syncTimerTask, this.syncDelay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSyncTask() {
        Object object = this.syncTimerSemaphore;
        synchronized (object) {
            if (this.syncTimerTask != null) {
                this.syncTimerTask.cancel();
                this.syncTimerTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSyncTimer() {
        Object object = this.syncTimerSemaphore;
        synchronized (object) {
            if (this.syncTimer != null) {
                this.syncTimer.cancel();
                this.syncTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws SailException {
        Lock stLock = this.getStatementsReadLock();
        try {
            this.syncWithLock();
        }
        finally {
            stLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncWithLock() throws SailException {
        Object object = this.syncSemaphore;
        synchronized (object) {
            if (this.persist && this.contentsChanged) {
                this.logger.debug("syncing data to file...");
                try {
                    new FileIO(this).write(this.syncFile, this.dataFile);
                    this.contentsChanged = false;
                    this.logger.debug("Data synced to file");
                }
                catch (IOException e2) {
                    this.logger.error("Failed to sync to file", e2);
                    throw new SailException(e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanSnapshots() throws InterruptedException {
        MemStatementList statements = this.statements;
        if (statements == null) {
            return;
        }
        HashSet<MemResource> processedSubjects = new HashSet<MemResource>();
        HashSet<MemURI> processedPredicates = new HashSet<MemURI>();
        HashSet<MemValue> processedObjects = new HashSet<MemValue>();
        HashSet<MemResource> processedContexts = new HashSet<MemResource>();
        Lock stLock = this.statementListLockManager.getWriteLock();
        try {
            for (int i = statements.size() - 1; i >= 0; --i) {
                MemStatement st = statements.get(i);
                if (st.getTillSnapshot() <= this.currentSnapshot) {
                    MemResource context;
                    MemValue obj;
                    MemURI pred;
                    MemResource subj = st.getSubject();
                    if (processedSubjects.add(subj)) {
                        subj.cleanSnapshotsFromSubjectStatements(this.currentSnapshot);
                    }
                    if (processedPredicates.add(pred = st.getPredicate())) {
                        pred.cleanSnapshotsFromPredicateStatements(this.currentSnapshot);
                    }
                    if (processedObjects.add(obj = st.getObject())) {
                        obj.cleanSnapshotsFromObjectStatements(this.currentSnapshot);
                    }
                    if ((context = st.getContext()) != null && processedContexts.add(context)) {
                        context.cleanSnapshotsFromContextStatements(this.currentSnapshot);
                    }
                    statements.remove(i);
                    continue;
                }
                st.setSinceSnapshot(1);
            }
            this.currentSnapshot = 1;
        }
        finally {
            stLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSnapshotCleanup() {
        Object object = this.snapshotCleanupThreadSemaphore;
        synchronized (object) {
            if (this.snapshotCleanupThread == null || !this.snapshotCleanupThread.isAlive()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            MemoryStore.this.cleanSnapshots();
                        }
                        catch (InterruptedException e2) {
                            MemoryStore.this.logger.warn("snapshot cleanup interrupted");
                        }
                    }
                };
                this.snapshotCleanupThread = new Thread(runnable, "MemoryStore snapshot cleanup");
                this.snapshotCleanupThread.setDaemon(true);
                this.snapshotCleanupThread.start();
            }
        }
    }
}

